/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.video.mpeg;

import com.sun.media.BasicPlayer;
import com.sun.media.amovie.AMController;
import com.sun.media.ui.DefaultControlPanel;
import java.awt.Component;
import java.io.IOException;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.NotRealizedError;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;

public class Handler
extends BasicPlayer {
    private DefaultControlPanel controlPanel = null;
    protected AMController amController = null;
    private boolean justDeallocated = false;

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        super.setSource(source);
        try {
            if (this.amController == null) {
                this.amController = new AMController(this);
                this.amController.setSource(source);
                this.manageController(this.amController);
            }
        }
        catch (Exception e2) {
            throw new IncompatibleSourceException(e2.getMessage());
        }
    }

    protected TimeBase getMasterTimeBase() {
        return this.amController.getTimeBase();
    }

    public void updateStats() {
    }

    public Component getVisualComponent() {
        if (this.state == 100 || this.state == 200) {
            throw new NotRealizedError("Cannot get visual component from an unrealized player.");
        }
        return this.amController.getVisualComponent();
    }

    public GainControl getGainControl() {
        return super.getGainControl();
    }

    public Component getControlPanelComponent() {
        return super.getControlPanelComponent();
    }

    protected boolean connectNodes() {
        return true;
    }

    protected void createGainControl() {
    }

    protected void doDeallocate() {
        super.doDeallocate();
        this.justDeallocated = true;
    }

    protected synchronized boolean doRealize() {
        boolean returnVal = super.doRealize();
        return returnVal;
    }

    protected boolean doPrefetch() {
        if (this.justDeallocated) {
            this.setMediaTime(new Time(0L));
            this.justDeallocated = false;
        }
        return super.doPrefetch();
    }

    public void doClose() {
        super.doClose();
        this.amController = null;
    }

    public boolean audioEnabled() {
        return this.amController.audioEnabled();
    }

    public boolean videoEnabled() {
        return this.amController.videoEnabled();
    }
}

