/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.AbinitMpFile.CheckPointFile;
import AbinitMp.Common.AtomData;
import AbinitMp.Common.ChainData;
import AbinitMp.Common.GaussianInputFile;
import AbinitMp.Common.PdbFile;
import AbinitMp.Tool.ExampleFileFilter;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyRadioButton;
import AbinitMp.Tool.MyResourceBundle;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class GaussianInputFilePanel
extends GridBagLayoutPanel {
    private JTextArea optionsText;
    private JTextArea routeText;
    private JTextArea titleText;
    private JTextField chargeText;
    private JTextArea moleculeText;
    private JLabel moleculeFileLabel;
    private PdbFile pdbFile;
    private MyRadioButton hoptOnRadioButton;
    private MyRadioButton hoptOffRadioButton;
    private GridBagLayoutPanel optimizePanel = new GridBagLayoutPanel();
    private GridBagLayoutPanel fmoPanel = new GridBagLayoutPanel();
    private GridBagLayoutPanel autoPanel = new GridBagLayoutPanel();
    JScrollPane moleculeScrollPane;
    private JFileChooser pdbOpenFileChooser;

    public GaussianInputFilePanel() {
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter(new String[]{"pdb", "ent"}, "PDB file");
        ExampleFileFilter exampleFileFilter2 = new ExampleFileFilter("cpf", "Check Point file");
        this.pdbOpenFileChooser = new JFileChooser(".");
        FileFilter fileFilter = this.pdbOpenFileChooser.getFileFilter();
        this.pdbOpenFileChooser.addChoosableFileFilter(exampleFileFilter);
        this.pdbOpenFileChooser.addChoosableFileFilter(exampleFileFilter2);
        this.pdbOpenFileChooser.setFileFilter(fileFilter);
        this.pdbOpenFileChooser.setPreferredSize(new Dimension(500, 500));
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.options")), 0, 0, 5, 3, 1.0, 0.0);
        this.optionsText = new JTextArea();
        this.optionsText.setRows(3);
        this.optionsText.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.optionsText, 22, 31);
        this.layoutObject(jScrollPane, 5, 0, 5, 3, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.route")), 0, 3, 5, 3, 1.0, 0.0);
        this.routeText = new JTextArea("HF/6-31G(d,p) POPT SCF=TIGHT");
        this.routeText.setRows(3);
        this.routeText.setLineWrap(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.routeText, 22, 31);
        this.layoutObject(jScrollPane2, 5, 3, 5, 3, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.title")), 0, 6, 5, 3, 1.0, 0.0);
        this.titleText = new JTextArea("title");
        this.titleText.setRows(3);
        this.titleText.setLineWrap(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.titleText, 22, 31);
        this.layoutObject(jScrollPane3, 5, 6, 5, 3, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.charge")), 0, 9, 5, 1, 1.0, 0.0);
        this.chargeText = new JTextField("0, 1", 30);
        this.layoutObject(this.chargeText, 5, 9, 5, 1, 1.0, 0.0);
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.hopt")), 0, 10, 5, 1, 1.0, 0.0);
        this.hoptOnRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("on"));
        this.hoptOffRadioButton = new MyRadioButton(MyResourceBundle.getResourceString("off"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hoptOnRadioButton);
        buttonGroup.add(this.hoptOffRadioButton);
        FlowLayout flowLayout = new FlowLayout(0);
        MyPanel myPanel = new MyPanel(flowLayout);
        myPanel.add(this.hoptOnRadioButton);
        myPanel.add(this.hoptOffRadioButton);
        this.hoptOnRadioButton.setSelected(true);
        this.layoutObject(myPanel, 5, 10, 5, 1, 1.0, 0.0);
        this.hoptOnRadioButton.addActionListener(new hoptListener());
        this.hoptOffRadioButton.addActionListener(new hoptListener());
        this.layoutObject(new JLabel(MyResourceBundle.getResourceString("GaussianInputFilePanel.molecule")), 0, 11, 5, 1, 1.0, 0.0);
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("file"));
        myButton.addActionListener(new pdbOpenListener());
        this.moleculeFileLabel = new JLabel();
        MyPanel myPanel2 = new MyPanel(flowLayout);
        myPanel2.add(myButton);
        myPanel2.add(this.moleculeFileLabel);
        this.layoutObject(myPanel2, 5, 11, 5, 1, 1.0, 0.0);
        this.moleculeText = new JTextArea();
        this.moleculeText.setRows(10);
        this.moleculeText.setLineWrap(true);
        this.moleculeScrollPane = new JScrollPane(this.moleculeText, 22, 31);
        this.layoutObject(this.moleculeScrollPane, 5, 12, 5, 10, 1.0, 0.0);
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n != -1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public void setOptions(String string) {
        this.optionsText.setText(string);
    }

    public void setRoute(String string) {
        this.routeText.setText(string);
    }

    public void setTitle(String string) {
        this.titleText.setText(string);
    }

    public void setCharge(String string) {
        this.chargeText.setText(string);
    }

    public void setMolecule(String string) {
        this.moleculeText.setText(string);
    }

    public void setMolecule() {
        int n;
        Object object;
        Object object2;
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.moleculeText.getText());
        Vector<AtomData> vector = new Vector<AtomData>();
        Vector<AtomData> vector2 = new Vector<AtomData>();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object3;
            string = stringTokenizer.nextToken();
            if (Character.isDigit(string.charAt(string.length() - 1))) {
                for (int i = 0; i < n2; ++i) {
                    stringTokenizer.nextToken();
                    object2 = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    object = stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    object3 = stringTokenizer.nextToken();
                    AtomData atomData = (AtomData)vector2.get(i);
                    atomData.x = Float.parseFloat((String)object2);
                    atomData.y = Float.parseFloat((String)object);
                    atomData.z = Float.parseFloat((String)object3);
                    if (i >= n2 - 1) continue;
                    stringTokenizer.nextToken();
                }
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            object3 = new AtomData();
            vector.add((AtomData)object3);
            ((AtomData)object3).atomName = string;
            if (string2.equals("0")) {
                for (int i = 0; i < 3; ++i) {
                    stringTokenizer.nextToken();
                }
                vector2.add((AtomData)object3);
                ++n2;
                continue;
            }
            object2 = stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            ((AtomData)object3).x = Float.parseFloat(string2);
            ((AtomData)object3).y = Float.parseFloat((String)object2);
            ((AtomData)object3).z = Float.parseFloat((String)object);
        }
        string = new String();
        Vector<Float> vector3 = new Vector<Float>();
        object2 = new Vector();
        object = new Vector();
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            AtomData atomData = (AtomData)vector.get(n);
            string = string.concat(atomData.atomName + " ");
            if (atomData.atomName.equals("H") && this.hoptOnRadioButton.isSelected()) {
                string = string.concat("0 ");
                string = string.concat("x" + n2 + " y" + n2 + " z" + n2 + "\n");
                ++n2;
                vector3.add(new Float(atomData.x));
                ((Vector)object2).add(new Float(atomData.y));
                ((Vector)object).add(new Float(atomData.z));
                continue;
            }
            string = string.concat("  ");
            string = string.concat(atomData.x + " " + atomData.y + " " + atomData.z + "\n");
        }
        if (n2 > 0) {
            string = string.concat("\n");
            for (n = 0; n < n2; ++n) {
                string = string.concat("x" + n + " = " + (Float)vector3.get(n) + "\n" + "y" + n + " = " + (Float)((Vector)object2).get(n) + "\n" + "z" + n + " = " + (Float)((Vector)object).get(n) + "\n");
            }
        }
        this.moleculeText.setText(string);
        this.moleculeText.setCaretPosition(0);
    }

    public void setMolecule(PdbFile pdbFile) {
        int n;
        String string = new String();
        this.pdbFile = pdbFile;
        this.moleculeFileLabel.setText(this.pdbFile.filename);
        int n2 = 0;
        Vector<Float> vector = new Vector<Float>();
        Vector<Float> vector2 = new Vector<Float>();
        Vector<Float> vector3 = new Vector<Float>();
        for (n = 0; n < pdbFile.chains.size(); ++n) {
            AtomData atomData;
            int n3;
            ChainData chainData = (ChainData)pdbFile.chains.get(n);
            Vector vector4 = chainData.atomTable;
            Vector vector5 = chainData.hemTable;
            for (n3 = 0; n3 < vector4.size(); ++n3) {
                atomData = (AtomData)vector4.get(n3);
                string = string.concat(atomData.atomName + " ");
                if (atomData.atomName.equals("H") && this.hoptOnRadioButton.isSelected()) {
                    string = string.concat("0 ");
                    string = string.concat("x" + n2 + " y" + n2 + " z" + n2 + "\n");
                    ++n2;
                    vector.add(new Float(atomData.x));
                    vector2.add(new Float(atomData.y));
                    vector3.add(new Float(atomData.z));
                    continue;
                }
                string = string.concat("  ");
                string = string.concat(atomData.x + " " + atomData.y + " " + atomData.z + "\n");
            }
            for (n3 = 0; n3 < vector5.size(); ++n3) {
                atomData = (AtomData)vector5.get(n3);
                string = string.concat(atomData.atomName + " ");
                if (atomData.atomName.equals("H") && this.hoptOnRadioButton.isSelected()) {
                    string = string.concat("0 ");
                    string = string.concat("x" + n2 + " y" + n2 + " z" + n2 + "\n");
                    ++n2;
                    vector.add(new Float(atomData.x));
                    vector2.add(new Float(atomData.y));
                    vector3.add(new Float(atomData.z));
                    continue;
                }
                string = string.concat("  ");
                string = string.concat(atomData.x + " " + atomData.y + " " + atomData.z + "\n");
            }
        }
        if (n2 > 0) {
            string = string.concat("\n");
            for (n = 0; n < n2; ++n) {
                string = string.concat("x" + n + " = " + (Float)vector.get(n) + "\n" + "y" + n + " = " + (Float)vector2.get(n) + "\n" + "z" + n + " = " + (Float)vector3.get(n) + "\n");
            }
        }
        this.moleculeText.setText(string);
        this.moleculeText.setCaretPosition(0);
    }

    public String getOptions() {
        return this.optionsText.getText();
    }

    public String getRoute() {
        return this.routeText.getText();
    }

    public String getTitle() {
        return this.titleText.getText();
    }

    public String getCharge() {
        return this.chargeText.getText();
    }

    public String getMolecule() {
        return this.moleculeText.getText();
    }

    public void setParameter(GaussianInputFile gaussianInputFile) {
        this.optionsText.setText(gaussianInputFile.getOptions());
        this.routeText.setText(gaussianInputFile.getRoute());
        this.titleText.setText(gaussianInputFile.getTitle());
        this.chargeText.setText(gaussianInputFile.getCharge());
        this.moleculeText.setText(gaussianInputFile.getMolecule());
    }

    public void setParameterToFile(GaussianInputFile gaussianInputFile) {
        gaussianInputFile.set(this.optionsText.getText(), this.routeText.getText(), this.titleText.getText(), this.chargeText.getText(), this.moleculeText.getText());
    }

    class pdbOpenListener
    extends AbstractAction {
        pdbOpenListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GaussianInputFilePanel.this.pdbOpenFileChooser.showOpenDialog(null) == 0) {
                String string = GaussianInputFilePanel.this.pdbOpenFileChooser.getSelectedFile().getPath();
                String string2 = GaussianInputFilePanel.this.getExtension(string);
                PdbFile pdbFile = null;
                if (string2.equals("cpf")) {
                    CheckPointFile checkPointFile = new CheckPointFile(string);
                    if (checkPointFile.filename != null) {
                        pdbFile = checkPointFile.pdbFile;
                    }
                } else if (string2.equals("pdb") || string2.equals("ent")) {
                    PdbFile pdbFile2 = new PdbFile(string);
                    if (pdbFile2.filename != null) {
                        pdbFile = pdbFile2;
                    }
                }
                if (pdbFile != null) {
                    GaussianInputFilePanel.this.setMolecule(pdbFile);
                }
            }
        }
    }

    class hoptListener
    extends AbstractAction {
        hoptListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GaussianInputFilePanel.this.setMolecule();
        }
    }
}

