/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.cybergarage.x3d.field.FieldTokenizer;

public class StringValue
implements Serializable {
    private String mValue;
    private String mWhitespaceChars;
    private String mWordChars;

    public StringValue(String value) {
        this.setValue(value);
        this.setWhitespaceChars(null);
        this.setWordChars(null);
    }

    public StringValue(String value, String whitespaceChars) {
        this.setValue(value);
        this.setWhitespaceChars(whitespaceChars);
        this.setWordChars(null);
    }

    public StringValue(String value, String whitespaceChars, String wordChars) {
        this.setValue(value);
        this.setWhitespaceChars(whitespaceChars);
        this.setWordChars(wordChars);
    }

    public void setValue(String value) {
        this.mValue = value;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setWhitespaceChars(String value) {
        this.mWhitespaceChars = value;
    }

    public String getWhitespaceChars() {
        return this.mWhitespaceChars;
    }

    public void setWordChars(String value) {
        this.mWordChars = value;
    }

    public String getWordChars() {
        return this.mWordChars;
    }

    public String[] getTokens() {
        FieldTokenizer stream = new FieldTokenizer(this.getValue(), this.getWhitespaceChars(), this.getWordChars());
        Vector<String> tokenBuffer = new Vector<String>();
        try {
            stream.nextToken();
            while (stream.ttype != -1) {
                switch (stream.ttype) {
                    case -3: {
                        tokenBuffer.addElement(new String(stream.sval));
                        break;
                    }
                    case -2: {
                        if (stream.nval % 1.0 == 0.0) {
                            tokenBuffer.addElement(Integer.toString((int)stream.nval));
                            break;
                        }
                        tokenBuffer.addElement(Double.toString(stream.nval));
                    }
                }
                stream.nextToken();
            }
        }
        catch (IOException e) {
            return null;
        }
        String[] tokens = new String[tokenBuffer.size()];
        for (int n = 0; n < tokenBuffer.size(); ++n) {
            tokens[n] = (String)tokenBuffer.elementAt(n);
        }
        return tokens;
    }
}

