/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.filechooser;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.MyUserInfo;
import ciss.phase_viewer.ssh.sftp.Sftp;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.net.URI;
import java.util.Calendar;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RemoteFile
extends File {
    private static Logger logger = Logger.getLogger(RemoteFile.class.getName());
    private ChannelSftp c;
    private Sftp sftp;
    private MyUserInfo userinfo;
    private boolean isRemote = false;
    private File file;
    private String pathname;
    private String FS = System.getProperty("file.separator");
    private boolean isRoot = false;
    private ChaseFile chaseFile;
    private boolean overwrite = true;

    public RemoteFile(File parent, String child) {
        super(parent, child);
        this.file = new File(parent, child);
        this.pathname = parent.getAbsolutePath() + this.FS + child;
    }

    public RemoteFile(String pathname) {
        super(pathname);
        this.file = new File(pathname);
        this.pathname = pathname;
    }

    public RemoteFile(String parent, String child) {
        super(parent, child);
        this.file = new File(parent, child);
        this.pathname = parent + this.FS + child;
    }

    public RemoteFile(URI uri) {
        super(uri);
        this.file = new File(uri);
        this.pathname = uri.getPath();
    }

    public RemoteFile(File parent, String child, ChannelSftp c2) {
        super(parent, child);
        this.file = new File(parent, child);
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
        this.pathname = parent.getAbsolutePath() + this.FS + child;
    }

    public RemoteFile(String pathname, ChannelSftp c2) {
        super(pathname);
        this.file = new File(pathname);
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
        this.pathname = pathname;
    }

    public RemoteFile(String parent, String child, ChannelSftp c2) {
        super(parent, child);
        this.file = new File(parent, child);
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
        this.pathname = parent + this.FS + child;
    }

    public RemoteFile(URI uri, ChannelSftp c2) {
        super(uri);
        this.file = new File(uri);
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
        this.pathname = uri.getPath();
    }

    public void setChaseFile(ChaseFile cfile) {
        this.chaseFile = cfile;
    }

    public ChaseFile getChaseFile() {
        return this.chaseFile;
    }

    public void setUserInfo(MyUserInfo userinfo) {
        this.userinfo = userinfo;
    }

    public boolean equals(Object obj) {
        RemoteFile fi = null;
        try {
            fi = (RemoteFile)obj;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (fi == null) {
            return false;
        }
        return this.getAbsolutePath().equals(fi.getAbsolutePath());
    }

    public File getJavaIOFile() {
        return this.file;
    }

    public void setChannelSftp(ChannelSftp c2) {
        this.c = c2;
        if (c2 != null) {
            this.isRemote = true;
            this.FS = "/";
        }
    }

    public String getParent() {
        String pd;
        if (!this.isRemote) {
            return super.getParent();
        }
        try {
            String pd_buff = this.c.pwd();
            this.c.cd("..");
            pd = this.c.pwd();
            this.c.cd(pd_buff);
        }
        catch (SftpException se) {
            logger.error("failed to change dir.");
            return this.pathname;
        }
        return pd;
    }

    public File getParentFile() {
        logger.debug("getting parent file ...");
        int maxdirdepth = 100;
        String d = PropertiesManager.getGlobalProperties(0).getProperty("sftp_client_max_dir_depth");
        if (d != null) {
            try {
                maxdirdepth = Integer.parseInt(d);
            }
            catch (NumberFormatException nfe) {
                maxdirdepth = 100;
            }
        }
        if (!this.isRemote) {
            File parent = this.file.getParentFile();
            if (parent != null) {
                return new RemoteFile(parent.getAbsolutePath());
            }
            return null;
        }
        String pd = new String();
        String pd_buff = "";
        String[] pd_buffs = this.pathname.split(this.FS);
        int len = 0;
        len = this.isDirectory() ? pd_buffs.length : pd_buffs.length - 1;
        logger.debug("num. parent dir: " + len);
        if (len == 0) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            pd_buff = pd_buff + pd_buffs[i];
            if (i == len - 1) continue;
            pd_buff = pd_buff + this.FS;
        }
        logger.debug("parent file: " + pd_buff);
        if (pd_buff.equals(this.FS)) {
            return null;
        }
        logger.debug("cd'ing dir to: " + pd_buff);
        try {
            this.c.cd(pd_buff);
            if (this.isDirectory()) {
                this.c.cd("..");
                pd_buff = this.c.pwd();
            }
        }
        catch (SftpException se) {
            // empty catch block
        }
        logger.debug("returning file: " + pd_buff);
        return new RemoteFile(pd_buff, this.c);
    }

    public ChannelSftp getChannelSftp() {
        return this.c;
    }

    public boolean exists() {
        if (!this.isRemote) {
            return super.exists();
        }
        boolean ret = true;
        try {
            SftpATTRS attrs = this.c.stat(this.pathname);
        }
        catch (SftpException se) {
            ret = false;
        }
        return ret;
    }

    public String getSeparator() {
        return this.FS;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public File[] listFiles() {
        RemoteFile[] rfiles = null;
        if (!this.isRemote) {
            File[] files = super.listFiles();
            if (files != null) {
                rfiles = new RemoteFile[files.length];
                for (int i = 0; i < files.length; ++i) {
                    rfiles[i] = new RemoteFile(files[i].getAbsolutePath());
                }
            }
            return rfiles;
        }
        if (!this.isDirectory()) {
            return null;
        }
        try {
            Vector lsres = this.c.ls(this.pathname);
            if (lsres != null) {
                rfiles = new RemoteFile[lsres.size()];
                for (int i = 0; i < lsres.size(); ++i) {
                    logger.debug(lsres.elementAt(i));
                    ChannelSftp.LsEntry lsentry = (ChannelSftp.LsEntry)lsres.elementAt(i);
                    String lsstr = lsentry.getLongname();
                    String[] elems = lsstr.split("[\\s]+");
                    if (elems.length < 9) {
                        return null;
                    }
                    String name = this.pathname;
                    if (!name.trim().endsWith(this.FS)) {
                        name = name + this.FS;
                    }
                    for (int j2 = 0; j2 < elems.length - 8; ++j2) {
                        name = name + elems[j2 + 8];
                    }
                    rfiles[i] = new RemoteFile(name, this.c);
                }
            }
        }
        catch (SftpException se) {
            logger.debug("failed to perform the command \"ls\" for path " + this.pathname);
        }
        return rfiles;
    }

    public String getName() {
        if (!this.isRemote) {
            return super.getName();
        }
        String[] pathelems = this.pathname.split(this.FS);
        String ret = "";
        if (pathelems != null && pathelems.length != 0) {
            ret = pathelems[pathelems.length - 1];
        }
        return ret;
    }

    public boolean isDirectory() {
        if (!this.isRemote) {
            return super.isDirectory();
        }
        boolean ret = false;
        try {
            SftpATTRS attrs = this.c.stat(this.pathname);
            ret = attrs.isDir();
        }
        catch (SftpException se) {
            logger.debug("couldn't stat path: " + this.pathname);
        }
        return ret;
    }

    public String getAbsolutePath() {
        if (!this.isRemote) {
            return super.getAbsolutePath();
        }
        return this.pathname;
    }

    public boolean mkdir() {
        if (!this.isRemote) {
            return super.mkdir();
        }
        try {
            this.c.mkdir(this.pathname);
            return true;
        }
        catch (SftpException se) {
            return false;
        }
    }

    public boolean mkdirs() {
        int maxdirdepth = 500;
        if (!this.isRemote || this.c == null) {
            return super.mkdirs();
        }
        String tmpstring = this.pathname.toString();
        String trimmeddir = new String();
        Vector<String> trimmeddirs = new Vector<String>();
        for (int dircount = 0; !this.exists(tmpstring) || dircount < maxdirdepth; ++dircount) {
            String[] rets = this.parentPath(tmpstring);
            tmpstring = rets[0];
            trimmeddir = rets[1];
            logger.debug("tmpstring, trimmed string: " + tmpstring + " " + trimmeddir);
            trimmeddirs.addElement(trimmeddir.toString());
            if (this.exists(tmpstring)) break;
        }
        logger.debug("tmpstring: " + tmpstring);
        String newdir = tmpstring;
        for (int i = trimmeddirs.size() - 1; i >= 0; --i) {
            logger.debug("trimmed dir: " + trimmeddirs.elementAt(i));
            RemoteFile nrf = new RemoteFile(newdir, this.c);
            newdir = newdir + (String)trimmeddirs.elementAt(i) + "/";
            nrf = new RemoteFile(newdir, this.c);
            if (nrf.mkdir()) continue;
            return false;
        }
        return true;
    }

    private boolean exists(String str) {
        RemoteFile rf = new RemoteFile(str, this.c);
        return rf.exists();
    }

    private String[] parentPath(String str) {
        String[] rets = new String[2];
        String ret = "";
        String trim = "";
        String[] paths = str.split("/");
        if (paths == null || paths.length == 0) {
            ret = "/";
            trim = "";
        } else {
            for (int i = 0; i < paths.length - 1; ++i) {
                ret = ret + paths[i] + "/";
            }
            trim = paths[paths.length - 1].toString();
        }
        rets[0] = ret;
        rets[1] = trim;
        return rets;
    }

    public String toString() {
        if (!this.isRemote) {
            return super.toString();
        }
        return this.pathname;
    }

    public boolean canRead() {
        if (!this.isRemote) {
            return super.canRead();
        }
        try {
            Vector lsres = this.c.ls(this.pathname);
            if (lsres != null) {
                for (int i = 0; i < lsres.size(); ++i) {
                    String lsstr = ((ChannelSftp.LsEntry)lsres.elementAt(i)).getLongname();
                    String[] elems = lsstr.split("[\\s]+");
                    if (elems.length < 9) {
                        logger.warn("invalid output from 'ls -l' command");
                        return false;
                    }
                    String permission = elems[0];
                    char[] per = permission.toCharArray();
                    if (per == null || per.length <= 4) continue;
                    return new Character(per[1]).equals(new Character('r'));
                }
            }
        }
        catch (SftpException se) {
            logger.debug("failed to perform the command \"ls\" for path " + this.pathname);
        }
        return false;
    }

    public boolean canWrite() {
        if (!this.isRemote) {
            return super.canWrite();
        }
        try {
            Vector lsres = this.c.ls(this.pathname);
            if (lsres != null) {
                for (int i = 0; i < lsres.size(); ++i) {
                    String lsstr = ((ChannelSftp.LsEntry)lsres.elementAt(i)).getLongname();
                    String[] elems = lsstr.split("[\\s]+");
                    if (elems.length < 9) {
                        logger.warn("invalid output from 'ls -l' command");
                        return false;
                    }
                    String permission = elems[0];
                    char[] per = permission.toCharArray();
                    if (per == null || per.length <= 4) continue;
                    return new Character(per[1]).equals(new Character('w'));
                }
            }
        }
        catch (SftpException se) {
            logger.debug("failed to perform the command \"ls\" for path " + this.pathname);
        }
        return false;
    }

    public long lastModified() {
        boolean dir = false;
        long lastmodified = 0L;
        if (!this.isRemote) {
            return super.lastModified();
        }
        int mtime = 0;
        try {
            Vector lsres = this.c.ls(this.pathname);
            if (this.isDirectory()) {
                dir = true;
            }
            if (lsres != null) {
                for (int i = 0; i < lsres.size(); ++i) {
                    ChannelSftp.LsEntry lsentry = (ChannelSftp.LsEntry)lsres.elementAt(i);
                    mtime = lsentry.getAttrs().getMTime();
                }
            }
        }
        catch (SftpException se) {
            logger.debug("failed to perform the command \"ls\" for path " + this.pathname);
        }
        return mtime;
    }

    private long computeLastModified(String[] elems) {
        Calendar calendar = Calendar.getInstance();
        String month = elems[5];
        month = month.trim().toLowerCase();
        String day = elems[6];
        String time = elems[7];
        int iyear = 0;
        int imonth = 1;
        int iday = 1;
        int ihour = 0;
        int iminute = 0;
        boolean isec = false;
        if (month.startsWith("jan")) {
            imonth = 1;
        } else if (month.startsWith("feb")) {
            imonth = 2;
        } else if (month.startsWith("mar")) {
            imonth = 3;
        } else if (month.startsWith("apr")) {
            imonth = 4;
        } else if (month.startsWith("may")) {
            imonth = 5;
        } else if (month.startsWith("jun")) {
            imonth = 6;
        } else if (month.startsWith("jul")) {
            imonth = 7;
        } else if (month.startsWith("aug")) {
            imonth = 8;
        } else if (month.startsWith("sep")) {
            imonth = 9;
        } else if (month.startsWith("oct")) {
            imonth = 10;
        } else if (month.startsWith("nov")) {
            imonth = 11;
        } else if (month.startsWith("dec")) {
            imonth = 12;
        }
        try {
            iday = Integer.parseInt(day);
        }
        catch (NumberFormatException nfe) {
            logger.warn("date-info not valid for " + this.pathname);
        }
        String[] times = time.split(":");
        if (times.length == 2) {
            iyear = calendar.get(1);
            try {
                ihour = Integer.parseInt(times[0]);
                iminute = Integer.parseInt(times[1]);
            }
            catch (NumberFormatException nfe) {
                logger.warn("time-info not valid for " + this.pathname);
            }
        } else {
            try {
                iyear = Integer.parseInt(time);
                ihour = 0;
                iminute = 0;
            }
            catch (NumberFormatException nfe) {
                logger.warn("year-info not valid for " + this.pathname);
            }
        }
        calendar.set(iyear, --imonth, iday, ihour, iminute);
        return calendar.getTimeInMillis();
    }

    public long length() {
        if (!this.isRemote) {
            return super.length();
        }
        long ret = 0L;
        try {
            Vector lsres = this.c.ls(this.pathname);
            if (lsres != null) {
                for (int i = 0; i < lsres.size(); ++i) {
                    String lsstr = ((ChannelSftp.LsEntry)lsres.elementAt(i)).getLongname();
                    String[] elems = lsstr.split("[\\s]+");
                    if (elems.length < 9) {
                        logger.warn("invalid output from 'ls -l' command");
                        return 0L;
                    }
                    String size = elems[4];
                    try {
                        ret = Long.valueOf(size);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        ret = 0L;
                    }
                }
            }
            return ret;
        }
        catch (SftpException se) {
            logger.debug("failed to perform the command \"ls\" for path " + this.pathname);
            return 0L;
        }
    }

    public boolean renameTo(File rfile) {
        if (!this.isRemote) {
            File rrfile = new File(rfile.getAbsolutePath());
            return super.renameTo(rrfile);
        }
        String renamepath = rfile.getAbsolutePath();
        try {
            logger.debug("renaming " + this.pathname + " to " + renamepath);
            this.c.rename(this.pathname, renamepath);
            return true;
        }
        catch (SftpException se) {
            logger.warn("failed rename.");
            return false;
        }
    }

    public boolean delete() {
        if (!this.isRemote) {
            return super.delete();
        }
        try {
            this.c.rm(this.pathname);
            return true;
        }
        catch (SftpException se) {
            logger.error("failed rename.");
            return false;
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void isRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void overwrite(boolean overwrite2) {
        this.overwrite = overwrite2;
    }

    public boolean overwrite() {
        return this.overwrite;
    }
}

