/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.mainpanel.DefaultInternalFrameChase;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeriesCollection;

public class SimpleChart {
    private Logger logger = Logger.getLogger(SimpleChart.class.getName());
    private Vector yAxis = new Vector();
    private Vector xAxis = new Vector();
    private Vector xyCollections = new Vector();
    private Dimension size = new Dimension(512, 512);
    private XYPlot plot = new XYPlot();
    private String title = "";
    private String chartTitle = null;
    private CombinedDomainXYPlot combinedPlot;
    private boolean createLegend = true;
    private InternalFrameChase graph;
    private ChartProgressListener chartProgressListener;
    private JFreeChart chart;

    public SimpleChart(XYData[] xyData) {
        HashMap<Integer, XYSeriesCollection> collections = new HashMap<Integer, XYSeriesCollection>();
        NumberAxis domainAxis = null;
        for (int i = 0; i < xyData.length; ++i) {
            int colind = xyData[i].collectionIndex;
            XYSeriesCollection col = (XYSeriesCollection)collections.get(new Integer(colind));
            if (col == null) {
                col = new XYSeriesCollection();
                collections.put(new Integer(colind), col);
            }
            col.addSeries(xyData[i].getXYSeries());
            NumberAxis xva = null;
            NumberAxis yva = null;
            if (xyData[i].xisLog) {
                xva = new LogarithmicAxis(xyData[i].xAxisName);
                ((LogarithmicAxis)xva).setLog10TickLabelsFlag(true);
                ((LogarithmicAxis)xva).setAutoRangeIncludesZero(false);
            } else {
                xva = new NumberAxis(xyData[i].xAxisName);
                ((NumberAxis)xva).setAutoRangeIncludesZero(false);
            }
            if (xyData[i].yisLog) {
                yva = new LogarithmicAxis(xyData[i].yAxisName);
                ((LogarithmicAxis)yva).setLog10TickLabelsFlag(true);
                ((LogarithmicAxis)yva).setAutoRangeIncludesZero(false);
            } else {
                yva = new NumberAxis(xyData[i].yAxisName);
                ((NumberAxis)yva).setAutoRangeIncludesZero(false);
            }
            if (xyData[i].xValType == XYData.INTEGER) {
                xva.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
            if (xyData[i].yValType == XYData.INTEGER) {
                yva.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
            if (this.plot.getDomainAxis(0) == null) {
                this.plot.setDomainAxis(0, xva);
            }
            if (this.plot.getRangeAxis(xyData[i].collectionIndex) == null) {
                this.plot.setRangeAxis(xyData[i].collectionIndex, yva);
                this.plot.setRangeAxisLocation(xyData[i].collectionIndex, xyData[i].yAxisLocation);
                this.plot.mapDatasetToRangeAxis(xyData[i].collectionIndex, xyData[i].collectionIndex);
            }
            this.plot.setDataset(xyData[i].collectionIndex, col);
            StandardXYItemRenderer renderer = (StandardXYItemRenderer)this.plot.getRenderer(xyData[i].collectionIndex);
            if (renderer == null) {
                renderer = new StandardXYItemRenderer();
                this.plot.setRenderer(xyData[i].collectionIndex, renderer);
            }
            if (xyData[i].seriesColor != null && xyData[i].seriesIndex >= 0) {
                renderer.setSeriesPaint(xyData[i].seriesIndex, xyData[i].seriesColor);
            }
            domainAxis = xva;
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public XYPlot getPlot() {
        return this.plot;
    }

    public void createLegend(boolean createLegend) {
        this.createLegend = createLegend;
    }

    public void setChartProgressListener(ChartProgressListener chartProgressListener) {
        this.chartProgressListener = chartProgressListener;
    }

    public JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = new JFreeChart(this.plot);
            if (this.chartTitle != null) {
                this.chart.setTitle(this.chartTitle);
            }
            if (!this.createLegend) {
                this.chart.removeLegend();
            }
            if (this.chartProgressListener != null) {
                this.chart.addProgressListener(this.chartProgressListener);
            }
        }
        return this.chart;
    }

    public Dimension getSize() {
        return this.size;
    }

    public String getFrameTitle() {
        return this.title;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void createChart() {
        this.chart = this.getChart();
        this.graph = new DefaultInternalFrameChase(this.title, this.size);
        this.graph.setSize(this.size);
        ChartPanel chartPanel = new ChartPanel(this.chart, true, true, true, true, true);
        this.graph.getContentPane().add(chartPanel);
    }

    public InternalFrameChase getGraph() {
        return this.graph;
    }
}

