/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.Atom;
import ciss.phase_viewer.atomcoord.pmodel.PmodelRuntimeException;

final class PointGroupOperation {
    PointGroup pointGroup;
    private int ng0;
    int[][][] opMat;
    int[][] table;
    int[] inv;

    public static void main(String[] args) {
        int j;
        int i;
        int n;
        PointGroupOperation pgo = new PointGroupOperation(PointGroup.Oh);
        for (n = 0; n < pgo.ng0; ++n) {
            System.out.printf("%3d\n", n);
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    System.out.printf("%3d", pgo.opMat[n][i][j]);
                }
                System.out.printf("\n", new Object[0]);
            }
            System.out.printf("\n", new Object[0]);
        }
        for (i = 0; i < pgo.ng0; ++i) {
            for (j = 0; j < pgo.ng0; ++j) {
                System.out.printf("%3d", pgo.table[i][j] + 1);
            }
            System.out.printf("\n", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
        for (n = 0; n < pgo.ng0; ++n) {
            System.out.printf("%3d", pgo.inv[n] + 1);
        }
        System.out.printf("\n", new Object[0]);
    }

    PointGroupOperation(PointGroup pg) {
        this.pointGroup = pg;
        switch (this.pointGroup) {
            case Oh: {
                this.ng0 = 48;
                this.opMat = new int[this.ng0][3][3];
                this.table = new int[this.ng0][this.ng0];
                this.inv = new int[this.ng0];
                this.operationMatricesOh();
                break;
            }
            case D6h: {
                this.ng0 = 24;
                this.opMat = new int[this.ng0][3][3];
                this.table = new int[this.ng0][this.ng0];
                this.inv = new int[this.ng0];
                this.operationMatricesD6h();
                break;
            }
            default: {
                PmodelRuntimeException ex = new PmodelRuntimeException();
                throw ex;
            }
        }
        this.makeMultiplicationTable();
    }

    int getNg0() {
        return this.ng0;
    }

    static PointGroup getPointGroup(int n) {
        PointGroup pg_ = n >= 143 && n <= 194 ? PointGroup.D6h : PointGroup.Oh;
        return pg_;
    }

    private void operationMatricesOh() {
        int[][] eulerOh = new int[][]{{0, 0, 0}, {0, 2, 2}, {0, 2, 0}, {0, 0, 2}, {0, 1, 1}, {2, 1, 3}, {2, 1, 1}, {0, 1, 3}, {1, 1, 2}, {3, 1, 0}, {1, 1, 0}, {3, 1, 2}, {0, 2, 1}, {0, 2, 3}, {0, 1, 2}, {1, 1, 1}, {2, 1, 0}, {3, 1, 3}, {3, 1, 1}, {0, 1, 0}, {1, 0, 0}, {1, 1, 3}, {2, 1, 2}, {3, 0, 0}};
        for (int n = 0; n < 24; ++n) {
            int cosPhi = this.cos4Oh(eulerOh[n][0]);
            int sinPhi = this.sin4Oh(eulerOh[n][0]);
            int cosTheta = this.cos4Oh(eulerOh[n][1]);
            int sinTheta = this.sin4Oh(eulerOh[n][1]);
            int cosPsi = this.cos4Oh(eulerOh[n][2]);
            int sinPsi = this.sin4Oh(eulerOh[n][2]);
            this.opMat[n][0][0] = cosPsi * cosPhi * cosTheta - sinPsi * sinPhi;
            this.opMat[n][0][1] = -sinPsi * cosPhi * cosTheta - cosPsi * sinPhi;
            this.opMat[n][0][2] = cosPhi * sinTheta;
            this.opMat[n][1][0] = cosPsi * sinPhi * cosTheta + sinPsi * cosPhi;
            this.opMat[n][1][1] = -sinPsi * sinPhi * cosTheta + cosPsi * cosPhi;
            this.opMat[n][1][2] = sinPhi * sinTheta;
            this.opMat[n][2][0] = -cosPsi * sinTheta;
            this.opMat[n][2][1] = sinPsi * sinTheta;
            this.opMat[n][2][2] = cosTheta;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.opMat[n + 24][i][j] = -this.opMat[n][i][j];
                }
            }
        }
    }

    private int cos4Oh(int angle) {
        switch (angle) {
            case 0: {
                return 1;
            }
            case 2: {
                return -1;
            }
        }
        return 0;
    }

    private int sin4Oh(int angle) {
        switch (angle) {
            case 1: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    private void operationMatricesD6h() {
        int j;
        int i;
        int n;
        int[][] opMat1 = new int[3][3];
        int[][] opMat2 = new int[3][3];
        int[][] eulerD6h = new int[][]{{0, 0, 0}, {1, 0, 0}, {2, 0, 0}, {3, 0, 0}, {4, 0, 0}, {5, 0, 0}, {0, 3, 0}, {4, 3, 0}, {2, 3, 0}, {3, 3, 0}, {1, 3, 0}, {5, 3, 0}};
        for (n = 0; n < 12; ++n) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    opMat1[i][j] = 0;
                    opMat2[i][j] = 0;
                    this.opMat[n][i][j] = 0;
                }
            }
            opMat1[2][2] = 1;
            switch (eulerD6h[n][0] % 3) {
                case 0: {
                    opMat1[0][0] = 1;
                    opMat1[1][1] = 1;
                    break;
                }
                case 1: {
                    opMat1[0][0] = 1;
                    opMat1[1][0] = 1;
                    break;
                }
                case 2: {
                    opMat1[1][0] = 1;
                    opMat1[1][1] = -1;
                }
            }
            if (eulerD6h[n][0] >= 3) {
                opMat1[0][0] = -opMat1[0][0];
                opMat1[1][0] = -opMat1[1][0];
                opMat1[1][1] = -opMat1[1][1];
            }
            opMat1[0][1] = -opMat1[1][0];
            opMat2[1][1] = 1;
            switch (eulerD6h[n][1]) {
                case 0: {
                    opMat2[0][0] = 1;
                    opMat2[2][2] = 1;
                    break;
                }
                case 3: {
                    opMat2[0][0] = -1;
                    opMat2[0][1] = 1;
                    opMat2[2][2] = -1;
                    break;
                }
                default: {
                    PmodelRuntimeException ex = new PmodelRuntimeException();
                    throw ex;
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        int[] nArray = this.opMat[n][i];
                        int n2 = j;
                        nArray[n2] = nArray[n2] + opMat2[i][k] * opMat1[k][j];
                    }
                }
            }
        }
        for (n = 0; n < 12; ++n) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    this.opMat[n + 12][i][j] = -this.opMat[n][i][j];
                }
            }
        }
    }

    private void makeMultiplicationTable() {
        int j;
        int i;
        int[][] tempMat = new int[3][3];
        for (i = 0; i < this.ng0; ++i) {
            for (j = 0; j < this.ng0; ++j) {
                this.table[i][j] = -1;
            }
        }
        for (i = 0; i < this.ng0; ++i) {
            block3: for (j = 0; j < this.ng0; ++j) {
                int k;
                for (k = 0; k < 3; ++k) {
                    for (int l = 0; l < 3; ++l) {
                        tempMat[k][l] = 0;
                        for (int m = 0; m < 3; ++m) {
                            int[] nArray = tempMat[k];
                            int n = l;
                            nArray[n] = nArray[n] + this.opMat[j][k][m] * this.opMat[i][m][l];
                        }
                    }
                }
                for (k = 0; k < this.ng0; ++k) {
                    if (!this.isIdentical(k, tempMat)) continue;
                    this.table[i][j] = k;
                    continue block3;
                }
            }
        }
        for (i = 0; i < this.ng0; ++i) {
            for (j = 0; j < this.ng0 && this.table[i][j] != 0; ++j) {
            }
            this.inv[i] = j;
        }
    }

    private boolean isIdentical(int n, int[][] mat) {
        if (n < 0 || n >= this.ng0) {
            PmodelRuntimeException ex = new PmodelRuntimeException();
            ex.message = "Illigal value of operation.";
            throw ex;
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (mat[i][j] == this.opMat[n][i][j]) continue;
                return false;
            }
        }
        return true;
    }

    Atom rotate(Atom atom, int ope) {
        Atom a1 = atom.copy();
        for (int i = 0; i < 3; ++i) {
            a1.position[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                a1.position[n] = a1.position[n] + (double)this.opMat[ope][i][j] * atom.position[j];
            }
        }
        return a1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PointGroup {
        Oh,
        D6h;

    }
}

