/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.io.CIFFileFilter;
import ciss.phase_viewer.atomcoord.io.Exporter;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CIFExporter
implements Exporter {
    private Logger logger = Logger.getLogger(CIFExporter.class.getName());

    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        int nframe = coords.length;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new File(fileName));
        }
        catch (FileNotFoundException fnf) {
            return false;
        }
        for (int i = 0; i < nframe; ++i) {
            AtomCoords coor = coords[i];
            boolean ret = this.writeAtomCoordsTo(coor, writer, i);
            if (ret) continue;
            return false;
        }
        writer.close();
        return true;
    }

    private boolean writeAtomCoordsTo(AtomCoords coor, PrintWriter writer, int i) {
        writer.println("data_frame" + String.valueOf(i));
        double[][] latvec = coor.getCell(1).getDouble();
        if (latvec == null || latvec.length != 2 || latvec[0].length != 3 || latvec[1].length != 3) {
            return false;
        }
        coor.convert(7, 8);
        writer.println("_symmetry_cell_setting triclinic");
        writer.println("_symmetry_space_group_name_H-M  'P1'");
        writer.println("_symmetry_Int_Tables_number  1");
        writer.println("_cell_length_a " + String.valueOf(latvec[0][0]));
        writer.println("_cell_length_b " + String.valueOf(latvec[0][1]));
        writer.println("_cell_length_c " + String.valueOf(latvec[0][2]));
        writer.println("_cell_angle_alpha " + String.valueOf(latvec[1][0]));
        writer.println("_cell_angle_beta  " + String.valueOf(latvec[1][1]));
        writer.println("_cell_angle_gamma " + String.valueOf(latvec[1][2]));
        int nat = coor.getNumAt();
        writer.println("loop_");
        writer.println("    _atom_site_label");
        writer.println("    _atom_site_fract_x");
        writer.println("    _atom_site_fract_y");
        writer.println("    _atom_site_fract_z");
        writer.println("    _atom_site_type_symbol");
        writer.println("    _atom_site_occupancy");
        for (int iat = 0; iat < nat; ++iat) {
            Atom atom = coor.getAtomList().getAtomAt(iat);
            String elem = atom.getElementName();
            String[] pos = atom.getPos();
            writer.println(elem + " " + pos[0] + " " + pos[1] + " " + pos[2] + " " + elem + " 0");
        }
        return true;
    }

    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    public boolean hasOptions() {
        return false;
    }

    public String getType() {
        return "CIF";
    }

    public FileFilter getFileFilter() {
        return new CIFFileFilter();
    }

    public void setOptions(HashMap options) {
    }
}

