/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.keylistener;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.MultipleAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.ACVAtomEditor;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class EditKeyListener
implements KeyListener,
PropertiesListener {
    private Logger logger = Logger.getLogger(EditKeyListener.class.getName());
    private TGAtom tgatom;
    private J3DPanel panel;
    private double transx = 0.0;
    private double transy = 0.0;
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);

    public EditKeyListener(J3DPanel panel) {
        if (panel instanceof MainPanel) {
            this.tgatom = (TGAtom)panel.getRootTransform();
        }
        this.panel = panel;
        try {
            this.transx = Double.parseDouble(this.props.getProperty("keylistener_atomtrans_x"));
            this.transy = Double.parseDouble(this.props.getProperty("keylistener_atomtrans_y"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PropertiesManager.getGlobalProperties(1);
        GlobalProperties.addPropertiesListener(this);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        CoordsViewerInterface mp;
        if (this.tgatom == null) {
            return;
        }
        if (e.getKeyCode() == 10) {
            if (this.tgatom.getSelectedAtomCount() == 0) {
                return;
            }
            AtomObject[] atoms = this.tgatom.getSelectedAtoms();
            int numSelected = atoms.length;
            if (numSelected == 1) {
                this.logger.debug("booting atom atribute edit panel ...");
                this.bootAtomEditor(Integer.parseInt(atoms[0].getID()));
            } else if (numSelected > 1) {
                MultipleAtomEditor edit = new MultipleAtomEditor(this.tgatom.getParentFrame());
                this.tgatom.getParentFrame().addDisposeOnExit(edit);
                return;
            }
        }
        if (e.getKeyCode() == 90 && e.isControlDown()) {
            mp = (CoordsViewerInterface)((Object)this.panel);
            mp.getCD().getAtomCoords().saveState();
            if (mp.getCD().getAtomCoords().getAtomList().undo()) {
                mp.getCD().setCoords(mp.getCD().getAtomCoords());
            }
            mp.getCD().getAtomCoords().finalizeState();
        }
        if (e.getKeyCode() == 89 && e.isControlDown()) {
            mp = (CoordsViewerInterface)((Object)this.panel);
            mp.getCD().getAtomCoords().saveState();
            if (mp.getCD().getAtomCoords().getAtomList().redo()) {
                mp.getCD().setCoords(mp.getCD().getAtomCoords());
            }
            mp.getCD().getAtomCoords().finalizeState();
        }
        if (e.getKeyCode() == 127) {
            mp = (CoordsViewerInterface)((Object)this.panel);
            mp.getBasicOperations().removeSelectedAtoms();
        }
        if (e.isAltDown()) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 75) {
                this.translate(0, 1);
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 74) {
                this.translate(0, -1);
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 72) {
                this.translate(-1, 0);
            } else if (e.getKeyCode() == 39 || e.getKeyCode() == 76) {
                this.translate(1, 0);
            }
        }
    }

    private void translate(int x, int y) {
        double trax = this.transx * (double)x;
        double tray = this.transy * (double)y;
        Vector3d p3d = new Vector3d(trax, tray, 0.0);
        Transform3D foo = new Transform3D();
        ((MainPanel)this.panel).getRootTransform().getTransform(foo);
        foo.invert();
        foo.transform(p3d);
        ((CoordsViewerInterface)((Object)this.panel)).getBasicOperations().translateSelectedAtoms(p3d.x, p3d.y, p3d.z);
    }

    private void bootAtomEditor(int id) {
        MainPanel mp = this.tgatom.getParentFrame();
        Atom atom = mp.getCD().getAtomCoords().getAtomList().getAtomAt(id - 1);
        this.logger.debug(atom);
        ACVAtomEditor editor = new ACVAtomEditor(mp.getData().getTableColums(), atom, false, id - 1, "edit attributes for atom no. " + new Integer(id), new Dimension(400, 250), 3, mp);
        editor.addAtomListener(mp.getBasicOperations());
        mp.addDisposeOnExit(editor);
    }

    public void propertiesStored(GlobalProperties properties) {
        try {
            this.transx = Double.parseDouble(properties.getProperty("keylistener_atomtrans_x"));
            this.transy = Double.parseDouble(properties.getProperty("keylistener_atomtrans_y"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

