/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.JavaAccessibility;
import org.python.core.Py;
import org.python.core.PyInstance;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;

public class PyReflectedFunction
extends PyObject {
    public String __name__;
    public PyObject __doc__ = Py.None;
    public ReflectedArgs[] argslist;
    public int nargs;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$python$core$PyString;

    public PyReflectedFunction(String name) {
        this.__name__ = name;
        this.argslist = new ReflectedArgs[1];
        this.nargs = 0;
    }

    public PyReflectedFunction(Method method) {
        this(method.getName());
        this.addMethod(method);
    }

    public PyObject _doget(PyObject container) {
        return this._doget(container, null);
    }

    public PyObject _doget(PyObject container, PyObject wherefound) {
        if (container == null) {
            return this;
        }
        return new PyMethod(container, this, wherefound);
    }

    public boolean _doset(PyObject container) {
        throw Py.TypeError("java function not settable: " + this.__name__);
    }

    private ReflectedArgs makeArgs(Method m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), Modifier.isStatic(m.getModifiers()));
    }

    public PyReflectedFunction copy() {
        PyReflectedFunction func = new PyReflectedFunction(this.__name__);
        func.__doc__ = this.__doc__;
        func.nargs = this.nargs;
        func.argslist = new ReflectedArgs[this.nargs];
        System.arraycopy(this.argslist, 0, func.argslist, 0, this.nargs);
        return func;
    }

    public boolean handles(Method method) {
        return this.handles(this.makeArgs(method));
    }

    protected boolean handles(ReflectedArgs args) {
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            int cmp = args.compareTo(argsl[i]);
            if (cmp == 0) {
                return true;
            }
            if (cmp != 1) continue;
            return false;
        }
        return false;
    }

    public void addMethod(Method m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && !JavaAccessibility.accessIsMutable()) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    protected void addArgs(ReflectedArgs args) {
        int nn;
        int i;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (i = 0; i < n; ++i) {
            int cmp = args.compareTo(argsl[i]);
            if (cmp == 0) {
                return;
            }
            if (cmp == 1998) {
                argsl[i] = args;
                return;
            }
            if (cmp == -1) break;
        }
        if ((nn = n + 1) > argsl.length) {
            argsl = new ReflectedArgs[nn + 2];
            System.arraycopy(this.argslist, 0, argsl, 0, n);
            this.argslist = argsl;
        }
        for (int j = n; j > i; --j) {
            argsl[j] = argsl[j - 1];
        }
        argsl[i] = args;
        this.nargs = nn;
    }

    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            if (!rargs.matches(self, args, keywords, callData)) continue;
            method = rargs.data;
            break;
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, self != null, keywords.length != 0);
        }
        Object cself = callData.self;
        Method m = (Method)method;
        if (self == null && cself != null && cself instanceof PyProxy && !this.__name__.startsWith("super__")) {
            String mname;
            Method[] super__methods;
            PyInstance iself = ((PyProxy)cself)._getPyInstance();
            if (this.argslist[0].declaringClass != iself.instclass.proxyClass && (super__methods = (Method[])iself.instclass.super__methods.get(mname = "super__" + this.__name__)) != null) {
                Object[] msig = m.getParameterTypes();
                for (int i = 0; i < super__methods.length; ++i) {
                    if (!Arrays.equals(msig, super__methods[i].getParameterTypes())) continue;
                    m = super__methods[i];
                    break;
                }
            }
        }
        try {
            Object o = m.invoke(cself, callData.getArgsArray());
            return Py.java2py(o);
        }
        catch (Throwable t) {
            throw Py.JavaError(t);
        }
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        return this.__call__(null, args, keywords);
    }

    protected void throwError(String message) {
        throw Py.TypeError(this.__name__ + "(): " + message);
    }

    private static void addRange(StringBuffer buf, int min, int max, String sep) {
        if (buf.length() > 0) {
            buf.append(sep);
        }
        if (min < max) {
            buf.append(Integer.toString(min) + "-" + max);
        } else {
            buf.append(min);
        }
    }

    protected void throwArgCountError(int nArgs, boolean self) {
        boolean[] legalArgs = new boolean[40];
        int maxArgs = -1;
        int minArgs = 40;
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            int l = rargs.args.length;
            if (!self && !rargs.isStatic) {
                ++l;
            }
            legalArgs[l] = true;
            if (l > maxArgs) {
                maxArgs = l;
            }
            if (l >= minArgs) continue;
            minArgs = l;
        }
        StringBuffer buf = new StringBuffer();
        int startRange = minArgs;
        int a = minArgs + 1;
        block1: while (a < maxArgs) {
            if (legalArgs[a]) {
                ++a;
                continue;
            }
            PyReflectedFunction.addRange(buf, startRange, a - 1, ", ");
            ++a;
            while (a <= maxArgs) {
                if (legalArgs[a]) {
                    startRange = a;
                    continue block1;
                }
                ++a;
            }
        }
        PyReflectedFunction.addRange(buf, startRange, maxArgs, " or ");
        this.throwError("expected " + buf + " args; got " + nArgs);
    }

    private static String ordinal(int n) {
        switch (n + 1) {
            case 0: {
                return "self";
            }
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n + 1) + "th";
    }

    private static String niceName(Class arg) {
        if (arg == (class$java$lang$String == null ? (class$java$lang$String = PyReflectedFunction.class$("java.lang.String")) : class$java$lang$String) || arg == (class$org$python$core$PyString == null ? (class$org$python$core$PyString = PyReflectedFunction.class$("org.python.core.PyString")) : class$org$python$core$PyString)) {
            return "String";
        }
        if (arg.isArray()) {
            return PyReflectedFunction.niceName(arg.getComponentType()) + "[]";
        }
        return arg.getName();
    }

    protected void throwBadArgError(int errArg, int nArgs, boolean self) {
        Hashtable<Class, Class> table = new Hashtable<Class, Class>();
        ReflectedArgs[] argsl = this.argslist;
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            Class[] args = rargs.args;
            int len = args.length;
            if (len != nArgs) continue;
            if (errArg == -1) {
                table.put(rargs.declaringClass, rargs.declaringClass);
                continue;
            }
            table.put(args[errArg], args[errArg]);
        }
        StringBuffer buf = new StringBuffer();
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Class arg = (Class)keys.nextElement();
            String name = PyReflectedFunction.niceName(arg);
            if (keys.hasMoreElements()) {
                buf.append(name);
                buf.append(", ");
                continue;
            }
            if (buf.length() > 2) {
                buf.setLength(buf.length() - 2);
                buf.append(" or ");
            }
            buf.append(name);
        }
        this.throwError(PyReflectedFunction.ordinal(errArg) + " arg can't be coerced to " + buf);
    }

    protected void throwError(int errArg, int nArgs, boolean self, boolean keywords) {
        if (keywords) {
            this.throwError("takes no keyword arguments");
        }
        if (errArg == -2) {
            this.throwArgCountError(nArgs, self);
        }
        this.throwBadArgError(errArg, nArgs, self);
    }

    public void printArgs() {
        System.err.println("nargs: " + this.nargs);
        for (int i = 0; i < this.nargs; ++i) {
            ReflectedArgs args = this.argslist[i];
            System.err.println(args.toString());
        }
    }

    public String toString() {
        return "<java function " + this.__name__ + " " + Py.idstr(this) + ">";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

