/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.SphereNode;

public class SphereNodeObject
extends TriangleArray
implements NodeObject {
    private static final boolean useCreateTopBottomMetods = false;

    public SphereNodeObject(SphereNode node) {
        super(SphereNodeObject.getVertexCount(node), 35);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(18);
        this.createSphere(node);
    }

    private static int getNDivide() {
        return 16;
    }

    private static int getVertexCount(SphereNode sphere) {
        int count = 0;
        count = SphereNodeObject.getNDivide() * 2 * SphereNodeObject.getNDivide();
        return count *= 3;
    }

    public boolean initialize(Node node) {
        return true;
    }

    private void createSphere(SphereNode sphere) {
        int offset = 0;
        for (int n = 0; n < SphereNodeObject.getNDivide(); ++n) {
            this.createSide(sphere, SphereNodeObject.getNDivide(), n, offset);
            offset += SphereNodeObject.getNDivide() * 3 * 2;
        }
    }

    private void createSide(SphereNode sphere, int nDivide, int nSide, int offset) {
        Point3f[] verts = new Point3f[nDivide * 3 * 2];
        Vector3f[] norms = new Vector3f[nDivide * 3 * 2];
        Point2f[] texCoords = new Point2f[nDivide * 3 * 2];
        float radius = sphere.getRadius();
        float startDivAngle = (float)Math.PI / (float)nDivide * (float)nSide;
        float startYPos = (float)Math.cos(startDivAngle);
        float startYRadius = startYPos * radius;
        float startXRadius = (float)Math.sin(startDivAngle) * radius;
        float endDivAngle = (float)Math.PI / (float)nDivide * (float)(nSide + 1);
        float endYPos = (float)Math.cos(endDivAngle);
        float endYRadius = endYPos * radius;
        float endXRadius = (float)Math.sin(endDivAngle) * radius;
        for (int n = 0; n < nDivide; ++n) {
            float startAngle = (float)Math.PI * 2 / (float)nDivide * (float)n;
            float endAngle = (float)Math.PI * 2 / (float)nDivide * (float)(n + 1);
            float sx = (float)Math.cos(startAngle);
            float sz = (float)Math.sin(startAngle);
            float ex = (float)Math.cos(endAngle);
            float ez = (float)Math.sin(endAngle);
            verts[n * 6 + 0] = new Point3f(sx * startXRadius, startYRadius, sz * startXRadius);
            verts[n * 6 + 1] = new Point3f(ex * startXRadius, startYRadius, ez * startXRadius);
            verts[n * 6 + 2] = new Point3f(sx * endXRadius, endYRadius, sz * endXRadius);
            norms[n * 6 + 0] = new Vector3f(sx, startYPos, sz);
            norms[n * 6 + 0].normalize();
            norms[n * 6 + 1] = new Vector3f(ex, startYPos, ez);
            norms[n * 6 + 1].normalize();
            norms[n * 6 + 2] = new Vector3f(sx, endYPos, sz);
            norms[n * 6 + 2].normalize();
            texCoords[n * 6 + 0] = new Point2f((float)(n + 0) / (float)nDivide, (startYPos + 1.0f) / 2.0f);
            texCoords[n * 6 + 1] = new Point2f((float)(n + 1) / (float)nDivide, (startYPos + 1.0f) / 2.0f);
            texCoords[n * 6 + 2] = new Point2f((float)(n + 0) / (float)nDivide, (endYPos + 1.0f) / 2.0f);
            verts[n * 6 + 3] = new Point3f(ex * startXRadius, startYRadius, ez * startXRadius);
            verts[n * 6 + 4] = new Point3f(ex * endXRadius, endYRadius, ez * endXRadius);
            verts[n * 6 + 5] = new Point3f(sx * endXRadius, endYRadius, sz * endXRadius);
            norms[n * 6 + 3] = new Vector3f(ex, startYPos, ez);
            norms[n * 6 + 3].normalize();
            norms[n * 6 + 4] = new Vector3f(ex, endYPos, ez);
            norms[n * 6 + 4].normalize();
            norms[n * 6 + 5] = new Vector3f(sx, endYPos, sz);
            norms[n * 6 + 5].normalize();
            texCoords[n * 6 + 3] = new Point2f((float)(n + 1) / (float)nDivide, (startYPos + 1.0f) / 2.0f);
            texCoords[n * 6 + 4] = new Point2f((float)(n + 1) / (float)nDivide, (endYPos + 1.0f) / 2.0f);
            texCoords[n * 6 + 5] = new Point2f((float)(n + 0) / (float)nDivide, (endYPos + 1.0f) / 2.0f);
        }
        this.setCoordinates(offset, verts);
        this.setNormals(offset, norms);
        this.setTextureCoordinates(offset, texCoords);
    }

    private void createTop(SphereNode sphere, int nDivide, int offset) {
        Point3f[] verts = new Point3f[nDivide * 3];
        Vector3f[] norms = new Vector3f[nDivide * 3];
        Point2f[] texCoords = new Point2f[nDivide * 3];
        float radius = sphere.getRadius();
        float divAngle = (float)Math.PI / (float)nDivide;
        float y = (float)Math.cos(divAngle);
        float xradius = (float)Math.sin(divAngle) * radius;
        for (int n = 0; n < nDivide; ++n) {
            float endAngle = (float)Math.PI * 2 / (float)nDivide * (float)n;
            float startAngle = (float)Math.PI * 2 / (float)nDivide * (float)(n + 1);
            float sx = (float)Math.cos(startAngle);
            float sz = (float)Math.sin(startAngle);
            float ex = (float)Math.cos(endAngle);
            float ez = (float)Math.sin(endAngle);
            verts[n * 3 + 0] = new Point3f(0.0f, radius, 0.0f);
            verts[n * 3 + 1] = new Point3f(sx * xradius, y * radius, sz * xradius);
            verts[n * 3 + 2] = new Point3f(ex * xradius, y * radius, ez * xradius);
            norms[n * 3 + 0] = new Vector3f(0.0f, 1.0f, 0.0f);
            norms[n * 3 + 1] = new Vector3f(sx, y, sz);
            norms[n * 3 + 1].normalize();
            norms[n * 3 + 2] = new Vector3f(ex, y, ez);
            norms[n * 3 + 2].normalize();
            texCoords[n * 3 + 0] = new Point2f(((float)n + 0.5f) / (float)nDivide, 0.0f);
            texCoords[n * 3 + 1] = new Point2f(((float)n + 0.0f) / (float)nDivide, (y + 1.0f) / 2.0f);
            texCoords[n * 3 + 2] = new Point2f(((float)n + 1.0f) / (float)nDivide, (y + 1.0f) / 2.0f);
        }
        this.setCoordinates(offset, verts);
        this.setNormals(offset, norms);
        this.setTextureCoordinates(offset, texCoords);
    }

    private void createBottom(SphereNode sphere, int nDivide, int offset) {
        Point3f[] verts = new Point3f[nDivide * 3];
        Vector3f[] norms = new Vector3f[nDivide * 3];
        Point2f[] texCoords = new Point2f[nDivide * 3];
        float radius = sphere.getRadius();
        float divAngle = (float)Math.PI / (float)nDivide * (float)(nDivide - 1);
        float y = (float)Math.cos(divAngle);
        float xradius = (float)Math.sin(divAngle) * radius;
        for (int n = 0; n < nDivide; ++n) {
            float startAngle = (float)Math.PI * 2 / (float)nDivide * (float)n;
            float endAngle = (float)Math.PI * 2 / (float)nDivide * (float)(n + 1);
            float sx = (float)Math.cos(startAngle);
            float sz = (float)Math.sin(startAngle);
            float ex = (float)Math.cos(endAngle);
            float ez = (float)Math.sin(endAngle);
            verts[n * 3 + 0] = new Point3f(0.0f, -radius, 0.0f);
            verts[n * 3 + 1] = new Point3f(sx * xradius, y * radius, sz * xradius);
            verts[n * 3 + 2] = new Point3f(ex * xradius, y * radius, ez * xradius);
            norms[n * 3 + 0] = new Vector3f(0.0f, -1.0f, 0.0f);
            norms[n * 3 + 1] = new Vector3f(sx, y, sz);
            norms[n * 3 + 1].normalize();
            norms[n * 3 + 2] = new Vector3f(ex, y, ez);
            norms[n * 3 + 2].normalize();
            texCoords[n * 3 + 0] = new Point2f(((float)n + 0.5f) / (float)nDivide, 1.0f);
            texCoords[n * 3 + 1] = new Point2f(((float)n + 0.0f) / (float)nDivide, (y + 1.0f) / 2.0f);
            texCoords[n * 3 + 2] = new Point2f(((float)n + 1.0f) / (float)nDivide, (y + 1.0f) / 2.0f);
        }
        this.setCoordinates(offset, verts);
        this.setNormals(offset, norms);
        this.setTextureCoordinates(offset, texCoords);
    }

    public boolean uninitialize(Node node) {
        return true;
    }

    public boolean update(Node node) {
        return true;
    }

    private void setBounds(Shape3D shape3DNode, SphereNode sphereNode) {
        System.out.println("Shape3d getBoundsAutoCompute : " + shape3DNode.getBoundsAutoCompute());
        Point3d center = new Point3d(0.0, 0.0, 0.0);
        BoundingSphere bounds = new BoundingSphere(center, 0.0);
        shape3DNode.setBoundsAutoCompute(false);
        shape3DNode.setBounds((Bounds)bounds);
    }

    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

