/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d;

import java.io.Serializable;
import org.cybergarage.x3d.Constants;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.MField;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.MFNode;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.MFTime;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.share.object.ShareField;

public abstract class Field
implements Cloneable,
Constants,
Serializable {
    private String mName = null;
    private FieldType mType = null;
    private transient Node mNode = null;

    public Field() {
        this.setName(null);
        this.setType(FieldType.NONE);
        this.setNode(null);
    }

    public Field(Field field) {
        this.setObject(field.getObject());
    }

    public void setNode(Node node) {
        this.mNode = node;
    }

    public Node getNode() {
        return this.mNode;
    }

    public SceneGraph getSceneGraph() {
        Node node = this.getNode();
        if (node == null) {
            return null;
        }
        return node.getSceneGraph();
    }

    public void postShareField(Field field) {
        SceneGraph sg = this.getSceneGraph();
        if (sg == null) {
            return;
        }
        ShareField shareField = new ShareField(field);
        sg.postShareObject(shareField);
    }

    public void setType(FieldType type) {
        this.mType = type;
    }

    public FieldType getType() {
        return this.mType;
    }

    public String getTypeName() {
        return this.getType().toString();
    }

    public boolean isSameType(Field field) {
        return this.getType() == field.getType();
    }

    public boolean isSameValueType(Field field) {
        return this.getType().equals(field.getType());
    }

    public boolean isSField() {
        return !this.isMultiField();
    }

    public boolean isMField() {
        return this instanceof MField;
    }

    public boolean isSingleField() {
        return this.isSField();
    }

    public boolean isMultiField() {
        return this.isMField();
    }

    public boolean isSingleValueMField() {
        if (this instanceof MFFloat) {
            return true;
        }
        if (this instanceof MFInt32) {
            return true;
        }
        if (this instanceof MFNode) {
            return true;
        }
        if (this instanceof MFString) {
            return true;
        }
        return this instanceof MFTime;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public abstract void setValue(String var1);

    public abstract void setValue(Field var1);

    public abstract String toString();

    public abstract int getValueCount();

    public void setValue(Field field, boolean doShare) {
    }

    public String toXMLString() {
        return this.toString();
    }

    public abstract void setObject(Object var1);

    public abstract Object getObject();
}

