/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptreplace;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;
import java.io.File;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class BasicScriptReplaceRules
extends ScriptReplaceRules {
    private Logger logger = Logger.getLogger(BasicScriptReplaceRules.class.getName());
    private final String __MPIRUN__ = "__MPIRUN__";
    private final String __MPIEXEC__ = "__MPIEXEC__";
    private final String __TARGETDIR__ = "__TARGETDIR__";
    private final String __JAVADIR__ = "__JAVADIR__";
    private final String __NP__ = "__NP__";
    private final String __N__ = "__N__";
    private final String __FS__ = "__FS__";
    private final String __BINDIR__ = "__BINDIR__";
    private final String __JAVA__ = "__JAVA__";
    private final String __CHASEJAR__ = "__CHASEJAR__";
    private final String __CHASEDIR__ = "__CHASEDIR__";
    private final String __NP0__ = "__NP0__";
    private String[] keys = new String[]{"__MPIRUN__", "__MPIEXEC__", "__TARGETDIR__", "__JAVA__", "__JAVADIR__", "__NP__", "__N__", "__FS__", "__BINDIR__", "__CHASEJAR__", "__CHASEDIR__", "__NP0__"};

    public String replace(String script, Document document, boolean overwrite2) {
        Element jobcontrol;
        if (document == null || !document.hasRootElement()) {
            this.logger.error("invalid document");
            return null;
        }
        Element mpiParams = document.getRootElement().getChild("MPI_Params");
        if (mpiParams == null) {
            this.logger.warn("invalid mpiparams... using defaults");
        }
        if ((jobcontrol = document.getRootElement().getChild(JobController.JOBCONTROL)) == null) {
            this.logger.error("invalid jobcontrol element");
            return null;
        }
        Element targethost = jobcontrol.getChild("targethost");
        if (targethost == null) {
            this.logger.error("invalid 'targethost' element");
            return null;
        }
        Element env = targethost.getChild("env");
        if (env == null) {
            this.logger.error("invalid 'env' element");
            return null;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            String mpirun;
            String key = keys[i];
            if (key.equals("__MPIRUN__")) {
                String mpidir = MyElement.decode(env.getChildTextTrim("mpidir"));
                mpirun = mpidir + "/bin/mpirun";
                if (mpidir == null || mpidir.trim().length() == 0) {
                    mpirun = "mpirun";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    boolean wmpi = this.mpiSupport(env, targethost.getTextTrim());
                    mpidir = this.getMPIbinDirWin(mpidir);
                    mpirun = !wmpi ? "" : (mpidir == null ? "\"\\\\mpirun.exe\"" : "\"" + Utils.escapeBackSlash(mpidir) + "\\\\mpirun.exe" + "\"");
                }
                script = script.replaceAll(key, mpirun);
                continue;
            }
            if (key.equals("__MPIEXEC__")) {
                String mpidir = MyElement.decode(env.getChildTextTrim("mpidir"));
                mpirun = mpidir + "/bin/mpiexec";
                if (mpidir == null || mpidir.trim().length() == 0) {
                    mpirun = "mpiexec";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    boolean wmpi = this.mpiSupport(env, targethost.getTextTrim());
                    mpidir = this.getMPIbinDirWin(mpidir);
                    mpirun = !wmpi ? "" : (mpidir == null ? "\"\\\\mpiexec.exe\"" : "\"" + mpidir + "\\\\mpiexec.exe" + "\"");
                }
                script = script.replaceAll(key, mpirun);
                continue;
            }
            if (key.equals("__TARGETDIR__")) {
                String target = MyElement.decode(env.getChildTextTrim("targetdir"));
                if (target == null || target.trim().length() == 0) {
                    target = ".";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    target = Utils.escapeBackSlash(target);
                }
                script = script.replaceAll(key, target);
                continue;
            }
            if (key.equals("__NP__") || key.equals("__N__")) {
                String nn = "1";
                if (mpiParams != null) {
                    nn = MyElement.decode(mpiParams.getChildTextTrim("np"));
                    try {
                        Integer.parseInt(nn);
                    }
                    catch (Exception e) {
                        nn = "1";
                    }
                }
                if (!this.mpiSupport(env, targethost.getTextTrim())) {
                    nn = "";
                }
                script = script.replaceAll(key, nn);
                continue;
            }
            if (key.equals("__JAVADIR__")) {
                String javadir = MyElement.decode(env.getChildTextTrim("javadir"));
                if (javadir == null || javadir.trim().length() == 0) {
                    javadir = "";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    javadir = Utils.escapeBackSlash(javadir);
                }
                script = script.replaceAll(key, javadir);
                continue;
            }
            if (key.equals("__FS__")) {
                boolean isWindows = new Boolean(MyElement.decode(env.getChildTextTrim("windows")));
                String FS = "/";
                if (isWindows) {
                    FS = "\\\\";
                }
                script = script.replaceAll(key, FS);
                continue;
            }
            if (key.equals("__BINDIR__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                if (bindir == null || bindir.trim().length() == 0) {
                    bindir = "";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    bindir = Utils.escapeBackSlash(bindir);
                }
                script = script.replaceAll(key, bindir);
                continue;
            }
            if (key.equals("__CHASEJAR__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                String chase = bindir + "/phase-viewer.jar";
                if (bindir == null || bindir.trim().length() == 0) {
                    chase = "phase-viewer.jar";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    chase = Utils.escapeBackSlash(bindir) + "\\\\" + "phase-viewer.jar";
                    if (bindir == null || bindir.trim().length() == 0) {
                        chase = "phase-viewer.jar";
                    }
                }
                script = script.replaceAll(key, chase);
                continue;
            }
            if (key.equals("__CHASEDIR__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                String dir = "";
                if (bindir != null && bindir.trim().length() != 0) {
                    String[] array = bindir.trim().split("/");
                    String parent = "";
                    for (int j2 = 0; j2 < array.length - 1; ++j2) {
                        if (array[j2].trim().length() == 0) continue;
                        parent = parent + "/" + array[j2];
                    }
                    dir = parent;
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    dir = Utils.escapeBackSlash(new File(bindir).getParentFile().getAbsolutePath());
                }
                script = script.replaceAll(key, dir);
                continue;
            }
            if (key.equals("__JAVA__")) {
                String javadir = MyElement.decode(env.getChildTextTrim("javadir"));
                String java = javadir + "/bin/java";
                if (javadir == null || javadir.trim().length() == 0) {
                    java = "java";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    java = Utils.escapeBackSlash(javadir) + "\\\\" + "bin" + "\\\\" + "java.exe";
                    if (javadir == null || javadir.trim().length() == 0) {
                        java = "java.exe";
                    }
                }
                script = script.replaceAll(key, java);
                continue;
            }
            if (!key.equals("__NP0__")) continue;
            String np = "";
            if (this.mpiSupport(env, targethost.getTextTrim())) {
                np = "-np";
            }
            script = script.replaceAll(key, np);
        }
        if (!targethost.getTextTrim().equals("localhost") || !System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            script = script.replaceAll("\\r", "");
        }
        return script;
    }

    private String getMPIbinDirWin(String mpiDir) {
        String test2 = Utils.escapeBackSlash(mpiDir) + "\\\\" + "bin";
        if (new File(test2).exists()) {
            return test2;
        }
        test2 = Utils.escapeBackSlash(mpiDir) + "\\\\" + "mpirt";
        if (new File(test2).exists()) {
            return test2;
        }
        return null;
    }

    public String replace(String script, Document document) {
        return this.replace(script, document, false);
    }

    protected String[] getKeys() {
        return this.keys;
    }
}

