/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.mainpanel;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class ChaseProgressMonitor
extends JPanel {
    private static ChaseProgressMonitor monitor;
    private Logger logger = Logger.getLogger(ChaseProgressMonitor.class.getName());
    private JProgressBar progressBar;
    private JLabel label;
    private Timer timer = new Timer();
    private ProgressInfo info;
    private JPanel mon;
    private String ws = "                                                                              ";
    private boolean bool = true;
    private MonitorTask task;

    private ChaseProgressMonitor() {
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(600, 40));
        this.mon = this;
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.label = new JLabel(this.ws);
        this.add((Component)this.label, "West");
        this.add((Component)this.progressBar, "Center");
    }

    public static ChaseProgressMonitor getMonitor() {
        if (monitor == null) {
            monitor = new ChaseProgressMonitor();
        }
        return monitor;
    }

    void init() {
        this.progressBar.setVisible(false);
    }

    public void setProgress(ProgressInfo info_) {
        if (info_ == null) {
            return;
        }
        this.info = info_;
        String name = "";
        String s = info_.getNameOfProgress();
        if (s != null) {
            name = s;
        }
        this.label.setText(name);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.info.getLength());
        this.progressBar.setVisible(true);
        this.revalidate();
        this.timer = new Timer();
        this.task = new MonitorTask();
        this.timer.schedule((TimerTask)this.task, 0L, 100L);
    }

    public void stop() {
        this.task.cancel();
        this.progressBar.setValue(0);
        this.label.setText(this.ws);
        this.progressBar.setVisible(false);
        if (this.info != null) {
            this.info.done();
            this.info = null;
        }
    }

    class DummyInfo
    implements ProgressInfo {
        long boot = Calendar.getInstance().getTimeInMillis();

        DummyInfo() {
        }

        public boolean isDone() {
            long now = Calendar.getInstance().getTimeInMillis();
            return now - this.boot > 10L;
        }

        public String getNameOfProgress() {
            return ChaseProgressMonitor.this.ws;
        }

        public int getLength() {
            return 100;
        }

        public String getCurrentMessage() {
            return null;
        }

        public int getCurrent() {
            return 0;
        }

        public void done() {
        }
    }

    class MonitorTask
    extends TimerTask {
        MonitorTask() {
        }

        public void run() {
            if (ChaseProgressMonitor.this.info == null) {
                return;
            }
            ChaseProgressMonitor.this.progressBar.setValue(ChaseProgressMonitor.this.info.getCurrent());
            String message = ChaseProgressMonitor.this.info.getCurrentMessage();
            if (message != null && message.length() != 0) {
                ChaseProgressMonitor.this.label.setText(message);
            }
            if (ChaseProgressMonitor.this.info == null) {
                return;
            }
            if (ChaseProgressMonitor.this.info.isDone()) {
                ChaseProgressMonitor.this.stop();
            }
            ChaseProgressMonitor.this.revalidate();
        }
    }
}

