/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.FrameCombo;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.atomcoord.io.XYZFileFilter;
import ciss.phase_viewer.atomcoord.io.XYZHeavyOptions;
import ciss.phase_viewer.atomcoord.io.XYZOptions;
import ciss.phase_viewer.atomcoord.io.XYZOptionsPanel;
import ciss.phase_viewer.common.ConstParameters;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class XYZImporter
implements Importer {
    private DecimalFormat formater = ConstParameters.formater;
    private Logger logger = Logger.getLogger(XYZImporter.class.getName());
    private PropertyChangeListener listener;
    private HashMap options = new HashMap();
    private double doubleforce = 1.0;
    private String type = XYZOptionsPanel.GENERIC;
    private int targetFrame = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        String mol2 = new File(fileName).getParent() + System.getProperty("file.separator") + "grid.mol2";
        Cell cell_from_mol2 = null;
        if (new File(mol2).exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(mol2));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).equals("grid file")) continue;
                    String tripos_atom = reader.readLine();
                    if (tripos_atom != null && (tripos_atom = tripos_atom.trim()).equals("@<TRIPOS>ATOM")) {
                        double[][] cellvector = new double[8][3];
                        for (int i = 0; i < 8; ++i) {
                            String foo = reader.readLine().trim();
                            String[] array = foo.split("\\s+");
                            cellvector[i][0] = Double.parseDouble(array[2]);
                            cellvector[i][1] = Double.parseDouble(array[3]);
                            cellvector[i][2] = Double.parseDouble(array[4]);
                        }
                        double[][] cell_double = new double[3][3];
                        for (int i = 0; i < 3; ++i) {
                            cell_double[0][i] = cellvector[4][i] - cellvector[0][i];
                            cell_double[1][i] = cellvector[2][i] - cellvector[0][i];
                            cell_double[2][i] = cellvector[1][i] - cellvector[0][i];
                        }
                        cell_from_mol2 = new Cell(cell_double[0], cell_double[1], cell_double[2]);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                this.logger.error(exc);
                exc.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ioe) {}
            }
        }
        BufferedReader br = null;
        Vector<AtomCoords> vec = new Vector<AtomCoords>();
        try {
            FileReader reader = new FileReader(fileName);
            br = new BufferedReader(reader);
            String str = new String();
            this.logger.info("parsing xyz file... " + fileName);
            block33: while (true) {
                int NumAt;
                AtomList list;
                AtomCoords coords;
                block50: {
                    block49: {
                        String strnum;
                        if ((strnum = br.readLine()) == null) break block49;
                        coords = new AtomCoords();
                        list = coords.getAtomList();
                        coords.setUnit(2);
                        coords.isCart(true);
                        NumAt = Integer.parseInt(strnum.trim());
                        str = br.readLine();
                        if (str == null) break block49;
                        String[] comments = str.trim().split("\\s+");
                        if (cell_from_mol2 != null) {
                            coords.setCell(cell_from_mol2);
                            break block50;
                        } else if (str.startsWith("frame no.") && comments.length >= 13) {
                            String[] avec = new String[]{comments[4], comments[5], comments[6]};
                            String[] bvec = new String[]{comments[7], comments[8], comments[9]};
                            String[] cvec = new String[]{comments[10], comments[11], comments[12]};
                            Cell cell = new Cell(avec, bvec, cvec);
                            coords.setCell(cell);
                        }
                        break block50;
                    }
                    if (vec.size() == 0) {
                        return null;
                    }
                    if (this.options.get(XYZOptionsPanel.FRAME) != null) {
                        this.targetFrame = ((FrameCombo)this.options.get(XYZOptionsPanel.FRAME)).getTargetFrame(vec.size());
                    }
                    if (this.targetFrame < 0) {
                        Object[] ret = new AtomCoords[vec.size()];
                        vec.copyInto(ret);
                        return ret;
                    }
                    return new AtomCoords[]{(AtomCoords)vec.get(this.targetFrame)};
                }
                int i = 0;
                while (true) {
                    String element;
                    String[] co;
                    String[] c;
                    if (i < NumAt && (str = br.readLine()) != null) {
                        this.logger.debug("line " + i + ": " + str);
                        c = str.trim().split("\\s+");
                        co = new String[3];
                        element = new String();
                        if (c.length < 4) {
                            this.logger.warn("invalid data found at line " + i);
                            AtomCoords[] atomCoordsArray = null;
                            return atomCoordsArray;
                        }
                        element = c[0];
                    } else {
                        vec.addElement(coords);
                        continue block33;
                    }
                    for (int j = 1; j < 4; ++j) {
                        try {
                            Double.parseDouble(c[j]);
                        }
                        catch (NumberFormatException nfe) {
                            this.logger.warn("non-numerical data for coordinates found at line" + i);
                            AtomCoords[] atomCoordsArray = null;
                            try {
                                br.close();
                                return atomCoordsArray;
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            return atomCoordsArray;
                        }
                        co[j - 1] = c[j];
                    }
                    Atom atom = new Atom(element, co);
                    this.logger.debug("atom: " + atom);
                    if (c.length >= 7) {
                        String[] force = new String[]{c[4], c[5], c[6]};
                        atom.setForce(force);
                    }
                    list.addAtom(atom);
                    ++i;
                }
                break;
            }
        }
        catch (Exception exc) {
            this.logger.warn("invalid xyz file");
            AtomCoords[] atomCoordsArray = null;
            return atomCoordsArray;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ioe) {}
        }
    }

    public String getType() {
        return "XYZ";
    }

    public FileFilter getFileFilter() {
        return new XYZFileFilter();
    }

    public boolean hasOptions() {
        return true;
    }

    public void createOptionsPanel(boolean isheavy, PropertyChangeListener listener, String fileName) {
        this.listener = listener;
        if (!isheavy) {
            XYZOptions opts = new XYZOptions(this, listener);
        } else {
            XYZHeavyOptions hopts = new XYZHeavyOptions(this, listener);
        }
    }

    public void setOptions(HashMap options) {
        if (options == null) {
            return;
        }
        this.options = options;
        double doubleforce = 1.0;
        try {
            String forceFactor = options.get(XYZOptionsPanel.FORCE).toString();
            doubleforce = Double.parseDouble(forceFactor);
        }
        catch (Exception exc) {
            // empty catch block
        }
        String type = XYZOptionsPanel.GENERIC;
        try {
            type = options.get(XYZOptionsPanel.TYPE).toString();
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.logger.debug("type: " + type);
    }

    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }
}

