/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.UndoRedoObject;
import java.util.Stack;
import org.apache.log4j.Logger;

public class UndoRedo {
    private Logger logger = Logger.getLogger(UndoRedo.class.getName());
    private AtomList list;
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private Stack undoCount = new Stack();
    private Stack redoCount = new Stack();

    public UndoRedo(AtomList list) {
        this.list = list;
    }

    protected void init() {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.undoCount = new Stack();
        this.redoCount = new Stack();
    }

    protected void addEntry(Atom atom, int index, int mode) {
        Atom copy = null;
        if (atom != null) {
            copy = atom.getCopy();
        }
        UndoRedoObject uro = new UndoRedoObject(copy, index, mode);
        this.undoStack.push(uro);
        this.redoStack.clear();
        this.redoCount.clear();
        this.logger.debug("pushed: " + uro);
    }

    protected void addEntry(Cell cell) {
        Cell copy = null;
        if (cell != null) {
            copy = cell.getCopy();
        }
        UndoRedoObject uro = new UndoRedoObject(copy);
        this.undoStack.push(uro);
        this.redoStack.clear();
        this.redoCount.clear();
    }

    protected void setUndoCount(int count) {
        this.undoCount.push(new Integer(count));
    }

    protected boolean undoToFirstEntry() {
        if (this.undoStack.empty()) {
            this.logger.info("undo stack empty.");
            return false;
        }
        while (!this.undoStack.empty()) {
            this.undo();
        }
        return true;
    }

    protected boolean undo() {
        if (this.undoStack.empty()) {
            this.logger.info("undo stack empty.");
            return false;
        }
        int count = 1;
        if (!this.undoCount.empty()) {
            count = (Integer)this.undoCount.pop();
        }
        for (int i = 0; i < count; ++i) {
            UndoRedoObject uro = (UndoRedoObject)this.undoStack.pop();
            this.redoStack.push(this.doIt(this.undoStack, uro));
        }
        this.redoCount.push(new Integer(count));
        return true;
    }

    protected boolean redo() {
        if (this.redoStack.empty()) {
            this.logger.info("redo stack empty.");
            return false;
        }
        int count = 1;
        if (!this.redoCount.empty()) {
            count = (Integer)this.redoCount.pop();
        }
        for (int i = 0; i < count; ++i) {
            UndoRedoObject uro = (UndoRedoObject)this.redoStack.pop();
            this.undoStack.push(this.doIt(this.redoStack, uro));
        }
        this.undoCount.push(new Integer(count));
        return true;
    }

    private UndoRedoObject doIt(Stack stack, UndoRedoObject uro) {
        if (uro.isCell()) {
            Cell cell = uro.getCell();
            Cell tmpcell = this.list.getParent().getCell(cell.getCellScheme());
            this.list.getParent().setCell(cell, false);
            return new UndoRedoObject(tmpcell);
        }
        Atom atom = uro.getAtom();
        int index = uro.getIndex();
        int mode = uro.getMode();
        this.logger.debug("old UndoRedo: " + uro);
        if (atom == null || mode == UndoRedoObject.ADD) {
            this.list.removeAtomAt(index, false);
            UndoRedoObject newuro = new UndoRedoObject(atom, index, UndoRedoObject.REMOVE);
            this.logger.debug("new UndoRedoObject: " + newuro);
            return newuro;
        }
        int retmode = UndoRedoObject.ADD;
        Atom retAtom = null;
        if (mode == UndoRedoObject.REPLACE) {
            if (index < this.list.size()) {
                retAtom = ((Atom)this.list.get(index)).getCopy();
                this.list.replaceAtomAt(index, atom, false);
                this.logger.debug("at doIt.REPLACE");
                retmode = UndoRedoObject.REPLACE;
            } else {
                retAtom = atom;
                this.list.addAtom(atom, false);
                this.logger.debug("at doIt.REPLACE");
            }
        } else if (mode == UndoRedoObject.REMOVE) {
            if (index < this.list.size()) {
                retAtom = atom;
                this.list.addAtomAt(index, atom, false);
                this.logger.debug("at doIt.REMOVE; index: " + index);
            } else {
                retAtom = atom;
                this.list.addAtom(atom, false);
                this.logger.debug("at doIt.REMOVE");
            }
        }
        UndoRedoObject newuro = new UndoRedoObject(retAtom, index, retmode);
        this.logger.debug("new UndoRedoObject: " + newuro);
        return newuro;
    }

    public void nullify() {
        UndoRedoObject uro;
        while (!this.undoStack.empty()) {
            uro = (UndoRedoObject)this.undoStack.pop();
            uro.nullify();
        }
        this.undoStack = null;
        while (!this.redoStack.empty()) {
            uro = (UndoRedoObject)this.redoStack.pop();
            uro.nullify();
        }
        this.redoStack = null;
        this.list = null;
    }
}

