/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.scenegraphelements.CapableText2D;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementBG;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.Utils;
import java.awt.Font;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.DefaultListModel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class MeasureObject
extends SceneGraphElementBG {
    private static Logger logger = Logger.getLogger(MeasureObject.class.getName());
    public final int DISTANCE = 0;
    public final int ANGLE = 1;
    public final int DIHEDRAL = 2;
    private int measureType = 0;
    private double[][] xyz;
    private double result = 0.0;
    private BranchGroup branchGroup;
    private Vector atomVector;
    private DefaultListModel model;
    private String[] id;

    public MeasureObject(double[] atom1, double[] atom2) {
        this.measureType = 0;
        this.xyz = new double[2][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.init();
    }

    public MeasureObject(double[] atom1, double[] atom2, double result) {
        this.measureType = 0;
        this.xyz = new double[2][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.result = result;
        this.init();
    }

    public MeasureObject(double[] atom1, double[] atom2, double[] atom3, double result) {
        this.measureType = 1;
        this.xyz = new double[3][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.xyz[2] = atom3;
        this.result = result;
        this.init();
    }

    public MeasureObject(double[] atom1, double[] atom2, double[] atom3, double[] atom4, double result) {
        this.measureType = 2;
        this.xyz = new double[4][3];
        this.xyz[0] = atom1;
        this.xyz[1] = atom2;
        this.xyz[2] = atom3;
        this.xyz[3] = atom4;
        this.result = result;
        this.init();
    }

    public void setAtomVector(Vector atomVector) {
        this.atomVector = atomVector;
    }

    public Vector getAtomVector() {
        return this.atomVector;
    }

    private void init() {
        this.setCapability(17);
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(17);
    }

    public void setAssociatedListModel(DefaultListModel model) {
        this.model = model;
    }

    public void detach() {
        super.detach();
        if (this.model != null) {
            this.model.removeElement(this);
        }
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
    }

    public void setResult(double result) {
        this.result = result;
    }

    public void setAtoms(double[][] atoms) {
        this.xyz = atoms;
    }

    public void setIDString(String[] idstr) {
        this.id = idstr;
    }

    protected void create() {
        if (this.measureType == 0) {
            this.createDistanceObject();
        } else if (this.measureType == 1) {
            this.createAngleObject();
        } else if (this.measureType == 2) {
            this.createDihedObject();
        }
        this.addChild((Node)this.branchGroup);
    }

    public void recreate() {
        this.branchGroup.detach();
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(17);
        this.create();
    }

    public String toString() {
        if (this.measureType == 0) {
            return "distance between atoms " + this.id[1] + " and " + this.id[0] + ": " + ConstParameters.formater_smaller_digits.format(this.result) + " \u212b";
        }
        if (this.measureType == 1) {
            return "bond angle among atoms " + this.id[2] + ", " + this.id[1] + " and " + this.id[0] + ": " + ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0";
        }
        if (this.measureType == 2) {
            return "dihedral angle among atoms " + this.id[3] + ", " + this.id[2] + ", " + this.id[1] + " and " + this.id[0] + ": " + ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0";
        }
        return "";
    }

    private void createDistanceObject() {
        double[] midpoint = new double[]{(this.xyz[0][0] + this.xyz[1][0]) * 0.5 - 0.1, (this.xyz[0][1] + this.xyz[1][1]) * 0.5, (this.xyz[0][2] + this.xyz[1][2]) * 0.5};
        this.branchGroup.addChild((Node)new Line(this.xyz[0], this.xyz[1]));
        this.branchGroup.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u212b", midpoint, this.mACVD.getFont()));
    }

    private void createAngleObject() {
        double[] midpoint = new double[]{(this.xyz[0][0] + this.xyz[2][0]) * 0.5 - 0.1, (this.xyz[0][1] + this.xyz[2][1]) * 0.5, (this.xyz[0][2] + this.xyz[2][2]) * 0.5};
        this.branchGroup.addChild((Node)new Arc(this.xyz[0], this.xyz[2], this.xyz[1]));
        this.branchGroup.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0", midpoint, this.mACVD.getFont()));
    }

    private void createDihedObject() {
        double[] a = new double[]{(this.xyz[0][0] + this.xyz[1][0] + this.xyz[2][0]) / 3.0, (this.xyz[0][1] + this.xyz[1][1] + this.xyz[2][1]) / 3.0, (this.xyz[0][2] + this.xyz[1][2] + this.xyz[2][2]) / 3.0};
        double[] b = new double[]{(this.xyz[1][0] + this.xyz[2][0] + this.xyz[3][0]) / 3.0, (this.xyz[1][1] + this.xyz[2][1] + this.xyz[3][1]) / 3.0, (this.xyz[1][2] + this.xyz[2][2] + this.xyz[3][2]) / 3.0};
        double[] c = new double[]{(this.xyz[1][0] + this.xyz[2][0]) * 0.5, (this.xyz[1][1] + this.xyz[2][1]) * 0.5, (this.xyz[1][2] + this.xyz[2][2]) * 0.5};
        double[] pos = new double[]{(a[0] + b[0]) * 0.5 - 0.1, (a[1] + b[1]) * 0.5, (a[2] + b[2]) * 0.5};
        this.branchGroup.addChild((Node)new Arc(a, b, c));
        this.branchGroup.addChild((Node)new Word(ConstParameters.formater_smaller_digits.format(this.result) + " \u00b0", pos, this.mACVD.getFont()));
    }

    public int getMeasureType() {
        return this.measureType;
    }

    public int getType() {
        return 7;
    }

    class Arc
    extends Shape3D {
        protected Arc(double[] a, double[] b, double[] center) {
            this.createArc(a, b, center);
        }

        private void createArc(double[] a, double[] b, double[] center) {
            float resolution = 100.0f;
            float invresolution = 1.0f / resolution;
            int length = (int)resolution;
            double[] bma = new double[]{b[0] - a[0], b[1] - a[1], b[2] - a[2]};
            double[] amc = new double[]{a[0] - center[0], a[1] - center[1], a[2] - center[2]};
            double radius = Utils.getNorm(amc);
            double[] oap = new double[3];
            double[][] point = new double[length][3];
            for (int i = 0; i < length; ++i) {
                int j;
                for (j = 0; j < 3; ++j) {
                    double tmp = bma[j] * (double)invresolution * (double)i + a[j];
                    oap[j] = tmp - center[j];
                }
                Utils.normalize(oap);
                for (j = 0; j < 3; ++j) {
                    point[i][j] = oap[j] * radius + center[j];
                }
            }
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(0.9f, 0.9f, 0.5f, 1));
            LineAttributes lineAttrib = new LineAttributes();
            lineAttrib.setLineWidth(5.0f);
            lineAttrib.setLinePattern(1);
            appearance.setLineAttributes(lineAttrib);
            LineStripArray lsa = new LineStripArray(length, 1, new int[]{length});
            Point3f pt = new Point3f();
            for (int i = 0; i < length; ++i) {
                pt.x = (float)point[i][0];
                pt.y = (float)point[i][1];
                pt.z = (float)point[i][2];
                lsa.setCoordinate(i, pt);
            }
            try {
                lsa.setCapability(18);
            }
            catch (RestrictedAccessException rae) {
                // empty catch block
            }
            this.setAppearance(appearance);
            this.setGeometry((Geometry)lsa);
        }
    }

    class Line
    extends Shape3D {
        protected Line(double[] a, double[] b) {
            this.createLine(a, b);
        }

        private void createLine(double[] a, double[] b) {
            float resolution = 100.0f;
            float invresolution = 1.0f / resolution;
            int length = (int)resolution;
            double[] ems = new double[]{b[0] - a[0], b[1] - a[1], b[2] - a[2]};
            double[] midpoint = new double[]{(b[0] + a[0]) * 0.5 - (double)0.1f, (b[1] + a[1]) * 0.5, (b[2] + a[2]) * 0.5 + (double)0.05f};
            Appearance appearance = new Appearance();
            appearance.setColoringAttributes(new ColoringAttributes(0.9f, 0.9f, 0.5f, 1));
            LineAttributes lineAttrib = new LineAttributes();
            lineAttrib.setLineWidth(5.0f);
            lineAttrib.setLinePattern(1);
            appearance.setLineAttributes(lineAttrib);
            LineStripArray lsa = new LineStripArray(length, 1, new int[]{length});
            int i = 0;
            while ((float)i < resolution) {
                float[] fp = new float[3];
                for (int j = 0; j < 3; ++j) {
                    fp[j] = (float)ems[j] * invresolution * (float)i + (float)a[j] + 0.01f;
                }
                lsa.setCoordinate(i, new Point3f(fp));
                ++i;
            }
            try {
                lsa.setCapability(18);
            }
            catch (RestrictedAccessException rae) {
                // empty catch block
            }
            this.setAppearance(appearance);
            this.setGeometry((Geometry)lsa);
        }
    }

    class Word
    extends TransformGroup {
        protected Word(String text, double[] pos, Font font) {
            this.createWord(text, pos, font);
        }

        private void createWord(String text, double[] pos, Font font) {
            Color3f col = MeasureObject.this.mACVD.getFontColor();
            CapableText2D text2d = new CapableText2D(text, col, font.getName(), font.getSize(), font.getStyle());
            Transform3D t3d = new Transform3D();
            t3d.set(new Vector3d(pos));
            this.setTransform(t3d);
            OrientedShape3D orientedShape = new OrientedShape3D(text2d.getGeometry(), text2d.getAppearance(), 1, new Point3f(0.1f, 0.0f, 0.0f));
            this.addChild((Node)orientedShape);
        }
    }
}

