/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CylinderCreator;
import ciss.phase_viewer.acviewer.scenegraphelements.CapableText2D;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElement;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Font;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

class AxisObject
extends SceneGraphElement
implements PropertiesListener {
    private static Logger logger = Logger.getLogger(AxisObject.class.getName());
    private GlobalProperties props = PropertiesManager.getGlobalProperties(1);
    private double length = 0.1f;
    private int fontSize = 18;
    private Color3f fontColor = new Color3f(new float[]{0.0f, 0.0f, 0.0f});
    private Vector3f pos = new Vector3f(-0.8f, -0.7f, 0.0f);
    private BranchGroup rootBranch;

    public AxisObject() {
        GlobalProperties.addPropertiesListener(this);
        this.readProps();
    }

    private void readProps() {
        try {
            this.length = Double.parseDouble(this.props.getProperty("axis_length"));
            this.fontSize = Integer.parseInt(this.props.getProperty("axis_label_font_size"));
            String[] sfontColor = this.props.getProperty("axis_label_font_color").split(",");
            this.fontColor = new Color3f(new float[]{Float.parseFloat(sfontColor[0]), Float.parseFloat(sfontColor[1]), Float.parseFloat(sfontColor[2])});
            String[] spos = this.props.getProperty("axis_pos").split(",");
            this.pos = new Vector3f(Float.parseFloat(spos[0]), Float.parseFloat(spos[1]), Float.parseFloat(spos[2]));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public int getType() {
        return 3;
    }

    public void create() {
        this.rootBranch = new BranchGroup();
        this.rootBranch.setCapability(17);
        CylinderCreator cylindercreate = new CylinderCreator();
        BranchGroup XAxis = new BranchGroup();
        BranchGroup YAxis = new BranchGroup();
        BranchGroup ZAxis = new BranchGroup();
        cylindercreate.setResolution(30);
        Transform3D rotatex = new Transform3D();
        Transform3D rotatey = new Transform3D();
        Transform3D rotatez = new Transform3D();
        rotatex.rotZ(-1.5707963267948966);
        rotatey.rotY(0.0);
        rotatez.rotX(1.5707963267948966);
        XAxis = cylindercreate.create(new Point3d(0.0, 0.0, 0.0), new Point3d(this.length, 0.0, 0.0), 0.005, 0.02f, 0.04f);
        YAxis = cylindercreate.create(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, this.length, 0.0), 0.005, 0.02f, 0.04f);
        ZAxis = cylindercreate.create(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, this.length), 0.005, 0.02f, 0.04f);
        Transform3D translatex = new Transform3D();
        Transform3D translatey = new Transform3D();
        Transform3D translatez = new Transform3D();
        Transform3D translateorigin = new Transform3D();
        translatex.set(new Vector3f((float)this.length, 0.0f, 0.0f));
        translatey.set(new Vector3f(0.0f, (float)this.length, 0.0f));
        translatez.set(new Vector3f(0.0f, 0.0f, (float)this.length));
        translateorigin.set(this.pos);
        translatex.setScale(1.0);
        translatey.setScale(1.0);
        translatez.setScale(1.0);
        TransformGroup tfgx = new TransformGroup(translatex);
        TransformGroup tfgy = new TransformGroup(translatey);
        TransformGroup tfgz = new TransformGroup(translatez);
        TransformGroup tfgxc = new TransformGroup();
        TransformGroup tfgyc = new TransformGroup();
        TransformGroup tfgzc = new TransformGroup();
        tfgxc.setTransform(rotatex);
        tfgyc.setTransform(rotatey);
        tfgzc.setTransform(rotatez);
        TransformGroup tfgxc2 = new TransformGroup(translatex);
        TransformGroup tfgyc2 = new TransformGroup(translatey);
        TransformGroup tfgzc2 = new TransformGroup(translatez);
        tfgxc2.addChild((Node)tfgxc);
        tfgyc2.addChild((Node)tfgyc);
        tfgzc2.addChild((Node)tfgzc);
        Font3D font = new Font3D(new Font("TimesRoman", 2, 1), new FontExtrusion());
        Color3f color_wkl2 = this.fontColor;
        CapableText2D xtext = new CapableText2D(" x", color_wkl2, "TimesRoman", this.fontSize, 2);
        CapableText2D ytext = new CapableText2D(" y", color_wkl2, "TimesRoman", this.fontSize, 2);
        CapableText2D ztext = new CapableText2D(" z", color_wkl2, "TimesRoman", this.fontSize, 2);
        Point3f lp3f = new Point3f(0.0f, 0.0f, 0.0f);
        OrientedShape3D xtextShape = new OrientedShape3D(xtext.getGeometry(), xtext.getAppearance(), 1, lp3f);
        OrientedShape3D ytextShape = new OrientedShape3D(ytext.getGeometry(), ytext.getAppearance(), 1, lp3f);
        OrientedShape3D ztextShape = new OrientedShape3D(ztext.getGeometry(), ztext.getAppearance(), 1, lp3f);
        tfgx.addChild((Node)xtextShape);
        tfgy.addChild((Node)ytextShape);
        tfgz.addChild((Node)ztextShape);
        this.rootBranch.addChild((Node)XAxis);
        this.rootBranch.addChild((Node)YAxis);
        this.rootBranch.addChild((Node)ZAxis);
        this.rootBranch.addChild((Node)tfgx);
        this.rootBranch.addChild((Node)tfgy);
        this.rootBranch.addChild((Node)tfgz);
        this.addChild((Node)this.rootBranch);
    }

    public void configDataUpdate() {
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
    }

    public void propertiesStored(GlobalProperties properties) {
        this.readProps();
        this.rootBranch.detach();
        this.create();
    }
}

