/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.CombinationDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.SeriesDataset;
import org.jfree.data.SignalsDataset;
import org.jfree.data.XYDataset;

public class SubSeriesDataset
extends AbstractSeriesDataset
implements HighLowDataset,
SignalsDataset,
IntervalXYDataset,
CombinationDataset {
    private SeriesDataset parent = null;
    private int[] map;

    public SubSeriesDataset(SeriesDataset parent, int[] map) {
        this.parent = parent;
        this.map = map;
    }

    public SubSeriesDataset(SeriesDataset parent, int series) {
        this(parent, new int[]{series});
    }

    public Number getHighValue(int series, int item) {
        return ((HighLowDataset)this.parent).getHighValue(this.map[series], item);
    }

    public Number getLowValue(int series, int item) {
        return ((HighLowDataset)this.parent).getLowValue(this.map[series], item);
    }

    public Number getOpenValue(int series, int item) {
        return ((HighLowDataset)this.parent).getOpenValue(this.map[series], item);
    }

    public Number getCloseValue(int series, int item) {
        return ((HighLowDataset)this.parent).getCloseValue(this.map[series], item);
    }

    public Number getVolumeValue(int series, int item) {
        return ((HighLowDataset)this.parent).getVolumeValue(this.map[series], item);
    }

    public Number getXValue(int series, int item) {
        return ((XYDataset)this.parent).getXValue(this.map[series], item);
    }

    public Number getYValue(int series, int item) {
        return ((XYDataset)this.parent).getYValue(this.map[series], item);
    }

    public int getItemCount(int series) {
        return ((XYDataset)this.parent).getItemCount(this.map[series]);
    }

    public int getSeriesCount() {
        return this.map.length;
    }

    public String getSeriesName(int series) {
        return this.parent.getSeriesName(this.map[series]);
    }

    public Number getStartXValue(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartXValue(this.map[series], item);
        }
        return this.getXValue(series, item);
    }

    public Number getEndXValue(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndXValue(this.map[series], item);
        }
        return this.getXValue(series, item);
    }

    public Number getStartYValue(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartYValue(this.map[series], item);
        }
        return this.getYValue(series, item);
    }

    public Number getEndYValue(int series, int item) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndYValue(this.map[series], item);
        }
        return this.getYValue(series, item);
    }

    public int getType(int series, int item) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getType(this.map[series], item);
        }
        return this.getYValue(series, item).intValue();
    }

    public double getLevel(int series, int item) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getLevel(this.map[series], item);
        }
        return this.getYValue(series, item).doubleValue();
    }

    public SeriesDataset getParent() {
        return this.parent;
    }

    public int[] getMap() {
        return (int[])this.map.clone();
    }
}

