/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.net.DeployClassLoader;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.security.CPCallbackClassLoaderIf;
import com.sun.deploy.security.CPCallbackHandler;
import com.sun.deploy.security.DeployURLClassPath;
import com.sun.deploy.security.SecureCookiePermission;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.progress.Progress;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.util.JNLPUtils;
import com.sun.javaws.util.JfxHelper;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadService2Impl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.IntegrationServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.JNLPPreverifyClassLoader;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.DownloadService2;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.IntegrationService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.misc.URLClassPath;

public final class JNLPClassLoader
extends URLClassLoader
implements JNLPClassLoaderIf,
CPCallbackClassLoaderIf {
    private static JNLPClassLoader _instance = null;
    private static JNLPPreverifyClassLoader _preverifyCL = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();
    private static Field ucpField = JNLPClassLoader.getUCPField("ucp");
    private List addedURLs = new ArrayList();
    private JNLPClassLoader _jclParent;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    private JNLPClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        if (classLoader instanceof JNLPClassLoader) {
            this._jclParent = (JNLPClassLoader)classLoader;
        }
        JNLPClassLoader.setUCP(this, (URLClassPath)new DeployURLClassPath(new URL[0]));
    }

    private void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        Object object;
        ResourcesDesc resourcesDesc;
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
        if (this._jclParent != null) {
            this._jclParent.initialize(launchDesc, appPolicy);
            this.drainPendingURLs();
            return;
        }
        if (_preverifyCL != null) {
            _preverifyCL.initialize(launchDesc, appPolicy);
        }
        if (launchDesc.needFX()) {
            resourcesDesc = null;
            for (ClassLoader classLoader = this.getParent(); resourcesDesc == null && classLoader != null; classLoader = classLoader.getParent()) {
                if (!(classLoader instanceof DeployClassLoader)) continue;
                resourcesDesc = (DeployClassLoader)classLoader;
            }
            if (resourcesDesc != null) {
                object = JfxHelper.getBestJfxInstalled(launchDesc);
                try {
                    resourcesDesc.injectJfx((JfxRuntime)object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.ignored((Throwable)classNotFoundException);
                }
                catch (IllegalStateException illegalStateException) {
                    Trace.ignored((Throwable)illegalStateException);
                }
            }
        }
        if ((resourcesDesc = launchDesc.getResources()) != null) {
            JNLPUtils.sortResourcesForClasspath(resourcesDesc, this._jarsInURLClassLoader, this._jarsNotInURLClassLoader);
            for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
                object = (JARDesc)this._jarsInURLClassLoader.get(i);
                if (_preverifyCL != null && _preverifyCL.contains(((JARDesc)object).getLocation())) continue;
                this.addURL2(((JARDesc)object).getLocation());
            }
        }
    }

    public JNLPPreverifyClassLoader getJNLPPreverifyClassLoader() {
        return _preverifyCL;
    }

    public Preloader getPreloader() {
        return Progress.get(null);
    }

    public static JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            JNLPClassLoader jNLPClassLoader;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            _preverifyCL = new JNLPPreverifyClassLoader(classLoader);
            JNLPClassLoader jNLPClassLoader2 = new JNLPClassLoader(_preverifyCL);
            _instance = Config.getMixcodeValue() != 3 ? (!JNLPClassLoader.setDeployURLClassPathCallbacks(jNLPClassLoader2, jNLPClassLoader = new JNLPClassLoader(jNLPClassLoader2)) ? jNLPClassLoader2 : jNLPClassLoader) : jNLPClassLoader2;
        }
        return _instance;
    }

    public static JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, appPolicy);
        }
        return jNLPClassLoader;
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        JARDesc jARDesc;
        int n;
        if (this._jclParent != null) {
            return this._jclParent.getJarDescFromURL(uRL);
        }
        for (n = 0; n < this._jarsInURLClassLoader.size(); ++n) {
            jARDesc = (JARDesc)this._jarsInURLClassLoader.get(n);
            if (!URLUtil.sameURLs((URL)jARDesc.getLocation(), (URL)uRL)) continue;
            return jARDesc;
        }
        for (n = 0; n < this._jarsInURLClassLoader.size(); ++n) {
            jARDesc = (JARDesc)this._jarsInURLClassLoader.get(n);
            URL uRL2 = DownloadEngine.getKnownRedirectFinalURL((URL)jARDesc.getLocation());
            if (!HttpUtils.sameURLsIgnoreVersionQueries((URL)uRL2, (URL)uRL)) continue;
            return jARDesc;
        }
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                URL uRL = null;
                for (int i = 0; uRL == null && i < 3; ++i) {
                    uRL = JNLPClassLoader.super.getResource(string);
                }
                return uRL;
            }
        });
        return uRL;
    }

    protected String findLibrary(String string) {
        if (this._jclParent != null) {
            return this._jclParent.findLibrary(string);
        }
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        string = Platform.get().getLibraryPrefix() + string + Platform.get().getLibrarySufix();
        Trace.println((String)("Looking up native library: " + string), (TraceLevel)TraceLevel.NETWORK);
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!jARDescArray[i].isNativeLib()) continue;
            try {
                String string2 = DownloadEngine.getLibraryDirForJar((String)string, (URL)jARDescArray[i].getLocation(), (String)jARDescArray[i].getVersion());
                if (string2 == null) continue;
                return new File(string2, string).getAbsolutePath();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        Trace.println((String)("Native library " + string + " not found"), (TraceLevel)TraceLevel.NETWORK);
        return super.findLibrary(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.checkPackageParts(string)) {
                return super.findClass(string);
            }
            throw classNotFoundException;
        }
    }

    public void quiescenceRequested(Thread thread, boolean bl) {
    }

    public void quiescenceCancelled(boolean bl) {
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    private boolean checkPackageParts(String string) {
        if (this._jclParent != null) {
            return this.drainPendingURLs();
        }
        boolean bl = false;
        ResourcesDesc.PackageInformation packageInformation = this._launchDesc.getResources().getPackageInformation(string);
        if (packageInformation != null) {
            JARDesc[] jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            for (int i = 0; i < jARDescArray.length; ++i) {
                if (!this._jarsNotInURLClassLoader.contains(jARDescArray[i])) continue;
                this._jarsNotInURLClassLoader.remove(jARDescArray[i]);
                this.addLoadedJarsEntry(jARDescArray[i]);
                this.addURL2(jARDescArray[i].getLocation());
                bl = true;
            }
        }
        return bl;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        try {
            this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), permissionCollection, codeSource, true);
        }
        catch (ExitException exitException) {
            Trace.println((String)("_appPolicy.addPermissions: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
        URL uRL = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null) {
            try {
                File file = DownloadEngine.getCachedFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                if (file != null) {
                    String string = file.getPath();
                    permissionCollection.add(new FilePermission(string, "read"));
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (!permissionCollection.implies(new AWTPermission("accessClipboard"))) {
            ToolkitStore.get().getAppContext().put((Object)"UNTRUSTED_URLClassLoader", (Object)Boolean.TRUE);
        }
        permissionCollection.add((Permission)new SecureCookiePermission(SecureCookiePermission.getURLOriginString((URL)codeSource.getLocation())));
        return permissionCollection;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        JarFile jarFile = null;
        if (jARDesc != null) {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() throws SecurityException {
                    try {
                        JarFile jarFile = DownloadEngine.getCachedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                        if (jarFile != null) {
                            return jarFile;
                        }
                        return DownloadEngine.getUpdatedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                        return null;
                    }
                }
            });
            if (jarFile == null) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            return jarFile;
        }
        return null;
    }

    private void addLoadedJarsEntry(JARDesc jARDesc) {
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
    }

    public void addResource(URL uRL, String string, String string2) {
        if (this._jclParent != null) {
            this._jclParent.addResource(uRL, string, string2);
            this.drainPendingURLs();
            return;
        }
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._launchDesc.getResources().addResource(jARDesc);
            this.addLoadedJarsEntry(jARDesc);
            this.addURL2(uRL);
        }
    }

    static boolean setDeployURLClassPathCallbacks(JNLPClassLoader jNLPClassLoader, JNLPClassLoader jNLPClassLoader2) {
        try {
            if (!CacheEntry.hasEnhancedJarAccess()) {
                Trace.println((String)"setDeployURLClassPathCallbacks: no enhanced access", (TraceLevel)TraceLevel.BASIC);
                return false;
            }
            CPCallbackHandler cPCallbackHandler = new CPCallbackHandler((CPCallbackClassLoaderIf)jNLPClassLoader, (CPCallbackClassLoaderIf)jNLPClassLoader2);
            JNLPClassLoader.getDUCP(jNLPClassLoader).setDeployURLClassPathCallback(cPCallbackHandler.getParentCallback());
            JNLPClassLoader.getDUCP(jNLPClassLoader2).setDeployURLClassPathCallback(cPCallbackHandler.getChildCallback());
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
        return true;
    }

    private static DeployURLClassPath getDUCP(JNLPClassLoader jNLPClassLoader) {
        return (DeployURLClassPath)JNLPClassLoader.getUCP(jNLPClassLoader);
    }

    private static URLClassPath getUCP(JNLPClassLoader jNLPClassLoader) {
        URLClassPath uRLClassPath = null;
        try {
            uRLClassPath = (URLClassPath)ucpField.get(jNLPClassLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRLClassPath;
    }

    private static void setUCP(JNLPClassLoader jNLPClassLoader, URLClassPath uRLClassPath) {
        try {
            ucpField.set(jNLPClassLoader, uRLClassPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Field getUCPField(final String string) {
        return (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Field field = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = JNLPClassLoader.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    protected void addURL(URL uRL) {
        if (this._jclParent != null) {
            this._jclParent.addURL(uRL);
        }
        super.addURL(uRL);
    }

    void addURL2(URL uRL) {
        if (this._jclParent != null) {
            this.drainPendingURLs();
        } else {
            this.putAddedURL(uRL);
        }
        super.addURL(uRL);
    }

    boolean drainPendingURLs() {
        int n;
        List list = this._jclParent.grabAddedURLs();
        for (n = 0; n < list.size(); ++n) {
            super.addURL((URL)list.get(n));
        }
        return n != 0;
    }

    synchronized List grabAddedURLs() {
        List list = this.addedURLs;
        this.addedURLs = new ArrayList();
        return list;
    }

    synchronized void putAddedURL(URL uRL) {
        this.addedURLs.add(uRL);
    }

    public CodeSource[] getTrustedCodeSources(CodeSource[] codeSourceArray) {
        ArrayList<CodeSource> arrayList = new ArrayList<CodeSource>();
        Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
        for (int i = 0; i < codeSourceArray.length; ++i) {
            CodeSource codeSource = codeSourceArray[i];
            boolean bl = false;
            PermissionCollection permissionCollection = policy.getPermissions(codeSource);
            try {
                bl = this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), permissionCollection, codeSource, true);
            }
            catch (ExitException exitException) {
                Trace.println((String)("_appPolicy.addPermissions: " + exitException), (TraceLevel)TraceLevel.BASIC);
                Trace.ignoredException((Exception)exitException);
            }
            if (!bl) {
                bl = permissionCollection.implies(new AllPermission());
            }
            if (!bl) {
                bl = this.isTrustedByPolicy(policy, codeSource);
            }
            if (!bl) continue;
            arrayList.add(codeSource);
        }
        return arrayList.toArray(new CodeSource[arrayList.size()]);
    }

    private boolean isTrustedByPolicy(Policy policy, CodeSource codeSource) {
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        PermissionCollection permissionCollection2 = policy.getPermissions(new CodeSource(null, (Certificate[])null));
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            if (permissionCollection2.implies(permission)) continue;
            return true;
        }
        return false;
    }

    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }

    public IntegrationService getIntegrationService() {
        return new IntegrationServiceImpl(this);
    }

    public DownloadService2 getDownloadService2() {
        return DownloadService2Impl.getInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

