/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    static final AlgorithmId rsaId = new AlgorithmId(AlgorithmId.RSAEncryption_oid);

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(byArray);
        if (rSAPrivateCrtKeyImpl.getPublicExponent().signum() == 0) {
            return new RSAPrivateKeyImpl(rSAPrivateCrtKeyImpl.getModulus(), rSAPrivateCrtKeyImpl.getPrivateExponent());
        }
        return rSAPrivateCrtKeyImpl;
    }

    RSAPrivateCrtKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
    }

    RSAPrivateCrtKeyImpl(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.n = bigInteger;
        this.e = bigInteger2;
        this.d = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.pe = bigInteger6;
        this.qe = bigInteger7;
        this.coeff = bigInteger8;
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        this.algid = rsaId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            derOutputStream.putInteger(bigInteger4);
            derOutputStream.putInteger(bigInteger5);
            derOutputStream.putInteger(bigInteger6);
            derOutputStream.putInteger(bigInteger7);
            derOutputStream.putInteger(bigInteger8);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.data;
            int n = derInputStream2.getInteger();
            if (n != 0) {
                throw new IOException("Version must be 0");
            }
            this.n = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.e = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.d = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.p = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.q = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.pe = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.qe = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.coeff = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid RSA private key", iOException);
        }
    }

    static BigInteger getBigInteger(DerInputStream derInputStream) throws IOException {
        BigInteger bigInteger = derInputStream.getBigInteger();
        if (bigInteger.signum() < 0) {
            bigInteger = new BigInteger(1, bigInteger.toByteArray());
        }
        return bigInteger;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Sun RSA private CRT key, ");
        stringBuffer.append(this.n.bitLength());
        stringBuffer.append(" bits\n  modulus:          ");
        stringBuffer.append(this.n);
        stringBuffer.append("\n  public exponent:  ");
        stringBuffer.append(this.e);
        stringBuffer.append("\n  private exponent: ");
        stringBuffer.append(this.d);
        stringBuffer.append("\n  prime p:          ");
        stringBuffer.append(this.p);
        stringBuffer.append("\n  prime q:          ");
        stringBuffer.append(this.q);
        stringBuffer.append("\n  prime exponent p: ");
        stringBuffer.append(this.pe);
        stringBuffer.append("\n  prime exponent q: ");
        stringBuffer.append(this.qe);
        stringBuffer.append("\n  crt coefficient:  ");
        stringBuffer.append(this.coeff);
        return stringBuffer.toString();
    }
}

