/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.net.URL;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.util.logging.PlatformLogger;

class NTLMAuthenticationProxy {
    private static Method supportsTA;
    private static Method isTrustedSite;
    private static final String clazzStr = "sun.net.www.protocol.http.ntlm.NTLMAuthentication";
    private static final String supportsTAStr = "supportsTransparentAuth";
    private static final String isTrustedSiteStr = "isTrustedSite";
    static final NTLMAuthenticationProxy proxy;
    static final boolean supported;
    static final boolean supportsTransparentAuth;
    private final Constructor<? extends AuthenticationInfo> threeArgCtr;
    private final Constructor<? extends AuthenticationInfo> fiveArgCtr;

    private NTLMAuthenticationProxy(Constructor<? extends AuthenticationInfo> constructor, Constructor<? extends AuthenticationInfo> constructor2) {
        this.threeArgCtr = constructor;
        this.fiveArgCtr = constructor2;
    }

    AuthenticationInfo create(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        try {
            return this.threeArgCtr.newInstance(bl, uRL, passwordAuthentication);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            NTLMAuthenticationProxy.finest(reflectiveOperationException);
            return null;
        }
    }

    AuthenticationInfo create(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        try {
            return this.fiveArgCtr.newInstance(bl, string, n, passwordAuthentication);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            NTLMAuthenticationProxy.finest(reflectiveOperationException);
            return null;
        }
    }

    private static boolean supportsTransparentAuth() {
        try {
            return (Boolean)supportsTA.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            NTLMAuthenticationProxy.finest(reflectiveOperationException);
            return false;
        }
    }

    public static boolean isTrustedSite(URL uRL) {
        try {
            return (Boolean)isTrustedSite.invoke(null, uRL);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            NTLMAuthenticationProxy.finest(reflectiveOperationException);
            return false;
        }
    }

    private static NTLMAuthenticationProxy tryLoadNTLMAuthentication() {
        try {
            Class<?> clazz = Class.forName(clazzStr, true, null);
            if (clazz != null) {
                Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE, URL.class, PasswordAuthentication.class);
                Constructor<?> constructor2 = clazz.getConstructor(Boolean.TYPE, String.class, Integer.TYPE, PasswordAuthentication.class);
                supportsTA = clazz.getDeclaredMethod(supportsTAStr, new Class[0]);
                isTrustedSite = clazz.getDeclaredMethod(isTrustedSiteStr, URL.class);
                return new NTLMAuthenticationProxy(constructor, constructor2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            NTLMAuthenticationProxy.finest(classNotFoundException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
        return null;
    }

    static void finest(Exception exception) {
        PlatformLogger platformLogger = HttpURLConnection.getHttpLogger();
        platformLogger.finest("NTLMAuthenticationProxy: " + exception);
    }

    static {
        proxy = NTLMAuthenticationProxy.tryLoadNTLMAuthentication();
        supported = proxy != null;
        supportsTransparentAuth = supported ? NTLMAuthenticationProxy.supportsTransparentAuth() : false;
    }
}

