/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextFieldPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WTextComponentPeer;

class WTextFieldPeer
extends WTextComponentPeer
implements TextFieldPeer {
    @Override
    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fontMetrics.stringWidth(this.getText()) + 24, fontMetrics.getHeight() + 8);
    }

    @Override
    public boolean handleJavaKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 400: {
                if (keyEvent.getKeyChar() != '\n' || keyEvent.isAltDown() || keyEvent.isControlDown()) break;
                this.postEvent(new ActionEvent(this.target, 1001, this.getText(), keyEvent.getWhen(), keyEvent.getModifiers()));
                return true;
            }
        }
        return false;
    }

    @Override
    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    @Override
    public Dimension getPreferredSize(int n) {
        return this.getMinimumSize(n);
    }

    @Override
    public Dimension getMinimumSize(int n) {
        FontMetrics fontMetrics = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fontMetrics.charWidth('0') * n + 24, fontMetrics.getHeight() + 8);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    WTextFieldPeer(TextField textField) {
        super(textField);
    }

    @Override
    native void create(WComponentPeer var1);

    @Override
    void initialize() {
        TextField textField = (TextField)this.target;
        if (textField.echoCharIsSet()) {
            this.setEchoChar(textField.getEchoChar());
        }
        super.initialize();
    }

    public native void setEchoCharacter(char var1);

    @Override
    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n) {
        return this.getMinimumSize(n);
    }

    public Dimension preferredSize(int n) {
        return this.getPreferredSize(n);
    }
}

