/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.List;
import java.util.Map;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemPoolEntryImpl;
import sun.management.snmp.jvmmib.JvmMemPoolTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpNamedListTableCache;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmMemPoolTableMetaImpl
extends JvmMemPoolTableMeta {
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmMemPoolTableMetaImpl.class);

    public JvmMemPoolTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
        this.cache = new JvmMemPoolTableCache(((JVM_MANAGEMENT_MIB_IMPL)snmpMib).validity() * 30L);
    }

    @Override
    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        return this.getNextOid(null, object);
    }

    @Override
    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        boolean bl = log.isDebugOn();
        try {
            SnmpTableHandler snmpTableHandler;
            if (bl) {
                log.debug("getNextOid", "previous=" + snmpOid);
            }
            if ((snmpTableHandler = this.getHandler(object)) == null) {
                if (bl) {
                    log.debug("getNextOid", "handler is null!");
                }
                throw new SnmpStatusException(224);
            }
            SnmpOid snmpOid2 = snmpTableHandler.getNext(snmpOid);
            if (bl) {
                log.debug("getNextOid", "next=" + snmpOid2);
            }
            if (snmpOid2 == null) {
                throw new SnmpStatusException(224);
            }
            return snmpOid2;
        }
        catch (SnmpStatusException snmpStatusException) {
            if (bl) {
                log.debug("getNextOid", "End of MIB View: " + snmpStatusException);
            }
            throw snmpStatusException;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                log.debug("getNextOid", "Unexpected exception: " + runtimeException);
            }
            if (bl) {
                log.debug("getNextOid", runtimeException);
            }
            throw runtimeException;
        }
    }

    @Override
    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        return snmpTableHandler.contains(snmpOid);
    }

    @Override
    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        Object object;
        String string;
        if (snmpOid == null) {
            throw new SnmpStatusException(224);
        }
        Map map = (Map)Util.cast(JvmContextFactory.getUserData());
        long l = snmpOid.getOidArc(0);
        String string2 = string = map == null ? null : "JvmMemPoolTable.entry." + l;
        if (map != null && (object = map.get(string)) != null) {
            return object;
        }
        object = this.getHandler(map);
        if (object == null) {
            throw new SnmpStatusException(224);
        }
        Object object2 = object.getData(snmpOid);
        if (object2 == null) {
            throw new SnmpStatusException(224);
        }
        if (log.isDebugOn()) {
            log.debug("getEntry", "data is a: " + object2.getClass().getName());
        }
        JvmMemPoolEntryImpl jvmMemPoolEntryImpl = new JvmMemPoolEntryImpl((MemoryPoolMXBean)object2, (int)l);
        if (map != null && jvmMemPoolEntryImpl != null) {
            map.put(string, jvmMemPoolEntryImpl);
        }
        return jvmMemPoolEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)Util.cast(object) : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmMemPoolTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmMemPoolTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private static class JvmMemPoolTableCache
    extends SnmpNamedListTableCache {
        JvmMemPoolTableCache(long l) {
            this.validity = l;
        }

        @Override
        protected String getKey(Object object, List list, int n, Object object2) {
            if (object2 == null) {
                return null;
            }
            String string = ((MemoryPoolMXBean)object2).getName();
            log.debug("getKey", "key=" + string);
            return string;
        }

        @Override
        public SnmpTableHandler getTableHandler() {
            Map<Object, Object> map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        @Override
        protected String getRawDatasKey() {
            return "JvmMemManagerTable.getMemoryPools";
        }

        @Override
        protected List loadRawDatas(Map map) {
            return ManagementFactory.getMemoryPoolMXBeans();
        }
    }
}

