/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.kcms;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.java2d.cmm.ColorTransform;
import sun.java2d.cmm.ProfileDeferralMgr;
import sun.java2d.cmm.kcms.CMM;
import sun.java2d.cmm.kcms.CMMImageLayout;
import sun.java2d.cmm.kcms.pelArrayInfo;

public class ICC_Transform
implements ColorTransform {
    long ID;

    long getID() {
        return this.ID;
    }

    public void finalize() {
        CMM.checkStatus(CMM.cmmFreeTransform(this.ID));
    }

    @Override
    public int getNumInComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[0];
    }

    @Override
    public int getNumOutComponents() {
        int[] nArray = new int[2];
        CMM.checkStatus(CMM.cmmGetNumComponents(this.ID, nArray));
        return nArray[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void colorConvert(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n;
        int n2;
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(bufferedImage);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(bufferedImage2)) != null) {
            ICC_Transform iCC_Transform = this;
            synchronized (iCC_Transform) {
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            }
            return;
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        ColorModel colorModel2 = bufferedImage2.getColorModel();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = colorModel.getNumColorComponents();
        int n6 = colorModel2.getNumColorComponents();
        int n7 = 8;
        float f = 255.0f;
        for (n2 = 0; n2 < n5; ++n2) {
            if (colorModel.getComponentSize(n2) <= 8) continue;
            n7 = 16;
            f = 65535.0f;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (colorModel2.getComponentSize(n2) <= 8) continue;
            n7 = 16;
            f = 65535.0f;
        }
        float[] fArray = new float[n5];
        float[] fArray2 = new float[n5];
        ColorSpace colorSpace = colorModel.getColorSpace();
        for (int i = 0; i < n5; ++i) {
            fArray[i] = colorSpace.getMinValue(i);
            fArray2[i] = f / (colorSpace.getMaxValue(i) - fArray[i]);
        }
        colorSpace = colorModel2.getColorSpace();
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[n6];
        for (n = 0; n < n6; ++n) {
            fArray3[n] = colorSpace.getMinValue(n);
            fArray4[n] = (colorSpace.getMaxValue(n) - fArray3[n]) / f;
        }
        n = colorModel2.hasAlpha() ? 1 : 0;
        boolean bl = colorModel.hasAlpha() && n != 0;
        float[] fArray5 = n != 0 ? new float[n6 + 1] : new float[n6];
        if (n7 == 8) {
            byte[] byArray = new byte[n3 * n5];
            byte[] byArray2 = new byte[n3 * n6];
            float[] fArray6 = null;
            if (bl) {
                fArray6 = new float[n3];
            }
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            for (int i = 0; i < n4; ++i) {
                int n8;
                int n9;
                Object object = null;
                float[] fArray7 = null;
                int n10 = 0;
                for (n9 = 0; n9 < n3; ++n9) {
                    object = writableRaster.getDataElements(n9, i, object);
                    fArray7 = colorModel.getNormalizedComponents(object, fArray7, 0);
                    for (n8 = 0; n8 < n5; ++n8) {
                        byArray[n10++] = (byte)((fArray7[n8] - fArray[n8]) * fArray2[n8] + 0.5f);
                    }
                    if (!bl) continue;
                    fArray6[n9] = fArray7[n5];
                }
                ICC_Transform iCC_Transform = this;
                synchronized (iCC_Transform) {
                    CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                }
                object = null;
                n10 = 0;
                for (n9 = 0; n9 < n3; ++n9) {
                    for (n8 = 0; n8 < n6; ++n8) {
                        fArray5[n8] = (float)(byArray2[n10++] & 0xFF) * fArray4[n8] + fArray3[n8];
                    }
                    if (bl) {
                        fArray5[n6] = fArray6[n9];
                    } else if (n != 0) {
                        fArray5[n6] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n9, i, object);
                }
            }
        } else {
            short[] sArray = new short[n3 * n5];
            short[] sArray2 = new short[n3 * n6];
            float[] fArray8 = null;
            if (bl) {
                fArray8 = new float[n3];
            }
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            for (int i = 0; i < n4; ++i) {
                int n11;
                int n12;
                Object object = null;
                float[] fArray9 = null;
                int n13 = 0;
                for (n12 = 0; n12 < n3; ++n12) {
                    object = writableRaster.getDataElements(n12, i, object);
                    fArray9 = colorModel.getNormalizedComponents(object, fArray9, 0);
                    for (n11 = 0; n11 < n5; ++n11) {
                        sArray[n13++] = (short)((fArray9[n11] - fArray[n11]) * fArray2[n11] + 0.5f);
                    }
                    if (!bl) continue;
                    fArray8[n12] = fArray9[n5];
                }
                ICC_Transform iCC_Transform = this;
                synchronized (iCC_Transform) {
                    CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                }
                object = null;
                n13 = 0;
                for (n12 = 0; n12 < n3; ++n12) {
                    for (n11 = 0; n11 < n6; ++n11) {
                        fArray5[n11] = (float)(sArray2[n13++] & 0xFFFF) * fArray4[n11] + fArray3[n11];
                    }
                    if (bl) {
                        fArray5[n6] = fArray8[n12];
                    } else if (n != 0) {
                        fArray5[n6] = 1.0f;
                    }
                    object = colorModel2.getDataElements(fArray5, 0, object);
                    writableRaster2.setDataElements(n12, i, object);
                }
            }
        }
    }

    private CMMImageLayout getImageLayout(BufferedImage bufferedImage) {
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return new CMMImageLayout(bufferedImage);
            }
            case 5: 
            case 6: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 10: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 8) {
                    return null;
                }
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
            case 11: {
                ComponentColorModel componentColorModel = (ComponentColorModel)bufferedImage.getColorModel();
                if (componentColorModel.getComponentSize(0) != 16) {
                    return null;
                }
                if (componentColorModel.getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                    return new CMMImageLayout(bufferedImage);
                }
                return null;
            }
        }
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof DirectColorModel) {
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
                return null;
            }
            if (colorModel.getTransferType() != 3) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n = directColorModel.getRedMask();
            int n2 = directColorModel.getGreenMask();
            int n3 = directColorModel.getBlueMask();
            int n4 = directColorModel.getAlphaMask();
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = 0;
            int n10 = 3;
            if (n4 != 0) {
                n10 = 4;
            }
            int n11 = 0;
            int n12 = -16777216;
            while (n11 < 4) {
                if (n == n12) {
                    n8 = n11;
                    ++n9;
                } else if (n2 == n12) {
                    n7 = n11;
                    ++n9;
                } else if (n3 == n12) {
                    n6 = n11;
                    ++n9;
                } else if (n4 == n12) {
                    n5 = n11;
                    ++n9;
                }
                ++n11;
                n12 >>>= 8;
            }
            if (n9 != n10) {
                return null;
            }
            return new CMMImageLayout(bufferedImage, (SinglePixelPackedSampleModel)sampleModel, n8, n7, n6, n5);
        }
        if (colorModel instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel;
            int n;
            SampleModel sampleModel = bufferedImage.getSampleModel();
            if (!(sampleModel instanceof ComponentSampleModel)) {
                return null;
            }
            if (colorModel.hasAlpha() && colorModel.isAlphaPremultiplied()) {
                return null;
            }
            int n13 = colorModel.getNumComponents();
            if (sampleModel.getNumBands() != n13) {
                return null;
            }
            int n14 = colorModel.getTransferType();
            if (n14 == 0) {
                for (n = 0; n < n13; ++n) {
                    if (colorModel.getComponentSize(n) == 8) continue;
                    return null;
                }
            } else if (n14 == 1) {
                for (n = 0; n < n13; ++n) {
                    if (colorModel.getComponentSize(n) == 16) continue;
                    return null;
                }
            } else {
                return null;
            }
            if ((componentColorModel = (ComponentColorModel)colorModel).getClass() == ComponentColorModel.class || this.checkMinMaxScaling(componentColorModel)) {
                return new CMMImageLayout(bufferedImage, (ComponentSampleModel)sampleModel);
            }
            return null;
        }
        return null;
    }

    private boolean checkMinMaxScaling(ComponentColorModel componentColorModel) {
        float f;
        float[] fArray;
        float[] fArray2;
        int n;
        Object object;
        int n2 = componentColorModel.getNumComponents();
        int n3 = componentColorModel.getNumColorComponents();
        int[] nArray = componentColorModel.getComponentSize();
        boolean bl = componentColorModel.hasAlpha();
        switch (componentColorModel.getTransferType()) {
            case 0: {
                object = new byte[n2];
                for (n = 0; n < n3; ++n) {
                    object[n] = 0;
                }
                if (bl) {
                    object[n3] = (byte)((1 << nArray[n3]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                for (n = 0; n < n3; ++n) {
                    object[n] = (byte)((1 << nArray[n]) - 1);
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f = 256.0f;
                break;
            }
            case 1: {
                object = new short[n2];
                for (n = 0; n < n3; ++n) {
                    object[n] = 0;
                }
                if (bl) {
                    object[n3] = (byte)((1 << nArray[n3]) - 1);
                }
                fArray2 = componentColorModel.getNormalizedComponents(object, null, 0);
                for (n = 0; n < n3; ++n) {
                    object[n] = (byte)((1 << nArray[n]) - 1);
                }
                fArray = componentColorModel.getNormalizedComponents(object, null, 0);
                f = 65536.0f;
                break;
            }
            default: {
                return false;
            }
        }
        object = componentColorModel.getColorSpace();
        for (n = 0; n < n3; ++n) {
            float f2 = ((ColorSpace)object).getMinValue(n);
            float f3 = ((ColorSpace)object).getMaxValue(n);
            float f4 = (f3 - f2) / f;
            if ((f2 -= fArray2[n]) < 0.0f) {
                f2 = -f2;
            }
            if ((f3 -= fArray[n]) < 0.0f) {
                f3 = -f3;
            }
            if (!(f2 > f4) && !(f3 > f4)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void colorConvert(Raster raster, WritableRaster writableRaster, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n2 = raster.getTransferType();
        int n3 = writableRaster.getTransferType();
        boolean bl = n2 == 4 || n2 == 5;
        boolean bl2 = n3 == 4 || n3 == 5;
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getNumBands();
        int n7 = writableRaster.getNumBands();
        float[] fArray5 = new float[n6];
        float[] fArray6 = new float[n7];
        float[] fArray7 = new float[n6];
        float[] fArray8 = new float[n7];
        for (n = 0; n < n6; ++n) {
            if (bl) {
                fArray5[n] = 65535.0f / (fArray2[n] - fArray[n]);
                fArray7[n] = fArray[n];
                continue;
            }
            fArray5[n] = n2 == 2 ? 2.0000305f : 65535.0f / (float)((1 << sampleModel.getSampleSize(n)) - 1);
            fArray7[n] = 0.0f;
        }
        for (n = 0; n < n7; ++n) {
            if (bl2) {
                fArray6[n] = (fArray4[n] - fArray3[n]) / 65535.0f;
                fArray8[n] = fArray3[n];
                continue;
            }
            fArray6[n] = n3 == 2 ? 0.49999237f : (float)((1 << sampleModel2.getSampleSize(n)) - 1) / 65535.0f;
            fArray8[n] = 0.0f;
        }
        n = raster.getMinY();
        int n8 = writableRaster.getMinY();
        short[] sArray = new short[n4 * n6];
        short[] sArray2 = new short[n4 * n7];
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        int n9 = 0;
        while (n9 < n5) {
            float f;
            int n10;
            int n11 = raster.getMinX();
            int n12 = 0;
            int n13 = 0;
            while (n13 < n4) {
                for (n10 = 0; n10 < n6; ++n10) {
                    f = raster.getSampleFloat(n11, n, n10);
                    sArray[n12++] = (short)((f - fArray7[n10]) * fArray5[n10] + 0.5f);
                }
                ++n13;
                ++n11;
            }
            ICC_Transform iCC_Transform = this;
            synchronized (iCC_Transform) {
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
            }
            int n14 = writableRaster.getMinX();
            n12 = 0;
            n13 = 0;
            while (n13 < n4) {
                for (n10 = 0; n10 < n7; ++n10) {
                    f = (float)(sArray2[n12++] & 0xFFFF) * fArray6[n10] + fArray8[n10];
                    writableRaster.setSample(n14, n8, n10, f);
                }
                ++n13;
                ++n14;
            }
            ++n9;
            ++n;
            ++n8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void colorConvert(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        CMMImageLayout cMMImageLayout;
        CMMImageLayout cMMImageLayout2 = this.getImageLayout(raster);
        if (cMMImageLayout2 != null && (cMMImageLayout = this.getImageLayout(writableRaster)) != null) {
            ICC_Transform iCC_Transform = this;
            synchronized (iCC_Transform) {
                CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
            }
            return;
        }
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        int n3 = raster.getTransferType();
        int n4 = writableRaster.getTransferType();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getNumBands();
        int n8 = writableRaster.getNumBands();
        int n9 = 8;
        float f = 255.0f;
        for (n2 = 0; n2 < n7; ++n2) {
            if (sampleModel.getSampleSize(n2) <= 8) continue;
            n9 = 16;
            f = 65535.0f;
        }
        for (n2 = 0; n2 < n8; ++n2) {
            if (sampleModel2.getSampleSize(n2) <= 8) continue;
            n9 = 16;
            f = 65535.0f;
        }
        float[] fArray = new float[n7];
        float[] fArray2 = new float[n8];
        for (n = 0; n < n7; ++n) {
            fArray[n] = n3 == 2 ? f / 32767.0f : f / (float)((1 << sampleModel.getSampleSize(n)) - 1);
        }
        for (n = 0; n < n8; ++n) {
            fArray2[n] = n4 == 2 ? 32767.0f / f : (float)((1 << sampleModel2.getSampleSize(n)) - 1) / f;
        }
        n = raster.getMinY();
        int n10 = writableRaster.getMinY();
        if (n9 == 8) {
            byte[] byArray = new byte[n5 * n7];
            byte[] byArray2 = new byte[n5 * n8];
            pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
            cMMImageLayout2 = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
            cMMImageLayout = new CMMImageLayout(byArray2, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
            int n11 = 0;
            while (n11 < n6) {
                int n12;
                int n13;
                int n14 = raster.getMinX();
                int n15 = 0;
                int n16 = 0;
                while (n16 < n5) {
                    for (n13 = 0; n13 < n7; ++n13) {
                        n12 = raster.getSample(n14, n, n13);
                        byArray[n15++] = (byte)((float)n12 * fArray[n13] + 0.5f);
                    }
                    ++n16;
                    ++n14;
                }
                ICC_Transform iCC_Transform = this;
                synchronized (iCC_Transform) {
                    CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                }
                int n17 = writableRaster.getMinX();
                n15 = 0;
                n16 = 0;
                while (n16 < n5) {
                    for (n13 = 0; n13 < n8; ++n13) {
                        n12 = (int)((float)(byArray2[n15++] & 0xFF) * fArray2[n13] + 0.5f);
                        writableRaster.setSample(n17, n10, n13, n12);
                    }
                    ++n16;
                    ++n17;
                }
                ++n11;
                ++n;
                ++n10;
            }
        } else {
            short[] sArray = new short[n5 * n7];
            short[] sArray2 = new short[n5 * n8];
            pelArrayInfo pelArrayInfo3 = new pelArrayInfo(this, sArray, sArray2);
            cMMImageLayout2 = new CMMImageLayout(sArray, pelArrayInfo3.nPels, pelArrayInfo3.nSrc);
            cMMImageLayout = new CMMImageLayout(sArray2, pelArrayInfo3.nPels, pelArrayInfo3.nDest);
            int n18 = 0;
            while (n18 < n6) {
                int n19;
                int n20;
                int n21 = raster.getMinX();
                int n22 = 0;
                int n23 = 0;
                while (n23 < n5) {
                    for (n20 = 0; n20 < n7; ++n20) {
                        n19 = raster.getSample(n21, n, n20);
                        sArray[n22++] = (short)((float)n19 * fArray[n20] + 0.5f);
                    }
                    ++n23;
                    ++n21;
                }
                ICC_Transform iCC_Transform = this;
                synchronized (iCC_Transform) {
                    CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout2, cMMImageLayout));
                }
                int n24 = writableRaster.getMinX();
                n22 = 0;
                n23 = 0;
                while (n23 < n5) {
                    for (n20 = 0; n20 < n8; ++n20) {
                        n19 = (int)((float)(sArray2[n22++] & 0xFFFF) * fArray2[n20] + 0.5f);
                        writableRaster.setSample(n24, n10, n20, n19);
                    }
                    ++n23;
                    ++n24;
                }
                ++n18;
                ++n;
                ++n10;
            }
        }
    }

    private CMMImageLayout getImageLayout(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel instanceof ComponentSampleModel) {
            int n = raster.getNumBands();
            int n2 = sampleModel.getTransferType();
            if (n2 == 0) {
                for (int i = 0; i < n; ++i) {
                    if (sampleModel.getSampleSize(i) == 8) continue;
                    return null;
                }
            } else if (n2 == 1) {
                for (int i = 0; i < n; ++i) {
                    if (sampleModel.getSampleSize(i) == 16) continue;
                    return null;
                }
            } else {
                return null;
            }
            return new CMMImageLayout(raster, (ComponentSampleModel)sampleModel);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] colorConvert(short[] sArray, short[] sArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, sArray, sArray2);
        short[] sArray3 = sArray2 != null ? sArray2 : new short[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(sArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(sArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        ICC_Transform iCC_Transform = this;
        synchronized (iCC_Transform) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        }
        return sArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] colorConvert(byte[] byArray, byte[] byArray2) {
        pelArrayInfo pelArrayInfo2 = new pelArrayInfo(this, byArray, byArray2);
        byte[] byArray3 = byArray2 != null ? byArray2 : new byte[pelArrayInfo2.destSize];
        CMMImageLayout cMMImageLayout = new CMMImageLayout(byArray, pelArrayInfo2.nPels, pelArrayInfo2.nSrc);
        CMMImageLayout cMMImageLayout2 = new CMMImageLayout(byArray3, pelArrayInfo2.nPels, pelArrayInfo2.nDest);
        ICC_Transform iCC_Transform = this;
        synchronized (iCC_Transform) {
            CMM.checkStatus(CMM.cmmColorConvert(this.ID, cMMImageLayout, cMMImageLayout2));
        }
        return byArray3;
    }

    static {
        if (ProfileDeferralMgr.deferring) {
            ProfileDeferralMgr.activateProfiles();
        }
    }
}

