/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Stack;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.sql.rowset.spi.XmlWriter;

public class WebRowSetXmlWriter
implements XmlWriter,
Serializable {
    private Writer writer;
    private Stack stack;
    private JdbcRowSetResourceBundle resBundle;
    static final long serialVersionUID = 7163134986189677641L;

    public WebRowSetXmlWriter() {
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void writeXML(WebRowSet webRowSet, Writer writer) throws SQLException {
        this.stack = new Stack();
        this.writer = writer;
        this.writeRowSet(webRowSet);
    }

    public void writeXML(WebRowSet webRowSet, OutputStream outputStream) throws SQLException {
        this.stack = new Stack();
        this.writer = new OutputStreamWriter(outputStream);
        this.writeRowSet(webRowSet);
    }

    private void writeRowSet(WebRowSet webRowSet) throws SQLException {
        try {
            this.startHeader();
            this.writeProperties(webRowSet);
            this.writeMetaData(webRowSet);
            this.writeData(webRowSet);
            this.endHeader();
        }
        catch (IOException iOException) {
            throw new SQLException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.ioex").toString(), iOException.getMessage()));
        }
    }

    private void startHeader() throws IOException {
        this.setTag("webRowSet");
        this.writer.write("<?xml version=\"1.0\"?>\n");
        this.writer.write("<webRowSet xmlns=\"http://java.sun.com/xml/ns/jdbc\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        this.writer.write("xsi:schemaLocation=\"http://java.sun.com/xml/ns/jdbc http://java.sun.com/xml/ns/jdbc/webrowset.xsd\">\n");
    }

    private void endHeader() throws IOException {
        this.endTag("webRowSet");
    }

    private void writeProperties(WebRowSet webRowSet) throws IOException {
        this.beginSection("properties");
        try {
            Object object;
            String string2;
            this.propString("command", this.processSpecialCharacters(webRowSet.getCommand()));
            this.propInteger("concurrency", webRowSet.getConcurrency());
            this.propString("datasource", webRowSet.getDataSourceName());
            this.propBoolean("escape-processing", webRowSet.getEscapeProcessing());
            try {
                this.propInteger("fetch-direction", webRowSet.getFetchDirection());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.propInteger("fetch-size", webRowSet.getFetchSize());
            this.propInteger("isolation-level", webRowSet.getTransactionIsolation());
            this.beginSection("key-columns");
            int[] nArray = webRowSet.getKeyColumns();
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                this.propInteger("column", nArray[i]);
            }
            this.endSection("key-columns");
            this.beginSection("map");
            Map<String, Class<?>> map = webRowSet.getTypeMap();
            if (map != null) {
                for (String string2 : map.keySet()) {
                    object = map.get(string2);
                    this.propString("type", string2);
                    this.propString("class", ((Class)object).getName());
                }
            }
            this.endSection("map");
            this.propInteger("max-field-size", webRowSet.getMaxFieldSize());
            this.propInteger("max-rows", webRowSet.getMaxRows());
            this.propInteger("query-timeout", webRowSet.getQueryTimeout());
            this.propBoolean("read-only", webRowSet.isReadOnly());
            int n = webRowSet.getType();
            object = "";
            if (n == 1003) {
                object = "ResultSet.TYPE_FORWARD_ONLY";
            } else if (n == 1004) {
                object = "ResultSet.TYPE_SCROLL_INSENSITIVE";
            } else if (n == 1005) {
                object = "ResultSet.TYPE_SCROLL_SENSITIVE";
            }
            this.propString("rowset-type", (String)object);
            this.propBoolean("show-deleted", webRowSet.getShowDeleted());
            this.propString("table-name", webRowSet.getTableName());
            this.propString("url", webRowSet.getUrl());
            this.beginSection("sync-provider");
            string2 = webRowSet.getSyncProvider().toString();
            String string3 = string2.substring(0, webRowSet.getSyncProvider().toString().indexOf("@"));
            this.propString("sync-provider-name", string3);
            this.propString("sync-provider-vendor", "Oracle Corporation");
            this.propString("sync-provider-version", "1.0");
            this.propInteger("sync-provider-grade", webRowSet.getSyncProvider().getProviderGrade());
            this.propInteger("data-source-lock", webRowSet.getSyncProvider().getDataSourceLock());
            this.endSection("sync-provider");
        }
        catch (SQLException sQLException) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), sQLException.getMessage()));
        }
        this.endSection("properties");
    }

    private void writeMetaData(WebRowSet webRowSet) throws IOException {
        this.beginSection("metadata");
        try {
            ResultSetMetaData resultSetMetaData = webRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.propInteger("column-count", n);
            for (int i = 1; i <= n; ++i) {
                this.beginSection("column-definition");
                this.propInteger("column-index", i);
                this.propBoolean("auto-increment", resultSetMetaData.isAutoIncrement(i));
                this.propBoolean("case-sensitive", resultSetMetaData.isCaseSensitive(i));
                this.propBoolean("currency", resultSetMetaData.isCurrency(i));
                this.propInteger("nullable", resultSetMetaData.isNullable(i));
                this.propBoolean("signed", resultSetMetaData.isSigned(i));
                this.propBoolean("searchable", resultSetMetaData.isSearchable(i));
                this.propInteger("column-display-size", resultSetMetaData.getColumnDisplaySize(i));
                this.propString("column-label", resultSetMetaData.getColumnLabel(i));
                this.propString("column-name", resultSetMetaData.getColumnName(i));
                this.propString("schema-name", resultSetMetaData.getSchemaName(i));
                this.propInteger("column-precision", resultSetMetaData.getPrecision(i));
                this.propInteger("column-scale", resultSetMetaData.getScale(i));
                this.propString("table-name", resultSetMetaData.getTableName(i));
                this.propString("catalog-name", resultSetMetaData.getCatalogName(i));
                this.propInteger("column-type", resultSetMetaData.getColumnType(i));
                this.propString("column-type-name", resultSetMetaData.getColumnTypeName(i));
                this.endSection("column-definition");
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), sQLException.getMessage()));
        }
        this.endSection("metadata");
    }

    private void writeData(WebRowSet webRowSet) throws IOException {
        try {
            ResultSetMetaData resultSetMetaData = webRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.beginSection("data");
            webRowSet.beforeFirst();
            webRowSet.setShowDeleted(true);
            while (webRowSet.next()) {
                if (webRowSet.rowDeleted() && webRowSet.rowInserted()) {
                    this.beginSection("modifyRow");
                } else if (webRowSet.rowDeleted()) {
                    this.beginSection("deleteRow");
                } else if (webRowSet.rowInserted()) {
                    this.beginSection("insertRow");
                } else {
                    this.beginSection("currentRow");
                }
                for (int i = 1; i <= n; ++i) {
                    if (webRowSet.columnUpdated(i)) {
                        ResultSet resultSet = webRowSet.getOriginalRow();
                        resultSet.next();
                        this.beginTag("columnValue");
                        this.writeValue(i, (RowSet)resultSet);
                        this.endTag("columnValue");
                        this.beginTag("updateRow");
                        this.writeValue(i, webRowSet);
                        this.endTag("updateRow");
                        continue;
                    }
                    this.beginTag("columnValue");
                    this.writeValue(i, webRowSet);
                    this.endTag("columnValue");
                }
                this.endSection();
            }
            this.endSection("data");
        }
        catch (SQLException sQLException) {
            throw new IOException(MessageFormat.format(this.resBundle.handleGetObject("wrsxmlwriter.sqlex").toString(), sQLException.getMessage()));
        }
    }

    private void writeValue(int n, RowSet rowSet) throws IOException {
        try {
            int n2 = rowSet.getMetaData().getColumnType(n);
            switch (n2) {
                case -7: 
                case 16: {
                    boolean bl = rowSet.getBoolean(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeBoolean(bl);
                    break;
                }
                case -6: 
                case 5: {
                    short s = rowSet.getShort(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeShort(s);
                    break;
                }
                case 4: {
                    int n3 = rowSet.getInt(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeInteger(n3);
                    break;
                }
                case -5: {
                    long l = rowSet.getLong(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(l);
                    break;
                }
                case 6: 
                case 7: {
                    float f = rowSet.getFloat(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeFloat(f);
                    break;
                }
                case 8: {
                    double d = rowSet.getDouble(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeDouble(d);
                    break;
                }
                case 2: 
                case 3: {
                    this.writeBigDecimal(rowSet.getBigDecimal(n));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    break;
                }
                case 91: {
                    Date date = rowSet.getDate(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(date.getTime());
                    break;
                }
                case 92: {
                    Time time = rowSet.getTime(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(time.getTime());
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowSet.getTimestamp(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                        break;
                    }
                    this.writeLong(timestamp.getTime());
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.writeStringData(rowSet.getString(n));
                    break;
                }
                default: {
                    System.out.println(this.resBundle.handleGetObject("wsrxmlwriter.notproper").toString());
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(this.resBundle.handleGetObject("wrsxmlwriter.failedwrite").toString() + sQLException.getMessage());
        }
    }

    private void beginSection(String string) throws IOException {
        this.setTag(string);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + string + ">\n");
    }

    private void endSection(String string) throws IOException {
        this.writeIndent(this.stack.size());
        String string2 = this.getTag();
        if (string2.indexOf("webRowSet") != -1) {
            string2 = "webRowSet";
        }
        if (string.equals(string2)) {
            this.writer.write("</" + string2 + ">\n");
        }
        this.writer.flush();
    }

    private void endSection() throws IOException {
        this.writeIndent(this.stack.size());
        String string = this.getTag();
        this.writer.write("</" + string + ">\n");
        this.writer.flush();
    }

    private void beginTag(String string) throws IOException {
        this.setTag(string);
        this.writeIndent(this.stack.size());
        this.writer.write("<" + string + ">");
    }

    private void endTag(String string) throws IOException {
        String string2 = this.getTag();
        if (string.equals(string2)) {
            this.writer.write("</" + string2 + ">\n");
        }
        this.writer.flush();
    }

    private void emptyTag(String string) throws IOException {
        this.writer.write("<" + string + "/>");
    }

    private void setTag(String string) {
        this.stack.push(string);
    }

    private String getTag() {
        return (String)this.stack.pop();
    }

    private void writeNull() throws IOException {
        this.emptyTag("null");
    }

    private void writeStringData(String string) throws IOException {
        if (string == null) {
            this.writeNull();
        } else if (string.equals("")) {
            this.writeEmptyString();
        } else {
            string = this.processSpecialCharacters(string);
            this.writer.write(string);
        }
    }

    private void writeString(String string) throws IOException {
        if (string != null) {
            this.writer.write(string);
        } else {
            this.writeNull();
        }
    }

    private void writeShort(short s) throws IOException {
        this.writer.write(Short.toString(s));
    }

    private void writeLong(long l) throws IOException {
        this.writer.write(Long.toString(l));
    }

    private void writeInteger(int n) throws IOException {
        this.writer.write(Integer.toString(n));
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.writer.write(Boolean.valueOf(bl).toString());
    }

    private void writeFloat(float f) throws IOException {
        this.writer.write(Float.toString(f));
    }

    private void writeDouble(double d) throws IOException {
        this.writer.write(Double.toString(d));
    }

    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.writer.write(bigDecimal.toString());
        } else {
            this.emptyTag("null");
        }
    }

    private void writeIndent(int n) throws IOException {
        for (int i = 1; i < n; ++i) {
            this.writer.write("  ");
        }
    }

    private void propString(String string, String string2) throws IOException {
        this.beginTag(string);
        this.writeString(string2);
        this.endTag(string);
    }

    private void propInteger(String string, int n) throws IOException {
        this.beginTag(string);
        this.writeInteger(n);
        this.endTag(string);
    }

    private void propBoolean(String string, boolean bl) throws IOException {
        this.beginTag(string);
        this.writeBoolean(bl);
        this.endTag(string);
    }

    private void writeEmptyString() throws IOException {
        this.emptyTag("emptyString");
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) {
        return false;
    }

    private String processSpecialCharacters(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        String string2 = "";
        for (int i = 0; i < cArray.length; ++i) {
            string2 = cArray[i] == '&' ? string2.concat("&amp;") : (cArray[i] == '<' ? string2.concat("&lt;") : (cArray[i] == '>' ? string2.concat("&gt;") : (cArray[i] == '\'' ? string2.concat("&apos;") : (cArray[i] == '\"' ? string2.concat("&quot;") : string2.concat(String.valueOf(cArray[i]))))));
        }
        string = string2;
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

