/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.Platform;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.List;

public final class DeployClassLoader
extends URLClassLoader {
    private boolean fx_injected = false;
    private final PermissionCollection all_perms;
    private VersionID fx_ver = null;
    public static final ThreadLocal loadingClass = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    public DeployClassLoader() {
        super(new URL[0]);
        AllPermission allPermission = new AllPermission();
        this.all_perms = allPermission.newPermissionCollection();
        this.all_perms.add(allPermission);
    }

    private void checkInjectJfxPermission(String string) throws IllegalStateException, ClassNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPackageDefinition("com.javafx");
        }
        VersionID versionID = new VersionID(string);
        if (this.fx_injected && this.fx_ver.match(versionID)) {
            throw new IllegalStateException();
        }
        if (!Platform.get().isJavaFXEnabled()) {
            throw new ClassNotFoundException();
        }
    }

    public synchronized void injectJfx(String string) throws ClassNotFoundException, IllegalStateException {
        this.checkInjectJfxPermission(string);
        VersionString versionString = new VersionString(string);
        List list = versionString.getAllVersionIDs();
        for (int i = 0; i < list.size(); ++i) {
            VersionID versionID = (VersionID)list.get(i);
            JfxRuntime jfxRuntime = Platform.get().getBestJfxRuntime(versionID);
            if (jfxRuntime == null) continue;
            this.injectJfx(jfxRuntime);
            return;
        }
        throw new ClassNotFoundException();
    }

    public synchronized void injectJfx(JfxRuntime jfxRuntime) throws ClassNotFoundException, IllegalStateException {
        this.checkInjectJfxPermission(null);
        if (jfxRuntime == null) {
            throw new ClassNotFoundException();
        }
        URL[] uRLArray = jfxRuntime.getURLs();
        if (null == uRLArray) {
            throw new ClassNotFoundException();
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            this.addURL(uRLArray[i]);
        }
        this.fx_injected = true;
        this.fx_ver = jfxRuntime.getProductVersion();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        URL uRL = codeSource.getLocation();
        URL[] uRLArray = this.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!uRLArray[i].equals(uRL)) continue;
            return this.all_perms;
        }
        return super.getPermissions(codeSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (!this.fx_injected) {
            return super.loadClass(string, bl);
        }
        loadingClass.set(Boolean.TRUE);
        Class<?> clazz = null;
        Object var4_4 = null;
        try {
            clazz = super.loadClass(string, bl);
            var4_4 = loadingClass.get();
            Object var6_5 = null;
            loadingClass.set(Boolean.FALSE);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            loadingClass.set(Boolean.FALSE);
            throw throwable;
        }
        if (clazz != null) {
            return clazz;
        }
        if (var4_4 instanceof RuntimeException) {
            throw (RuntimeException)var4_4;
        }
        return null;
    }

    public static void setClassLoadingException(Throwable throwable) {
        loadingClass.set(throwable);
    }

    public static boolean isLoadingClass() {
        Object t = loadingClass.get();
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        return false;
    }
}

