!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : set_init_state
!  Function(s)   : fn_tf_psi, fn_tf_rho, fn_chi
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine set_init_state(ier)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   use parameters
   implicit none
   integer,intent(out) :: ier
   integer :: ishell, nn, ir, ip
   real(8) :: r, sum1, sum2, fn_tf_rho
   ier = 0
   nmm_pos(:)  = nmesh
   dee_save(:) = 0.d0
   etot_sum    = -1.d0
   do ishell = 1,nshell
      nn = n_qnum(ishell)
      engy    (ishell) = -0.5d0 * fatom**2 / dble(nn)**2
      engy_old(ishell) = engy(ishell)
   end do
   sum1 = 0.d0
   do ir = 1,nmesh
      r = rpos(ir)
      rho(ir,1) = fn_tf_rho(r,fatom)
      sum1 = sum1 + rho(ir,1) * r*r*wr(ir)
   end do
   sum1 = sum1 * 4.d0*PI
   write(IFLOG,10) '??? check: sum of TF-rho, felec  ...',sum1,  felec
   sum2 = 0.d0
   do ir = 1,nmesh
      r = rpos(ir)
      rho(ir,1) = rho(ir,1) * felec/sum1
      if (is_spin == POLARIZED) then
         rho(ir,2) = (felec2/felec) * rho(ir,1)
         rho(ir,1) = rho(ir,1) - rho(ir,2)
         sum2 = sum2 + (rho(ir,1)+rho(ir,2)) * r*r*wr(ir)
      else
         sum2 = sum2 + rho(ir,1) * r*r*wr(ir)
      end if
   end do
   sum2 = sum2 * 4.d0*PI
   write(IFLOG,10) '??? check: initial felec1,felec2 ...',felec1,felec2
   write(IFLOG,10) '??? check: sum of TF-rho, felec  ...',sum2,  felec
10 format(1x,a36,2f15.10)
   rho_old(:,:) = rho(:,:)
   if (n_anderson > 0) then
   do ip = 0,n_anderson
      rho_p    (:,:,ip) = rho    (:,:)
      rho_old_p(:,:,ip) = rho_old(:,:)
   end do
   end if
99 continue
   end subroutine set_init_state

!=====================================================================
   function fn_tf_psi(x)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in) :: x
   real(8) :: fn_tf_psi
   real(8) :: a(4), denom
   a(1) = 1.4712d0 ; a(2) = -0.4973d0
   a(3) = 0.3875d0 ; a(4) =  0.002102d0
   denom = 1.d0 + a(1)*x + a(2)*x**1.5d0 + a(3)*x*x + a(4)*x*x*x
   fn_tf_psi = 1.d0 / denom
   end function fn_tf_psi

!=====================================================================
   function fn_tf_rho(r,fatom)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in) :: fatom
   real(8),intent(in) :: r
   real(8) :: fn_tf_rho
   real(8) :: fn_tf_psi, alpha, beta
   real(8),parameter :: &
      PI = 3.1415926535897932384626433832795028d0
   alpha = 4.d0 * ( 2.d0*fatom/9.d0/PI/PI )**(1.d0/3.d0)
   beta  = ( 2.d0*fatom )**1.5d0 / 3.d0/PI/PI
   fn_tf_rho = beta * ( fn_tf_psi(alpha*r) / r )**1.5d0
   end function fn_tf_rho

!=====================================================================
   function fn_chi(r,n,z)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in) :: n, z
   real(8),intent(in) :: r
   real(8) :: fn_chi
   integer :: n1, n2, k
   real(8) :: a, s, b
   real(8),parameter :: &
      PI = 3.1415926535897932384626433832795028d0
   n1 = 1
   do k = 1, 2*n-1
      n1 = n1 * 2
   end do
   n2 = 1
   do k = 1, 2*n
      n2 = n2 * k
   end do
   b = dble(z)/dble(n)
   a = sqrt(b/PI * dble(n1)/dble(n2))
   s = b*r
   if (s > 300.d0) then
      s = 300.d0
   end if
   fn_chi = a * s**n * exp(-s)
   end function fn_chi
