! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   Version history: 
!
!     4.0:  2013/03/01
!           codes for spin-polarized pseudopotential generation are added
!     4.1:  2013/11/22 - 
!           Info of core wfns and energy contributions can be added to gncpp2
!     4.2:  2014/07/23 - 
!           gncpp2 can be geregated even when nmesh /= 1501
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : lda_pw92, lda_pz81
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine lda_pw92(rho1,rho2,ex,ec,vx,vc,decdrs,decdzeta)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in)  :: rho1, rho2
   real(8),intent(out) :: ex, ec, vx(2), vc(2), decdrs, decdzeta
   integer :: i, ispin, spin(2)
   real(8) :: &
     rho, rs, zeta, zeta2, zeta3, zeta4, &
     q0, q1, lnq1i, dq0, dq1, g(6), dg(6), f, df, ddf0, h, dh, &
     a, b, p(6), aa(6), a1(6), b1(6), b2(6), b3(6), b4(6)
   real(8),parameter :: &
      rhomin = 1.d-25,                                  &
      argmin_ln  = 1.d-15,                              &
      pi     = 3.1415926535897932384626433832795028d0,  &
      cc43   = 1.33333333333333333333333333333333333d0, &
      cc13   = 0.33333333333333333333333333333333333d0
   p (1) = 1.000000d0 ; p (2) =  1.000000d0 ; p (3) =  1.000000d0
   aa(1) = 0.031091d0 ; aa(2) =  0.015545d0 ; aa(3) =  0.016887d0
   a1(1) = 0.213700d0 ; a1(2) =  0.205480d0 ; a1(3) =  0.111250d0
   b1(1) = 7.595700d0 ; b1(2) = 14.118900d0 ; b1(3) = 10.357000d0
   b2(1) = 3.587600d0 ; b2(2) =  6.197700d0 ; b2(3) =  3.623100d0
   b3(1) = 1.638200d0 ; b3(2) =  3.366200d0 ; b3(3) =  0.880260d0
   b4(1) = 0.492940d0 ; b4(2) =  0.625170d0 ; b4(3) =  0.496710d0
   p (4) = 0.750000d0 ; p (5) =  0.750000d0 ; p (6) =  1.000000d0
   aa(4) = 0.031091d0 ; aa(5) =  0.015545d0 ; aa(6) =  0.016887d0 
   a1(4) = 0.082477d0 ; a1(5) =  0.035374d0 ; a1(6) =  0.028829d0 
   b1(4) = 5.148600d0 ; b1(5) =  6.486900d0 ; b1(6) = 10.357000d0
   b2(4) = 1.648300d0 ; b2(5) =  1.308300d0 ; b2(6) =  3.623100d0
   b3(4) = 0.236470d0 ; b3(5) =  0.151800d0 ; b3(6) =  0.479900d0
   b4(4) = 0.206140d0 ; b4(5) =  0.082349d0 ; b4(6) =  0.122790d0
   a = 0.45816529328314289347555448505170232d0
   b = 0.62035049089940001666800681204777816d0
   spin(1) = +1 ; spin(2) = -1     
   rho  = rho1 + rho2
if (rho < rhomin) then
   ex = 0.d0 ; ec = 0.d0 ; vx(:) = 0.d0 ; vc(:) = 0.d0
   decdrs = 0.d0 ; decdzeta = 0.d0
else
   rs    = b / (rho)**cc13
   if ((rho1 < rhomin).and.(rho2 < rhomin)) then
      zeta = 0.d0
      h    = 2.d0
      dh   = 0.d0
      f    = 0.d0
      df   = 0.d0
   else if ((rho1 >= rhomin).and.(rho2 < rhomin)) then
      zeta = +1.d0
      h    = 2.d0**cc43
      dh   = 2.d0**cc13
      f    = 1.d0
      df   = cc43 * dh / (2.d0**cc43 - 2.d0)
   else if ((rho1 < rhomin).and.(rho2 >= rhomin)) then
      zeta = -1.d0
      h    =  2.d0**cc43
      dh   = -2.d0**cc13
      f    =  1.d0
      df   = cc43 * dh / (2.d0**cc43 - 2.d0)
   else
      zeta = (rho1 - rho2) / rho
      h    = (1.d0+zeta)**cc43 + (1.d0-zeta)**cc43
      dh   = (1.d0+zeta)**cc13 - (1.d0-zeta)**cc13
      f    = (h - 2.d0) / (2.d0**cc43 - 2.d0)
      df   = cc43 * dh / (2.d0**cc43 - 2.d0)
   end if
   zeta2 = zeta *zeta
   zeta3 = zeta2*zeta
   zeta4 = zeta2*zeta2
   ddf0  = 1.7099209341613656175639627762446829d0
   ex = -a/rs * (h * 0.5d0)
   do i = 1,3
      q0  = -2.d0*aa(i)*( 1.d0 + a1(i)*rs )
      q1  =  2.d0*aa(i)*( b1(i)*rs**0.5d0 + b2(i)*rs &
                        + b3(i)*rs**1.5d0 + b4(i)*rs**(p(i)+1.d0) )
      dq0 = -2.d0*aa(i)*a1(i)
      dq1 =  aa(i)*( b1(i)*rs**(-0.5d0) + 2.d0*b2(i) &
                   + 3.d0*b3(i)*rs**0.5d0 &
                   + 2.d0*(p(i)+1.d0)*b4(i)*rs**p(i) )
      lnq1i = log( max(1.d0+1.d0/q1, argmin_ln) )
      g (i) = q0  * lnq1i
      !dg(i) = dq0 * lnq1i - q0*dq1/q1/(q1+1.d0)
      dg(i) = dq0 * lnq1i - q0*dq1/q1/q1/exp(lnq1i)
   end do
   ec = g(1) - g(3) * (f/ddf0) * (1.d0 - zeta4) &
        + (g(2) - g(1)) * f * zeta4
   do ispin = 1,2
      vx(ispin) = cc43 * ex &
                * (1.d0 - ( zeta - dble(spin(ispin)) ) * dh/h)
   end do
   decdrs = dg(1) - dg(3) * (f/ddf0) * (1.d0 - zeta4) &
          + (dg(2) - dg(1)) * f * zeta4
   decdzeta = - g(3)/ddf0 * ((1.d0-zeta4)*df - 4.d0*zeta3*f) &
              + (g(2)-g(1)) * (zeta4*df + 4.d0*zeta3*f)
   do ispin = 1,2
      vc(ispin) = ec - rs*cc13 * decdrs &
                     - ( zeta - dble(spin(ispin)) ) * decdzeta
   end do
end if
   end subroutine lda_pw92

!=====================================================================
   subroutine lda_pz81(rho1,rho2,ex,ec,vx,vc)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(in)  :: rho1, rho2
   real(8),intent(out) :: ex, ec, vx(2), vc(2)
   real(8) :: dens, rs, &
              a, b0, b1, b2, b3, c0, c1, c2, c3, c4, c5, eps
   real(8),parameter :: &
      PI = 3.1415926535897932384626433832795028d0
   eps = 1.d-20
   dens = rho1 + rho2
if (dens < eps) then
   ex = 0.d0 ; ec = 0.d0 ; vx(:) = 0.d0 ; vc(:) = 0.d0
else
   rs = (3.d0/4.d0/PI/dens)**(1.d0/3.d0)
   a  = -0.610933333d0 ; b0 = -0.058366666d0 ; b1 =  0.031100000d0
   b2 = -0.008400000d0 ; b3 =  0.001333333d0 ; c0 = -0.142300000d0
   c1 = -0.174798948d0 ; c2 = -0.063257093d0 ; c3 =  1.000000000d0
   c4 =  1.052900000d0 ; c5 =  0.333400000d0
   vx(:) = a/rs
   if (rs < 1.d0) then
      vc(:) = b0+b1*log(rs)+b2*rs+b3*rs*log(rs)
   else
      vc(:) = (c0+c1*sqrt(rs)+c2*rs)/(c3+c4*sqrt(rs)+c5*rs)**2
   end if
   a  = -0.458200000d0 ; b0 = -0.048000000d0 ; b1 =  0.031100000d0
   b2 = -0.011600000d0 ; b3 =  0.002000000d0 ; c0 = -0.142300000d0
   c1 =  1.000000000d0 ; c2 =  1.052900000d0 ; c3 =  0.333400000d0
   ex = a/rs
   if (rs < 1.d0) then
      ec = b0+b1*log(rs)+b2*rs+b3*rs*log(rs)
   else
      ec = c0/(c1+c2*sqrt(rs)+c3*rs)
   end if
end if
   end subroutine lda_pz81
