! ************************************************************* 
!
!   This is a software package CIAO
!
!     developed as a part of the national project "Research and 
!     Development of Innovative Simulation software",which is   
!     supported by the next-generation IT program of MEXT of Japan
!
!   latest version: 
!
!     4.0:  2013/01/17 
!           codes for spin-polarized pseudopotential generation are added
!
! ************************************************************* 
!
!  Software name : CIAO (Code for Investigating Atomic Orbitals)
!  Subroutine(s) : swap
!  Author(s)     : Masakuni Okamoto (August 25, 2003)
!
!  The license of the code and contact address :
!  See the files, COPYRIGHT and LICENSE (or LICENSE_J.pdf)
!
!=====================================================================
   subroutine swap(a,b)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   real(8),intent(inout) :: a, b
   real(8) :: tmp
   tmp = a ; a = b ; b = tmp
   end subroutine swap

!=====================================================================
   subroutine sort_simple(n,val,idx)
!=====================================================================
!
!  M. Okamoto
!
!---------------------------------------------------------------------
   implicit none
   integer,intent(in)  :: n
   real(8),intent(in)  :: val(1:n)
   integer,intent(out) :: idx(1:n)
   integer :: i, j, ipos, jpos
   real(8) :: vi, vj
   do i = 1,n
      idx(i) = i
   end do
   do i = 1,n-1
      ipos = idx(i)
      vi   = val(ipos)
      do j = i+1,n
         jpos = idx(j)
         vj   = val(jpos)
         if (vi > vj) then
            idx(i) = jpos
            idx(j) = ipos
            ipos = jpos
            vi   = vj
         end if
      end do
   end do
   end subroutine sort_simple
