#
#  Makefile for building CIAO (M.Okamoto)
#
.SUFFIXES:
.SUFFIXES: .o .c .f .f90 .cc .ff .ff90

#
#  Compiler options for the GNU Fortran Compiler
#
INCLUDES = -I.
CC       = gcc
CC_NOPT  = 
CC_OPTS  = -O
F77      = gfortran -static-libgfortran
F77_NOPT =
F77_OPTS = -O
F90      = gfortran -static-libgfortran
F90_NOPT =
F90_OPTS = -O
LINK     = gfortran -static-libgfortran
L_OPTS   =
ARCH     = ar
AR_OPTS  = cr
RANLIB   = ranlib
LIBS     = -llapack -lblas
OBJECTS  = \
$(OBJ_CC_OPT) $(OBJ_CC_NOPT) \
$(OBJ_F77_OPT) $(OBJ_F77_NOPT) \
$(OBJ_F90_OPT) $(OBJ_F90_NOPT)

#
#  Linkage Rule
#
$(TARGET) : $(OBJECTS) 
	$(LINK) $(L_OPTS) -o $(TARGET) $(OBJECTS) $(LIBS)

#
#  Compilation Rules
#
%.o : %.cc
	cp -p $*.cc _$*_.c
	$(CC) -c $(CC_NOPT) $(INCLUDES) _$*_.c
	mv _$*_.o $*.o
	rm -f _$*_.c

%.o : %.c
	$(CC) -c $(CC_OPTS) $(INCLUDES) $*.c

%.o : %.ff
	cp -p $*.ff _$*_.f
	$(F77) -c $(F77_NOPT) _$*_.f -o $*.o
	rm -f _$*_.f

%.o : %.f
	$(F77) -c $(F77_OPTS) $*.f -o $*.o

%.o : %.ff90
	cp -p $*.ff90 _$*_.f90
	$(F90) -c $(F90_NOPT) _$*_.f90 -o $*.o
	rm -f _$*_.f90

%.o : %.FF90
	cp -p $*.FF90 _$*_.F90
	$(F90) -c $(F90_NOPT) _$*_.F90 -o $*.o
	rm -f _$*_.F90

%.o : %.f90
	$(F90) -c $(F90_OPTS) $*.f90 -o $*.o

%.o : %.F90
	$(F90) -c $(F90_OPTS) $*.F90 -o $*.o

