#!/usr/bin/perl
#
#  Copyright (C) 2003, 2004 Takenori Yamamoto and Masakuni Okamoto.
#
#  This perl script was originally written by Takenori Yamamoto.
#  The script was modified by Masakuni Okamoto.
#
#  Last update: March 1, 2004.
#
################################################################################
#//////////////////////////////// Wave functions ///////////////////////////////

$rmax_phi  = 10;  $gmax_phi  = 10;
$rmin_phi  =  0;  $gmin_phi  =  0;
$rmax_phi  = $ARGV[1];

$rmax_beta =  5;  $gmax_beta = 20;
$rmin_beta =  0;  $gmin_beta =  0;

$rphi_max_plot =  3;  $gphi_max_plot =  3;
$rphi_min_plot = -2;  $gphi_min_plot = -2;

@lang = ('s','p','d','f');
@ntic = (0.01,0.02,0.05,0.1,0.2,0.5,1,2,5,10,20,50,100,200,500,
         1000,2000,5000,10000,20000,50000,100000,200000,500000,
         1000000,2000000,5000000);
$rphi_max  = -1.0e3;
$rphi_min  = +1.0e3;
$gphi_max  = -1.0e3;
$gphi_min  = +1.0e3;
$rbeta_max = -1.0e3;
$rbeta_min = +1.0e3;
$gbeta_max = -1.0e3;
$gbeta_min = +1.0e3;

################################################################################
#  Read data from a command-line

if(@ARGV<2) {
  print "Usage: print_eps_us FileTitle RmaxPhi [--formatted]\n";
  exit(0);
} else {
  $is_formatted = 0;
  foreach $s (@ARGV) {
    if($s =~/--formatted/ || $s =~/-f/) {
      $is_formatted = 1;
    }
  }
}

################################################################################
#  Read data from a file

print "*** Wavefunctions ***\n";
print "@ARGV\n";
$infile = "$ARGV[0]" . ".us";
print "<IN> = $infile\n";
if(! -e "$infile") {
  print "#############################################################\n";
  print "##   File not exists  -->  $infile\n";
  print "##   Please prepare the missing file.\n";
  print "#############################################################\n";
  exit(1);
} else {
  print "File exists --> $infile\n";
}
open(IN,"<$infile");
while($line = <IN>) {
  if($line =~/Element/) {
    ($element) = split(' ',$line);
    print "$element\n";
  } elsif($line =~/ng_mesh/) {
    @line=split(' ',$line);
    $nmesh = $line[0];
    $gmesh = $line[1];
    print "nmesh   : $nmesh\n";
    print "ng_mesh : $gmesh\n";
    last;
  }
}
$mr = 0;
$mg = 0;
while($line = <IN>) {
  if($line =~/ln,tn/) {
    @line=split(' ',$line);
    $l=$line[2];
    $t=$line[3];
    print "$lang[$l]($t)\n";
  } elsif($line =~/pp_type/) {
    @line=split(' ',$line);
    $pp_type = $line[2];
    print "   PP_type : $pp_type\n";
  } elsif($line =~/eref/) {
    @line=split(' ',$line);
    $ee = $line[2];
    print "   Eref    : $ee\n";
  } elsif($line =~/rcut/) {
    @line=split(' ',$line);
    $rr = $line[2];
    print "   Rc      : $rr\n";
  } elsif($line =~/rpos/) {
    print "   Real-space\n";
    $rfile[$mr] = "usr" . "_$element" . "_$l" . "_$t" . ".dat";
    $ll[$mr] = $l;
    $tt[$mr] = $t;
    $type[$mr] = $pp_type;
    $eref[$mr] = $ee;
    $rcut[$mr] = $rr;
    $have_zero[$mr] = 0;
    $r0[$mr]      = -1.0e3;
    $r1[$mr]      = -1.0e3;
    $ifound0[$mr] = 0;
    $ifound1[$mr] = 0;
    $rpsi0[$mr]   = 0;
    $rpsi1[$mr]   = 0;
    open(OUT,">$rfile[$mr]");
    $ic = 0;
    for($i=0;$i<$nmesh-1;$i++) {
      ($rpos,$rpsi,$rphi,$rchi,$rbeta) = split(' ',<IN>);
      if($rpsi > $rphi_max) {$rphi_max = $rpsi;}
      if($rpsi < $rphi_min) {$rphi_min = $rpsi;}
      if($rphi > $rphi_max) {$rphi_max = $rphi;}
      if($rphi < $rphi_min) {$rphi_min = $rphi;}
      if($rbeta > $rbeta_max) {$rbeta_max = $rbeta;}
      if($rbeta < $rbeta_min) {$rbeta_min = $rbeta;}
      if($rpos < $rcut[$mr] && $ifound0[$mr] == 0) 
        {$r0[$mr] = $rpos; $rpsi0[$mr] = $rpsi;} else {$ifound0[$mr] = 1;}
      if($ifound0[$mr] == 1 && $ifound1[$mr] == 0) 
        {$r1[$mr] = $rpos; $rpsi1[$mr] = $rpsi; $ifound1[$mr] = 1;}
      if((abs($rpsi) < 1.0e-10 && $rpos > 0.1 && $rpos < 8) || ($rpos > 8 && $ic > 10)) {
        $rpsi = 'zero';}
      if((abs($rphi) < 1.0e-10 && $rpos > 0.1 && $rpos < 8) || ($rpos > 8 && $ic > 10)) {
        $rphi = 'zero'; $have_zero[$mr] = 1; $ic++;}
      print OUT "$rpos $rpsi $rphi $rchi $rbeta\n";
    }
    $mr++;
    close(OUT);
  } elsif($line =~/gpos/) {
    print "   Reciprocal-space\n";
    $gfile[$mg] = "usg" . "_$element" . "_$l" . "_$t" . ".dat";
    open(OUT,">$gfile[$mg]");
    for($i=0;$i<$gmesh-1;$i++) {
      ($gpos,$gpsi,$gphi,$gchi,$gbeta) = split(' ',<IN>);
      if($gphi > $gphi_max) {$gphi_max = $gphi;}
      if($gphi < $gphi_min) {$gphi_min = $gphi;}
      if($gbeta > $gbeta_max) {$gbeta_max = $gbeta;}
      if($gbeta < $gbeta_min) {$gbeta_min = $gbeta;}
      print OUT "$gpos $gpsi $gphi $gchi $gbeta\n";
    }
    $mg++;
    close(OUT);
  }
}
close(IN);
for($i=0;$i<$mg;$i++) {print "$i, $have_zero[$i]\n";}

################################################################################
#  gnuplot

### Parameters
$ndiv_max = 5;

##### r*phi(r) #####
open(OUT,">$$.gpi");
$rphi_file = "$ARGV[0]" . "_us" . "_rphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rphi_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
print OUT "set key right top\n";
#print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($rphi_max > $rphi_max_plot) {$rphi_max = $rphi_max_plot;}
if($rphi_min < $rphi_min_plot) {$rphi_min = $rphi_min_plot;}
for($i=0;int(($rphi_max-$rphi_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$rphi_max_guess = int($rphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rphi_min_guess = int($rphi_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} else {
print OUT "set format y \"%2.0f\"\n";
}
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol y}_{/Times-Italic n}(r)\"\n";
print OUT "set label \"$element\" center at graph 0.11,0.86 font \"Helvetica-Bold,36\"\n";

for($i=0;$i<$mr;$i++) {
  print OUT "set arrow from $r0[$i],$rpsi0[$i]-0.3 to $r0[$i],$rpsi0[$i]-0.03 lt $ll[$i]+1 lw 1\n";
}

print OUT "plot [$rmin_phi:$rmax_phi][$rphi_min_guess:$rphi_max_guess] \\\n";
$ic = 0;
for($i=0;$i<$mr;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\"$rfile[$i]\" u 1:2 notitle                     w l lt $line_type lw 1, \\\n";
  print OUT "\"$rfile[$i]\" u 1:3 t \"$lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### r*beta(r) #####
open(OUT,">$$.gpi");
$rbeta_file = "$ARGV[0]" . "_us" . "_rbeta" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$rbeta_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 1\n";
for($i=0;int(($rbeta_max-$rbeta_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$rbeta_max_guess = int($rbeta_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$rbeta_min_guess = int($rbeta_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"r\"\n";
print OUT "set ylabel \"r{/Symbol c}_{/Times-Italic n}(r), r{/Symbol b}_{/Times-Italic n}(r)\"\n";

$ic = 0;
for($i=0;$i<$mr;$i++) {
  if($is_formatted == 1) {
    print OUT "set label \"Rc($lang[$ll[$i]]$tt[$i])=%8.5f\",$rcut[$i] \\\n";
  } else {
    $tmp = int($rcut[$i]*1.0e5)*1.0e-5;
    print OUT "set label \"Rc($lang[$ll[$i]]$tt[$i])=$tmp\" \\\n";
  }
  print OUT "at graph 0.68,0.9-$ic*0.05 font \"Courier,9\"\n";
  $ic++;
}

print OUT "plot [$rmin_beta:$rmax_beta][$rbeta_min_guess:$rbeta_max_guess] \\\n";
$ic = 0;
for($i=0;$i<$mr;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\"$rfile[$i]\" u 1:4 t \"{/Symbol c}: $lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 1, \\\n";
  print OUT "\"$rfile[$i]\" u 1:5 t \"{/Symbol c}: $lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### g*phi(g) #####
open(OUT,">$$.gpi");
$gphi_file = "$ARGV[0]" . "_us" . "_gphi" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$gphi_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 1\n";
print OUT "set mxtics 1\n";
if($gphi_max > $gphi_max_plot) {$gphi_max = $gphi_max_plot;}
if($gphi_min < $gphi_min_plot) {$gphi_min = $gphi_min_plot;}
for($i=0;int(($gphi_max-$gphi_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$gphi_max_guess = int($gphi_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$gphi_min_guess = int($gphi_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
#print OUT "set format y \"%2.0f\"\n";
if($ytics_guess < 0.1) {
print OUT "set format y \"%4.2f\"\n";
} elsif($ytics_guess < 1) {
print OUT "set format y \"%3.1f\"\n";
} else {
print OUT "set format y \"%2.0f\"\n";
}
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q{/Symbol y}_{/Times-Italic n}(q)\"\n";

print OUT "plot [$gmin_phi:$gmax_phi][$gphi_min_guess:$gphi_max_guess] \\\n";
$ic = 0;
for($i=0;$i<$mg;$i++) {
  if($have_zero[$i] == 1) {next;}
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\"$gfile[$i]\" u 1:2 notitle                     w l lt $line_type lw 1, \\\n";
  print OUT "\"$gfile[$i]\" u 1:3 t \"$lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

##### g*beta(g) #####
open(OUT,">$$.gpi");
$gbeta_file = "$ARGV[0]" . "_us" . "_gbeta" . ".eps";
print OUT "set terminal postscript eps enhanced color solid \"Helvetica\" 12\n";
print OUT "set output \"$gbeta_file\"\n";
print OUT "set xzeroaxis\n";
print OUT "set border 31 lw 1\n";
print OUT "set missing \"zero\"\n";

print OUT "set size 0.5,0.5\n";
#print OUT "set key right top\n";
print OUT "set nokey\n";
print OUT "set xtics 5\n";
print OUT "set mxtics 5\n";
for($i=0;int(($gbeta_max-$gbeta_min)/$ntic[$i]) > $ndiv_max;$i++) {next;}
$ytics_guess = $ntic[$i];
$gbeta_max_guess = int($gbeta_max/$ntic[$i])*$ntic[$i]+$ntic[$i];
$gbeta_min_guess = int($gbeta_min/$ntic[$i])*$ntic[$i]-$ntic[$i];
print OUT "set ytics $ytics_guess\n";
print OUT "set mytics 1\n";
print OUT "set format x \"%1.0f\"\n";
print OUT "set format y \"%2.0f\"\n";
print OUT "set xlabel \"q\"\n";
print OUT "set ylabel \"q{/Symbol c}_{/Times-Italic n}(q), q{/Symbol b}_{/Times-Italic n}(q)\"\n";
print OUT "plot [$gmin_beta:$gmax_beta][$gbeta_min_guess:$gbeta_max_guess] \\\n";
$ic = 0;
for($i=0;$i<$mg;$i++) {
  if($ic != 0) {print OUT ", \\\n";}
  $line_type = $ll[$i]+1;
  print OUT "\"$gfile[$i]\" u 1:4 t \"{/Symbol c}: $lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 1, \\\n";
  print OUT "\"$gfile[$i]\" u 1:5 t \"{/Symbol b}: $lang[$ll[$i]]$tt[$i]\" w l lt $line_type lw 4";
  $ic++;
}
print OUT "\n";
close(OUT);

`gnuplot $$.gpi`;
`rm $$.gpi`;

for($i=0;$i<$mr;$i++) {`rm $rfile[$i]`;}
for($i=0;$i<$mg;$i++) {`rm $gfile[$i]`;}
