! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

program accel
  use ac_parameter
  use ac_mpi_module
  implicit none
  character(64) :: argv 

  call MPI__Initialize

  call gen_outf_accel
  open(unit=16,file=Param%Option%file_ac_tempout,position='append')
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-: Welcome to ACCEL ver. 4.5  :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  close(16)

  MPI%sizeM = MPI%size2
  MPI%sizeE = 1
  MPI%sizeA = MPI%sizeM

  if( MPI%root ) then
     if( command_argument_count() == 0 ) then
        call MPI__Finalize
        open(unit=16,file=Param%Option%file_ac_tempout,position='append')
        write(16,'(a)') "# usage"
        write(16,'(a)') "# mpirun -np <number> accel <input file>"
        close(16)
        stop
     end if

     call get_command_argument(1,argv)
  end if
  call MPI__Bcast_Inputfile( argv )

  call ac_main(argv)

  call MPI__Finalize

contains

  function command_argument_count() result(argc)
    implicit none
    integer :: argc, iargc

    argc = iargc()
    if( argc < 0 ) then
       open(unit=16,file=Param%Option%file_ac_tempout,position='append')
       write(16,'(a)') "# Error : iargc function is not working."
       close(16)
       stop
    end if
    return
  end function command_argument_count

  subroutine get_command_argument(index,argv)
    implicit none
    integer, intent(in) :: index
    character(len=*), intent(out) :: argv

    call getarg(index,argv)

    return
  end subroutine get_command_argument

end program accel

subroutine gen_outf_accel
  use ac_parameter
  use ac_mpi_module

  implicit none
  integer :: i2,i_temp1,i_temp2
  character(1) :: character_temp(4),a(10)

  a(1)='0'
  a(2)='1'
  a(3)='2'
  a(4)='3'
  a(5)='4'
  a(6)='5'
  a(7)='6'
  a(8)='7'
  a(9)='8'
  a(10)='9'

  i_temp1=MPI%rank2+1
  do i2=1,4
     i_temp2=i_temp1/(10**(4-i2))
     character_temp(i2)=a(i_temp2+1)
     i_temp1=i_temp1-(10**(4-i2))*i_temp2
  end do
  Param%Option%file_ac_tempout='g.output'//'_'//character_temp(1)//character_temp(2)     &
       //character_temp(3)//character_temp(4)

  return
end subroutine gen_outf_accel
