! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_parameter(file_name)

  use condition_ini
  use gsp_parameter
  use rtbh_parameter
  use mod_mpi

  use ac_mpi_module

  implicit none

  character(50), intent(in) :: file_name
  real(8) :: st1,st2,stdel
  integer p
  integer, allocatable :: rankM(:), rankE(:)

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,999) file_name
  write(16,*)
999 format(' +++++++++++ start: read file:: ',a30)
  call myclock(st1)
  close(16)

  call read_input_condition_ini(file_name)
  if( ham_model_ini .eq. 'gsp' ) then
     call read_gsp_parameter
     call read_input_tb_cordinate
     call alo_pair_ini
     call set_pair_ini(atom_parameter)
  end if
  if( ham_model_ini .eq. 'rtb_h' ) then
     call read_rtbh_parameter
     call read_input_tb_cordinate
  end if
  if( ham_model_ini .eq. 'input' ) then
     MPI%rankE = int(MPI%rank2/MPI%sizeM)
     MPI%rankM = mod(MPI%rank2,MPI%sizeM)
     allocate( rankM(0:MPI%sizeM-1), rankE(0:MPI%sizeE-1) )
     do p=0, MPI%sizeM-1
        rankM(p) = p + MPI%rankE*MPI%sizeM
     end do
     do p=0, MPI%sizeE-1
        rankE(p) = p*MPI%sizeM + MPI%rankM
     end do
     call BLACS_GET( 0, 0, MPI%SL_ID )
     call BLACS_GRIDMAP( MPI%SL_ID, rankM, 1, 1, MPI%sizeM )
     call MPI_Group_incl( MPI%group2, MPI%sizeM, rankM, MPI%groupM, MPI%info )
     call MPI_Comm_create( MPI_COMM_WORLD, MPI%groupM, MPI%commM, MPI%info )
     call MPI_Group_incl( MPI%group2, MPI%sizeE, rankE, MPI%groupE, MPI%info )
     call MPI_Comm_create( MPI_COMM_WORLD, MPI%groupE, MPI%commE, MPI%info )
     deallocate(rankM,rankE)

     call set_hamiltonian_temp(file_parameter1,file_parameter2,file_parameter3)
     call set_ksampling_tr
  end if
  if( ham_model_ini .eq. 'scf_accel' ) then
     call set_scf_accel
     call set_ksampling_tr
  end if

  open(unit=16,file=file_tempout,position='append')
  call myclock(st2)
  stdel=st2-st1
  write(16,*) '++++++++++++  end : read file'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '                t=',stdel
  close(16)

  return
end subroutine set_parameter
