! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_chemical_potential(i_rl)

  use condition_ini
  use condition
  use hamiltonian_zper
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use eigen_values
  use gf_se_c
  use ac_mpi_module
  use mod_mpi

  implicit none
  integer, intent(in) :: i_rl

  integer :: kx,ky,kz,mat_max,ispin
  integer :: mul
  real(8) :: st1,st2,stdel

  integer :: i1_do,i2_do,i3_do,i4_do,i5_do,i_temp,ier
  real(8), allocatable :: tr_temp1(:,:,:),tr_temp2(:,:,:,:,:,:)

  character(50) :: switch_eigen

  integer :: kt
  real(8) :: qx_tr,qy_tr
  type(MPI_MatDesc) :: descZZ
  type(MPI_MatDesc) :: descCC, descLL, descRR
  integer :: i, j


  call MPI__setupMatDesc( descZZ, mat_max_eigen, mat_max_eigen )
  call MPI__setupMatDesc( descCC, m_mat_max_c,m_mat_max_c )
  call MPI__setupMatDesc( descLL, mat_max_ll, mat_max_ll )
  call MPI__setupMatDesc( descRR, mat_max_rr, mat_max_rr )


  if( i_rl == 1 ) then
     switch_eigen=switch_l_eigen
  else
     switch_eigen=switch_r_eigen
  end if

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  if( i_rl == 1 ) then
     write(16,*) '++++++++++++ chemical_potential: left'
  else
     write(16,*) '++++++++++++ chemical_potential: right'
  end if
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  close(16)

  call myclock(st1)

  call alo_hamiltonian_zper(descZZ)

  mat_max=mat_max_zper
  mat_ev_max=2*mat_max


  do kt=1,ka_tr*kb_tr
     if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
        qx_tr=po_kt_tr(2,kt)
        qy_tr=po_kt_tr(3,kt)
     end if

     do ispin=1,spin_switch_temp

        do kx=1,kx_max
           do ky=1,ky_max
              if( p_or_f == 'periodic' ) then
                 open(unit=16,file=file_tempout,position='append')
                 write(16,*) 'cal_eigen',kx_max,ky_max,kx,ky
                 close(16)
              end if
              if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
                 call alo_ham_temp_ham(descCC,descLL,descRR)
                 if( lr_switch == -1 ) then
                    call set_ham_temp_ham_l(descLL,qx_tr,qy_tr)
                 end if
                 if( lr_switch == 1 ) then
                    call set_ham_temp_ham_r(descRR,qx_tr,qy_tr)
                 end if
              end if
              do kz=1+MPI%rankE,kz_max/2+1,MPI%sizeE
                 if( p_or_f == 'free' ) then
                    open(unit=16,file=file_tempout,position='append')
                    write(16,*) 'cal_eigen',kz_max,kz
                    close(16)
                 end if
                 open(unit=16,file=file_tempout,position='append')
                 call set_hamiltonian_zper(descZZ,kx,ky,kz,ispin)
                 if( switch_eigen == 'on' ) then
                    if( eigen_s_as == 'symmetry' ) then
                       call cal_eigen(descZZ,kx,ky,kz,ispin,kt)
                    else
                       if( eigen_s_as == 'general' ) then
                          call cal_eigen_as(descZZ,kx,ky,kz,ispin,kt)
                       else
                          write(6,*) 'error: method_eigen;; set_chemical_potential'
                          stop
                       end if
                    end if
                 end if
                 if( dos_on_off == 'on' ) then
                    if( kz == 1 .or. kz == (kz_max/2+1) ) then
                       mul=1
                    else
                       mul=2
                    end if
                    call gf_bulk(descZZ,mul,ispin,kt)
                 end if
                 close(16)
              end do
              if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
                 call dealo_ham_temp_ham
              end if
           end do
        end do
     end do
  end do


  allocate(tr_temp1(omega_par_num(num_gra_te),spin_switch_temp,ka_tr*kb_tr)  &
       ,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if
  tr_temp1(:,:,:)=0.d0

  i_temp = omega_par_num(num_gra_te)*spin_switch_temp*ka_tr*kb_tr


  call MPI_Allreduce( dos, tr_temp1, i_temp, &
       MPI_DOUBLE_PRECISION, MPI_SUM, MPI%commE, MPI%info )

  dos(:,:,:) = tr_temp1(:,:,:)

  deallocate(tr_temp1,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if

  allocate(tr_temp2(mat_max_eigen,kz_max,ky_max,kx_max,spin_switch_temp      &
       ,ka_tr*kb_tr),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if

  tr_temp2(:,:,:,:,:,:) = 0.0d0

  i_temp = mat_max_eigen*kz_max*ky_max*kx_max*spin_switch_temp*ka_tr*kb_tr
  call MPI_Allreduce( ev_mat, tr_temp2, i_temp, &
       MPI_DOUBLE_PRECISION, MPI_SUM, MPI%commE, MPI%info )

  ev_mat(:,:,:,:,:,:) = tr_temp2(:,:,:,:,:,:)

  deallocate(tr_temp2,stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if




  call cal_chemical_potential(ka_tr*kb_tr)


  call unset_hamiltonian_zper

  call MPI__unsetMatDesc( descZZ )
  call MPI__unsetMatDesc( descCC )
  call MPI__unsetMatDesc( descLL )
  call MPI__unsetMatDesc( descRR )


  open(unit=16,file=file_tempout,position='append')
  call myclock(st2)
  stdel=st2-st1
  write(16,*) '           t=',stdel
  close(16)

  return
end subroutine set_chemical_potential
subroutine cal_eigen(descZZ,kx,ky,kz,ispin,kt)

  use condition
  use hamiltonian_zper
  use eigen_values
  use ac_mpi_module

  implicit none

  type(MPI_MatDesc), intent(in) :: descZZ
  integer, intent(in) :: kx,ky,kz,ispin,kt
  integer :: i1_do,i2_do,i3_do,i4_do,i_count,l_con,mat_max,ier
  real(8) :: norm_temp
  complex(8) :: temp,temp1
  complex(8), allocatable :: temp_matA(:,:)
  complex(8), allocatable :: temp_mat0(:,:), temp_mat1(:,:),temp_mat2(:,:)

  integer :: i, j


  mat_max=mat_max_zper

  call alo_eigen_values_1

  allocate(temp_matA(mat_max, mat_max) ,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: cal_eigen_as'
     stop
  end if

  temp_matA(:,:) = 0.0d0
  do j=descZZ%scol, descZZ%ecol
     do i=1, descZZ%nrow
        temp_matA(i,j) = s00_mat(i,j) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descZZ, temp_matA )

  do i2_do=1,mat_max
     do i1_do=1,mat_max
        a(2*i1_do-1,2*i2_do-1) =  dreal(temp_matA(i1_do,i2_do))
        a(2*i1_do-1,2*i2_do-0) = -dimag(temp_matA(i1_do,i2_do))
        a(2*i1_do-0,2*i2_do-1) =  dimag(temp_matA(i1_do,i2_do))
        a(2*i1_do-0,2*i2_do-0) =  dreal(temp_matA(i1_do,i2_do))
     end do
  end do

  l_con=1
  call ep1(a,d,mat_ev_max,l_con)
  do i1_do=1,mat_ev_max
     i_num(i1_do)=i1_do
  end do

  do i1_do=1,mat_ev_max
     do i2_do=i1_do+1,mat_ev_max
        if( d(i_num(i1_do)) > d(i_num(i2_do)) ) then
           i3_do=i_num(i1_do)
           i_num(i1_do)=i_num(i2_do)
           i_num(i2_do)=i3_do
        end if
     end do
  end do

  call alo_eigen_values_2

  do i1_do=1,mat_ev_max
     e_temp(i1_do)=d(i_num(i1_do))
     do i2_do=1,mat_max
        ev_vec_temp(i2_do,i1_do)                                                 &
             =dcmplx(a(2*i2_do-1,i_num(i1_do)),a(2*i2_do,i_num(i1_do)))
     end do
  end do

  call unset_eigen_values_1
  call alo_eigen_values_3

  do i1_do=1,mat_max
     s_ev(i1_do)=e_temp(2*i1_do)
     do i2_do=1,mat_max
        ev_vec(i2_do,i1_do)=ev_vec_temp(i2_do,2*i1_do)
     end do
  end do


  i_count=0
10 continue
  do i1_do=1,mat_max
     do i2_do=1,mat_max
        temp = sum( dconjg(ev_vec(:,i1_do))*ev_vec(:,i1_do) )

        if( i1_do == i2_do ) then
        else
           if( cdabs(temp) > 1.d-10 ) then
              temp1=temp

              ev_vec(:,i2_do) = ev_vec(:,i2_do) - temp1*ev_vec(:,i1_do)
              norm_temp = sum( dconjg(ev_vec(:,i2_do))*ev_vec(:,i2_do) )
              temp = sum( dconjg(ev_vec(:,i1_do))*ev_vec(:,i2_do) )

              if( norm_temp < 1.d-15 ) then
                 i_count=i_count+1

                 ev_vec(:,i2_do)=ev_vec_temp(:,2*i2_do-1)

                 if( i_count > mat_max*2 ) then
                    write(6,*) 'error - eigen_vector',i_count,norm_temp
                    stop
                 end if
                 go to 10
              else
                 ev_vec(:,i2_do) = ev_vec(:,i2_do)/dsqrt(norm_temp)
              end if
           end if
        end if
     end do
  end do

  call unset_eigen_values_2


  call alo_eigen_values_1

  allocate(temp_mat0(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier)
  allocate(temp_mat1(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier)
  allocate(temp_mat2(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: cal_eigen'
     stop
  end if

  s_ev(:)=1.d0/dsqrt(s_ev(:))

  do j=descZZ%scol,descZZ%ecol
     do i=1,descZZ%nrow
        temp_mat0(i,j) = ev_vec(i,j) 
     end do
  end do

  call MPI__ZGEMM_ASCOT( 'N', 'N', descZZ, &
       C1, h00_mat, temp_mat0, C0, temp_mat2 ) 


  call MPI__ZGEMM_ASCOT( 'C', 'N', descZZ, &
       C1, temp_mat0, temp_mat2, C0, temp_mat1 ) 



  temp_matA(:,:) = 0.0d0
  do j=descZZ%scol, descZZ%ecol
     do i=1, descZZ%nrow
        temp_matA(i,j) = s_ev(i)*temp_mat1(i,j)*s_ev(j) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descZZ, temp_matA )

  do i2_do=1,mat_max
     do i1_do=1,mat_max
        a(2*i1_do-1,2*i2_do-1) =  dreal(temp_matA(i1_do,i2_do)) 
        a(2*i1_do-1,2*i2_do-0) = -dimag(temp_matA(i1_do,i2_do)) 
        a(2*i1_do-0,2*i2_do-1) =  dimag(temp_matA(i1_do,i2_do)) 
        a(2*i1_do-0,2*i2_do-0) =  dreal(temp_matA(i1_do,i2_do)) 
     end do
  end do

  deallocate(temp_matA,temp_mat0,temp_mat1,temp_mat2,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: cal_eigen'
     stop
  end if

  call unset_eigen_values_3

  l_con=0
  call ep1(a,d,mat_ev_max,l_con)

  do i1_do=1,mat_ev_max
     i_num(i1_do)=i1_do
  end do

  do i1_do=1,mat_ev_max
     do i2_do=i1_do+1,mat_ev_max
        if( d(i_num(i1_do)) > d(i_num(i2_do)) ) then
           i3_do=i_num(i1_do)
           i_num(i1_do)=i_num(i2_do)
           i_num(i2_do)=i3_do
        end if
     end do
  end do

  do i1_do=1,mat_max
     ev_mat(i1_do,kz,ky,kx,ispin,kt)=d(i_num(2*i1_do))
  end do

  call unset_eigen_values_1

  return
end subroutine cal_eigen
subroutine cal_eigen_as(descZZ,kx,ky,kz,ispin,kt)

  use condition
  use hamiltonian_zper
  use eigen_values
  use ac_mpi_module

  implicit none

  type(MPI_MatDesc), intent(in) :: descZZ
  integer, intent(in) :: kx,ky,kz,ispin,kt
  integer :: i1_do,i2_do,i3_do,mat_max,ier,ier_ev
  complex(8), allocatable :: temp_matA(:,:)
  complex(8), allocatable :: temp_mat1(:,:), temp_mat2(:,:), temp_mat3(:,:)
  integer :: i, j


  mat_max=mat_max_zper

  allocate(temp_mat1(descZZ%nrow, descZZ%scol:descZZ%ecol) ,stat=ier)
  allocate(temp_mat2(descZZ%nrow, descZZ%scol:descZZ%ecol) ,stat=ier)
  allocate(temp_mat3(descZZ%nrow, descZZ%scol:descZZ%ecol) ,stat=ier)
  allocate(temp_matA(mat_max, mat_max) ,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: cal_eigen_as'
     stop
  end if

  temp_mat1(:,:) = s00_mat(:,:) 
  temp_mat3(:,:) = h00_mat(:,:) 

  call MPI__ZGETRI_ASCOT( descZZ, temp_mat1 )

  call MPI__ZGEMM_ASCOT( 'N', 'N', descZZ, &
       C1, temp_mat1, temp_mat3, C0, temp_mat2 )

  temp_matA(:,:) = 0.0d0
  do j=descZZ%scol, descZZ%ecol
     do i=1, descZZ%nrow
        temp_matA(i,j) = temp_mat2(i,j)
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descZZ, temp_matA )

  call alo_eigen_values_as

  do i2_do=1,mat_max
     do i1_do=1,mat_max
        a_as(2*i1_do-1,2*i2_do-1) =  dreal(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-1,2*i2_do-0) = -dimag(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-0,2*i2_do-1) =  dimag(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-0,2*i2_do-0) =  dreal(temp_matA(i1_do,i2_do))
     end do
  end do

  call ep_as1(a_as,d_as,mat_ev_max,ier_ev)

  if( ier_ev == 0) then
     do i1_do=1,mat_ev_max
        if( dabs(dimag(d_as(i1_do))) > 1.d-10 ) then
           write(16,*) 'error: eigen_as (imaginaly part)',d_as(i1_do)
           ier_ev=1
        end if
     end do
  end if

  if( ier_ev == 0 ) then
     go to 10
  end if


  call MPI__ZGEMM_ASCOT( 'N', 'N', descZZ, &
       C1, temp_mat3, temp_mat1, C0, temp_mat2 )

  temp_matA(:,:) = 0.0d0
  do j=descZZ%scol, descZZ%ecol
     do i=1, descZZ%nrow
        temp_matA(i,j) = temp_mat2(i,j)
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descZZ, temp_matA )

  call alo_eigen_values_as

  do i2_do=1,mat_max
     do i1_do=1,mat_max
        a_as(2*i1_do-1,2*i2_do-1) =  dreal(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-1,2*i2_do-0) = -dimag(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-0,2*i2_do-1) =  dimag(temp_matA(i1_do,i2_do))
        a_as(2*i1_do-0,2*i2_do-0) =  dreal(temp_matA(i1_do,i2_do))
     end do
  end do

  call ep_as1(a_as,d_as,mat_ev_max,ier_ev)

  if( ier_ev == 0) then
     do i1_do=1,mat_ev_max
        if( dabs(dimag(d_as(i1_do))) > 1.d-10 ) then
           write(16,*) 'error: eigen_as (imaginaly part)',d_as(i1_do)
           ier_ev=1
        end if
     end do
  end if

  if( ier_ev /= 0 ) then
     write(16,*) 'error: eigen_as '
     call unset_eigen_values_as
     call cal_eigen(descZZ,kx,ky,kz,ispin,kt)

     deallocate(temp_mat1,temp_mat2,temp_mat3,temp_matA,stat=ier)
     if( ier /= 0 ) then
        write(6,*) 'error deallocate: cal_eigen_as'
        stop
     end if

     return
  end if


10 continue

  do i1_do=1,mat_ev_max
     i_num(i1_do)=i1_do
  end do
  do i1_do=1,mat_ev_max
     do i2_do=i1_do+1,mat_ev_max
        if( dreal(d_as(i_num(i1_do))) > dreal(d_as(i_num(i2_do))) ) then
           i3_do=i_num(i1_do)
           i_num(i1_do)=i_num(i2_do)
           i_num(i2_do)=i3_do
        end if
     end do
  end do

  do i1_do=1,mat_max
     ev_mat(i1_do,kz,ky,kx,ispin,kt)=dreal(d_as(i_num(2*i1_do)))
  end do

  call unset_eigen_values_as

  deallocate(temp_mat1,temp_mat2,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: cal_eigen_as'
     stop
  end if

  return
end subroutine cal_eigen_as
subroutine cal_chemical_potential(kt_num)

  use condition
  use hamiltonian_zper
  use eigen_values
  use ac_mpi_module

  implicit none
  integer, intent(in) :: kt_num

  integer :: num_total_ele
  integer :: i1_do,i2_do,kx,ky,kz,iter,mat_max,ier,ispin,kt
  real(8) :: temp_t
  real(8), allocatable :: temp(:)


  mat_max=mat_max_zper

  do kz=2,kz_max/2
     ev_mat(:,kz_max-kz+2,:,:,:,:) = ev_mat(:,kz,:,:,:,:)
  end do


  allocate(temp(kx_max*ky_max*kz_max*mat_max*kt_num*2),stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: cal_chemical_potential'
     stop
  end if

  iter=0
  do kt=1,kt_num
     do kx=1,kx_max
        do ky=1,ky_max
           do kz=1,kz_max
              do i1_do=1,mat_max
                 if( spin_switch_temp == 1 ) then
                    iter=iter+1
                    temp(iter)=ev_mat(i1_do,kz,ky,kx,1,kt)
                    iter=iter+1
                    temp(iter)=ev_mat(i1_do,kz,ky,kx,1,kt)
                 else
                    iter=iter+1
                    temp(iter)=ev_mat(i1_do,kz,ky,kx,1,kt)
                    iter=iter+1
                    temp(iter)=ev_mat(i1_do,kz,ky,kx,2,kt)
                 end if
              end do
           end do
        end do
     end do
  end do

  do i1_do=1,kx_max*ky_max*kz_max*mat_max*kt_num*2
     do i2_do=i1_do+1,kx_max*ky_max*kz_max*mat_max*kt_num*2
        if( temp(i1_do) > temp(i2_do) ) then
           temp_t=temp(i1_do)
           temp(i1_do)=temp(i2_do)
           temp(i2_do)=temp_t
        end if
     end do
  end do


  if( ham_model == 'input' .or. ham_model == 'scf_accel' ) then
     num_total_ele=ele_num_temp
  else
     num_total_ele=0.d0
     do i1_do=1,num_atom
        num_total_ele=num_total_ele+atom_electron(atom_kindn(i1_do))
     end do
  end if
  num_total_ele=num_total_ele*kx_max*ky_max*kz_max*kt_num

  if( num_total_ele < kx_max*ky_max*kz_max*mat_max*kt_num*2 ) then
     cp=(temp(num_total_ele)+temp(num_total_ele+1))*.5d0
  else
     cp=temp(kx_max*ky_max*kz_max*mat_max*kt_num*2)
  end if


  deallocate(temp,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: cal_chemical_potential'
     stop
  end if

  return
end subroutine cal_chemical_potential
subroutine gf_bulk(descZZ,mul,ispin,kt)

  use condition
  use hamiltonian_zper
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descZZ
  integer , intent(in) :: mul,ispin,kt
  integer :: i1_do,i2_do,j1_do,j2_do,ier,mat_max
  complex(8) :: w
  complex(8), allocatable :: b_mat(:,:)
  complex(8) :: trace

  integer :: i, j


  mat_max=mat_max_zper

  allocate(b_mat(descZZ%nrow, descZZ%scol:descZZ%ecol),stat=ier)

  if( ier /= 0 ) then
     write(6,*) 'error allocate: gf_bulk'
     stop
  end if

  do j1_do=1,omega_par_num(num_gra_te)
     w=omega(omega_par(num_gra_te)+j1_do)

     b_mat(:,:) = w*s00_mat(:,:) - h00_mat(:,:) 

     call MPI__ZGETRI_ASCOT( descZZ, b_mat )
     call MPI__ZLATRA_ASCOT( descZZ, b_mat, trace )

     dos(j1_do,ispin,kt) = dos(j1_do,ispin,kt) - dimag(trace)*dble(mul)
  end do

  deallocate(b_mat,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: gf_bulk'
     stop
  end if

  return
end subroutine gf_bulk
