! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine make_scf_omega_c1(i_bios_minomega,cp_l,cp_r)

  use scf_negf
  use constant
  use mod_mpi

  implicit none
  integer, intent(in) :: i_bios_minomega
  real(8), intent(in) :: cp_l,cp_r

  integer :: i1_do,i2_do,i_w_num
  real(8) :: temp,th1,th2,temp_om,temp_del
  complex(8) :: w_int

  pai=datan(1.d0)*4.d0


  i_total_omega=0
  do i1_do=1,om_block_num_scf
     do i2_do=1,3
        i_total_omega=i_total_omega+num_om_par_scf(i1_do,i2_do)
     end do
     i_total_omega=i_total_omega
  end do

  if( scf_bias == 'on' ) then
     i_total_omega=i_total_omega+num_om_bias
  end if

  call alo_scf_negf_omega2

  temp=.5d0/pai

  i_w_num=0
  do i1_do=1,om_block_num_scf
     if( num_om_par_scf(i1_do,1) /= 0 ) then
        i_w_num=i_w_num+1
        w_int=dcmplx(0.d0,omega_if_scf(i1_do,4)-omega_if_scf(i1_do,3))           &
             /dfloat(num_om_par_scf(i1_do,1))
        omega_scf(i_w_num)=dcmplx(omega_if_scf(i1_do,1)                          &
             ,omega_if_scf(i1_do,3))+w_int*.5d0
        omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
        i_bios_omega_scf(i_w_num)=1
        do i2_do=1,num_om_par_scf(i1_do,1)-1
           i_w_num=i_w_num+1
           omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
           omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
           i_bios_omega_scf(i_w_num)=1
        end do
     end if

     w_int=dcmplx(omega_if_scf(i1_do,2)-omega_if_scf(i1_do,1),0.d0)             &
          /dfloat(num_om_par_scf(i1_do,2))
     i_w_num=i_w_num+1
     omega_scf(i_w_num)=dcmplx(omega_if_scf(i1_do,1)                            &
          ,omega_if_scf(i1_do,4))+w_int*.5d0
     omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
     i_bios_omega_scf(i_w_num)=1
     do i2_do=1,num_om_par_scf(i1_do,2)-1
        i_w_num=i_w_num+1
        omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
        omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
        i_bios_omega_scf(i_w_num)=1
     end do

     if( num_om_par_scf(i1_do,3) /= 0) then
        if( om_con_method_scf(i1_do) == 'linear' ) then
           w_int=dcmplx(0.d0,omega_if_scf(i1_do,3)-omega_if_scf(i1_do,4))         &
                /dfloat(num_om_par_scf(i1_do,3))
           i_w_num=i_w_num+1
           omega_scf(i_w_num)=dcmplx(omega_if_scf(i1_do,2)                        &
                ,omega_if_scf(i1_do,4))+w_int*.5d0
           omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
           i_bios_omega_scf(i_w_num)=1
           do i2_do=1,num_om_par_scf(i1_do,3)-1
              i_w_num=i_w_num+1
              omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
              omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)
              i_bios_omega_scf(i_w_num)=1
           end do
        else
           if( om_con_method_scf(i1_do) == 'log' ) then
              th1=dlog(omega_if_scf(i1_do,4))
              th2=dlog(omega_if_scf(i1_do,3))
              temp_del=(th2-th1)/dfloat(num_om_par_scf(i1_do,3))
              i_w_num=i_w_num+1
              temp_om=th1+temp_del*.5d0
              omega_scf(i_w_num)=dcmplx(omega_if_scf(i1_do,2),dexp(temp_om))
              omega_weight_scf(i_w_num)                                            &
                   =dcmplx(0.d0,temp_del*dexp(temp_om))*dcmplx(0.d0,temp)
              i_bios_omega_scf(i_w_num)=1
              do i2_do=1,num_om_par_scf(i1_do,3)-1
                 i_w_num=i_w_num+1
                 temp_om=temp_om+temp_del
                 omega_scf(i_w_num)=dcmplx(omega_if_scf(i1_do,2),dexp(temp_om))
                 omega_weight_scf(i_w_num)                                          &
                      =dcmplx(0.d0,temp_del*dexp(temp_om))*dcmplx(0.d0,temp)
                 i_bios_omega_scf(i_w_num)=1
              end do
           else
              write(6,*) 'error: method omega'
              stop
           end if
        end if
     end if

  end do

  if( scf_bias == 'on' ) then
     temp=0.5d0/pai
     i_w_num=i_w_num+1
     w_int=dcmplx((dabs(cp_l-cp_r)+om_del_bias)/dfloat(num_om_bias),0.d0)
     omega_scf(i_w_num)=dcmplx(omega_if_scf(i_bios_minomega,2),om_im_bias)      &
          +w_int*.5d0
     omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,-temp)
     i_bios_omega_scf(i_w_num)=2
     do i2_do=1,num_om_bias-1
        i_w_num=i_w_num+1
        omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
        omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,-temp)
        i_bios_omega_scf(i_w_num)=2
     end do
  end if


  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*) '--------------------------------------------------------------'
  write(16,*) '------------   Integration contour:'
  write(16,*) '--------------------------------------------------------------'
  do i1_do=1,i_total_omega
     write(16,999) i1_do,i_bios_omega_scf(i1_do),omega_scf(i1_do)
  end do
  write(16,*) '--------------------------------------------------------------'
  write(16,*)
999 format(i5,i4,d25.15,'  + i',d23.15)
  close(16)

  return
end subroutine make_scf_omega_c1

subroutine make_scf_omega_c2(cp_l,cp_r)

  use scf_negf
  use constant
  use mod_mpi

  implicit none
  real(8), intent(in) :: cp_l,cp_r

  integer :: i1_do,i2_do,i_w_num
  real(8) :: temp
  complex(8) :: w_int
  real(8) :: alp1r,alp1i,alp2r,alp2i,a,b,th1,th2,th,th_del,cp
  integer :: i_matsubara

  pai=datan(1.d0)*4.d0


  cp=cp_l
  if( cp > cp_r ) then
     cp=cp_r
  end if
  if( scf_bias == 'on' ) then
     cp=cp-om_del_bias
  end if

  do i2_do=1,100
     i_matsubara=i2_do-1
     th=dfloat(2*i_matsubara+1)*pai*omega_tem(1)
     if( th > omega_if_scf(1,4) )then
        exit
     end if
  end do

  i_total_omega=0
  do i1_do=1,om_block_num_scf
     do i2_do=1,2
        i_total_omega=i_total_omega+num_om_par_scf(i1_do,i2_do)
     end do
     i_total_omega=i_total_omega+i_matsubara
  end do

  if( scf_bias == 'on' ) then
     i_total_omega=i_total_omega+num_om_bias
  end if

  call alo_scf_negf_omega2

  temp=.5d0/pai

  alp1r=omega_if_scf(1,1)
  alp1i=omega_if_scf(1,3)
  alp2r=omega_if_scf(1,2)-omega_gamm(1)
  alp2i=omega_if_scf(1,4)

  b=(alp1r*alp1r+alp1i*alp1i-alp2r*alp2r-alp2i*alp2i)*.5d0/(alp1r-alp2r)
  a=dsqrt(alp1i*alp1i+(alp1r-b)*(alp1r-b))
  th1=dacos((alp1r-b)/a)
  th2=dasin(alp2i/a)

  th_del=(th2-th1)/(dfloat(num_om_par_scf(1,1)-1))
  th=th1
  i_w_num=1
  omega_scf(i_w_num)=dcmplx(a*dcos(th)+b,a*dsin(th))
  omega_weight_scf(i_w_num)                                                    &
       =dcmplx(0.d0,temp*a*th_del*.5d0)*dcmplx(-dsin(th),dcos(th))              &
       /(cdexp((omega_scf(i_w_num)-dcmplx(cp,0.d0))/dcmplx(omega_tem(1),0.d0)) &
       +dcmplx(1.d0,0.d0))
  i_bios_omega_scf(i_w_num)=1
  do i2_do=1,num_om_par_scf(1,1)-1
     i_w_num=i_w_num+1
     th=th+th_del
     omega_scf(i_w_num)=dcmplx(a*dcos(th)+b,a*dsin(th))
     omega_weight_scf(i_w_num)                                                  &
          =dcmplx(0.d0,temp*a*th_del)*dcmplx(-dsin(th),dcos(th))                   &
          /(cdexp((omega_scf(i_w_num)-dcmplx(cp,0.d0))/dcmplx(omega_tem(1),0.d0)) &
          +dcmplx(1.d0,0.d0))
     i_bios_omega_scf(i_w_num)=1
  end do
  omega_weight_scf(i_w_num)=omega_weight_scf(i_w_num)*.5d0

  w_int=dcmplx(omega_gamm(1)/dfloat(num_om_par_scf(1,2)),0.d0)
  i_w_num=i_w_num+1
  omega_scf(i_w_num)=dcmplx(omega_if_scf(1,2)-omega_gamm(1),omega_if_scf(1,4)) &
       +w_int*dcmplx(0.5d0,0.d0)
  omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)                            &
       /(cdexp((omega_scf(i_w_num)-dcmplx(cp,0.d0))/dcmplx(omega_tem(1),0.d0)) &
       +dcmplx(1.d0,0.d0))
  i_bios_omega_scf(i_w_num)=1
  do i2_do=1,num_om_par_scf(1,2)-1
     i_w_num=i_w_num+1
     omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
     omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,temp)                          &
          /(cdexp((omega_scf(i_w_num)-dcmplx(cp,0.d0))/dcmplx(omega_tem(1),0.d0)) &
          +dcmplx(1.d0,0.d0))
     i_bios_omega_scf(i_w_num)=1
  end do

  do i2_do=i_matsubara-1,0,-1
     i_w_num=i_w_num+1
     th=dfloat(2*i2_do+1)*pai*omega_tem(1)
     omega_scf(i_w_num)=dcmplx(cp,th)
     omega_weight_scf(i_w_num)=dcmplx(omega_tem(1),0.d0)
     i_bios_omega_scf(i_w_num)=1
  end do

  if( scf_bias == 'on' ) then
     temp=0.5d0/pai
     i_w_num=i_w_num+1
     w_int=dcmplx((dabs(cp_l-cp_r)+om_del_bias)/dfloat(num_om_bias),0.d0)
     omega_scf(i_w_num)=dcmplx(cp,om_im_bias)+w_int*.5d0
     omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,-temp)
     i_bios_omega_scf(i_w_num)=2
     do i2_do=1,num_om_bias-1
        i_w_num=i_w_num+1
        omega_scf(i_w_num)=omega_scf(i_w_num-1)+w_int
        omega_weight_scf(i_w_num)=w_int*dcmplx(0.d0,-temp)
        i_bios_omega_scf(i_w_num)=2
     end do
  end if


  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*) '--------------------------------------------------------------'
  write(16,*) '------------   Integration contour:'
  write(16,*) '--------------------------------------------------------------'
  do i1_do=1,i_total_omega
     write(16,999) i1_do,i_bios_omega_scf(i1_do),omega_scf(i1_do)
  end do
  write(16,*) '--------------------------------------------------------------'
  write(16,*)
999 format(i5,i4,d25.15,'  + i',d23.15)
  close(16)

  return
end subroutine make_scf_omega_c2
