! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine cal_gf_se_c

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use gf_se_c
  use constant
  use ac_mpi_module
  use mod_mpi
  use scf_negf
  use hamiltonian_e

  implicit none

  integer :: ic_spin
  integer :: iw_max_mpi
  integer :: iw_do,i1_do,i2_do,i3_do,icou_l,icou_r
  integer :: px,py,qx,qy,ispin
  complex(8) :: w

  real(8) :: st1,st2,stdel,t_tot

  complex(8), allocatable :: tr_temp11(:,:,:,:),tr_temp12(:,:,:,:)
  integer :: i_temp,ier

  integer :: kt
  real(8) :: qx_tr,qy_tr
  type(MPI_MatDesc) :: descCC, descLL, descRR, descCL, descCR
  integer :: i, j

  call MPI__setupMatDesc( descCC, m_mat_max_c,m_mat_max_c )
  call MPI__setupMatDesc( descLL, mat_max_ll, mat_max_ll )
  call MPI__setupMatDesc( descRR, mat_max_rr, mat_max_rr )
  call MPI__setupMatDesc( descCR, m_mat_max_c,mat_max_rr )
  call MPI__setupMatDesc( descCL, m_mat_max_c,mat_max_ll )

  if( file_selfe_outsw == 'on' ) then
     call alo_mod_sftr(kt_tr,file_selfenergy)
  end if
  call alo_ham_temp_ham(descCC,descLL,descRR)

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '++++++++++++ start calculation:'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*)
  close(16)

  call show_ksampling

  if( spin_switch_cc /= 2) then
     ic_spin=1
  else
     ic_spin=2
  end if


  do kt=1,ka_tr*kb_tr

     if( ham_model_ini /= 'rtb_h' .and. ham_model_ini /= 'gsp' ) then
        qx_tr=po_kt_tr(2,kt)
        qy_tr=po_kt_tr(3,kt)
     else
        qx_tr=0.d0
        qy_tr=0.d0
     end if

     open(unit=16,file=file_tempout,position='append')
     write(16,*) '--------------------------------------------------------------'
     write(16,800) kt,qx_tr,qy_tr
800  format(' ------------  ',i5,2f13.8)
     write(16,*) '--------------------------------------------------------------'
     close(16)

     if( file_selfe_outsw == 'on' ) then
        open(unit=60,file=file_sf_tr(kt,MPI%rank2))
        write(60,995) m_mat_max_c,iw_max_gs
        write(60,996) omega_gs(1)
        write(60,996) omega_gs(iw_max_gs)
        close(60)
     end if

     call set_ham_temp_ham_l(descLL,qx_tr,qy_tr)
     call set_ham_temp_ham_r(descRR,qx_tr,qy_tr)
     if( ham_model_ini == 'input' ) then
        call set_ham_temp_ham_c(descCC,qx_tr,qy_tr)
        if( MPI%root ) then
           if( switch_out_ham /= 'off' ) then
              call outham(descCC,kt,ic_spin,hcc_t,scc_t) 
           end if
        end if
     end if
     if( ham_model_ini == 'scf_accel' ) then
        call set_ham_scf_ham_c(descCC,descLL,descRR,qx_tr,qy_tr)
        if( MPI%root ) then
           if( switch_out_ham /= 'off' ) then
              call outham(descCC,kt,ic_spin,h_cc_scf,s_cc_scf) 
           end if
        end if
     end if

     if( mod(iw_max_gs,MPI%sizeE) == 0 ) then
        iw_max_mpi=iw_max_gs
     else
        iw_max_mpi=iw_max_gs+MPI%sizeE-mod(iw_max_gs,MPI%sizeE)
     end if
     iw_max_mpi=(iw_max_mpi/MPI%sizeE)*MPI%sizeE
     do iw_do=1+MPI%rankE,iw_max_mpi,MPI%sizeE

        !!if(MPI%root) write(*,*) 'iw_do',iw_do, iw_max_mpi

        open(unit=16,file=file_tempout,position='append')
        write(16,*) '     ------- cal_gf_se_c:',iw_do
        close(16)


        do ispin=1,ic_spin

           if( iw_do > iw_max_gs ) then
              go to 100
           end if
           w=omega_gs(iw_do)

           t_tot=0.d0

           open(unit=16,file=file_tempout,position='append')
           call myclock(st1)
           do px=1,kx_max_ll                                       
              do py=1,ky_max_ll                                    
                 call selfenergy_l(descCC,descCL,descLL,w,iw_do,px,py,ispin,kt)

                 if( file_selfe_outsw == 'on' ) then
                    icou_l=0
                    do j=descCC%scol,descCC%ecol
                       do i=1,descCC%nrow
                          if( se_l_mat_per(i,j,px,py) /= dcmplx(0.d0,0.d0) )then 
                             icou_l=icou_l+1
                          end if
                       end do
                    end do
                 end if
              end do
           end do

           call myclock(st2)
           stdel=st2-st1
           t_tot=t_tot+stdel
           close(16)

           open(unit=16,file=file_tempout,position='append')
           call myclock(st1)

           do qx=1,kx_max_rr                                       
              do qy=1,ky_max_rr                                     
                 call selfenergy_r(descCC,descCR,descRR,w,iw_do,qx,qy,ispin,kt)

                 if( file_selfe_outsw == 'on' ) then
                    icou_r=0
                    do j=descCC%scol,descCC%ecol
                       do i=1,descCC%nrow
                          if( se_r_mat_per(i,j,qx,qy) /= dcmplx(0.d0,0.d0) )then 
                             icou_r=icou_r+1
                          end if
                       end do
                    end do
                 end if
              end do
           end do


100        continue

           if( file_selfe_outsw == 'on' ) then
              if( iw_do <= iw_max_gs ) then
                 do px=1,kx_max_ll
                    do py=1,ky_max_ll
                       open(unit=60,file=file_sf_tr(kt,MPI%rank2),position='append')
                       write(60,997) w,ispin
                       write(60,*) icou_l

                       do j=descCC%scol,descCC%ecol
                          do i=1,descCC%nrow
                             if( se_l_mat_per(i,j,px,py) /= dcmplx(0.d0,0.d0) ) then 
                                write(60,999) i,j,se_l_mat_per(i,j,px,py) 
                             end if
                          end do
                       end do
                       close(60)
                    end do
                 end do
                 do qx=1,kx_max_rr
                    do qy=1,ky_max_rr
                       open(unit=60,file=file_sf_tr(kt,MPI%rank2),position='append')
                       write(60,998) w,ispin
                       write(60,*) icou_r
                       do j=descCC%scol,descCC%ecol
                          do i=1,descCC%nrow
                             if( se_r_mat_per(i,j,qx,qy) /= dcmplx(0.d0,0.d0) ) then 
                                write(60,999) i,j,se_r_mat_per(i,j,qx,qy) 
                             end if
                          end do
                       end do
                       close(60)
                    end do
                 end do
              end if
           end if


           call myclock(st2)
           stdel=st2-st1
           t_tot=t_tot+stdel
           close(16)

           open(unit=16,file=file_tempout,position='append')
           call myclock(st1)

           do px=1,kx_max_ll                                       
              do py=1,ky_max_ll                                     
                 do qx=1,kx_max_rr                                   
                    do qy=1,ky_max_rr                                 
                       call trans(descCC,w,iw_do,px,py,qx,qy,ispin,kt)
                    end do
                 end do
              end do
           end do

           call myclock(st2)
           stdel=st2-st1
           t_tot=t_tot+stdel
           write(16,*) '           t(spin:',ispin,')=',t_tot
           close(16)

        end do
     end do
  end do

  if( file_selfe_outsw == 'on' ) then
     call dealo_mod_sftr
  end if
  call dealo_ham_temp_ham


  allocate(tr_temp11(4+num_block_gr,ic_spin,iw_max_gs,ka_tr*kb_tr)           &
       ,tr_temp12(4+num_block_gr,ic_spin,iw_max_gs,ka_tr*kb_tr)           &
       ,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if

  tr_temp11(1,:,:,:) = tr_gr_l(:,:,:)
  tr_temp11(2,:,:,:) = tr_gr_r(:,:,:)
  tr_temp11(3,:,:,:) = tr_gr_c(:,:,:)
  tr_temp11(4,:,:,:) = tr_tr(:,:,:)
  do i3_do=1, num_block_gr
     tr_temp11(4+i3_do,:,:,:) = tr_grc_block(:,i3_do,:,:)
  end do

  i_temp=(4+num_block_gr)*ic_spin*iw_max_gs*ka_tr*kb_tr

  call MPI_Allreduce( tr_temp11, tr_temp12, i_temp, &
       MPI_DOUBLE_COMPLEX, MPI_SUM, MPI%commE, MPI%info )

  tr_gr_l(:,:,:) = tr_temp12(1,:,:,:)
  tr_gr_r(:,:,:) = tr_temp12(2,:,:,:)
  tr_gr_c(:,:,:) = tr_temp12(3,:,:,:)
  tr_tr(:,:,:)   = tr_temp12(4,:,:,:)
  do i3_do=1, num_block_gr
     tr_grc_block(:,i3_do,:,:) = tr_temp12(4+i3_do,:,:,:)
  end do

  deallocate(tr_temp11,tr_temp12,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: alo_density_temp'
     stop
  end if

  call MPI__unsetMatDesc( descCC )
  call MPI__unsetMatDesc( descLL )
  call MPI__unsetMatDesc( descRR )
  call MPI__unsetMatDesc( descCL )
  call MPI__unsetMatDesc( descCR )




  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '++++++++++++  end  calculation:'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  close(16)


995 format(i10,i10)
996 format(d28.19,d28.19)
997 format(d28.19,d28.19,i5,'    ** left  *******************************')
998 format(d28.19,d28.19,i5,'    ** right *******************************')
999 format(i10,i10,d28.19,d28.19)

  return
end subroutine cal_gf_se_c

subroutine cal_gf_se_read

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use gf_se_c
  use constant
  use ac_mpi_module
  use mod_mpi
  use scf_negf

  implicit none

  integer :: ic_spin
  integer :: iw_max_mpi
  integer :: iw_do,i1_do,i2_do,icou,i3_do,ier
  integer :: px,py,qx,qy,ispin
  integer :: m_mat_max_read,itemp
  real(8) :: temp1,temp2
  complex(8) :: w,w1

  real(8) :: st1,st2,stdel

  complex(8), allocatable :: tr_temp11(:,:,:,:),tr_temp12(:,:,:,:)
  integer :: i_temp

  integer :: kt
  real(8) :: qx_tr,qy_tr
  type(MPI_MatDesc) :: descCC, descLL, descRR, descCL, descCR
  integer :: i, j

  call MPI__setupMatDesc( descCC, m_mat_max_c,m_mat_max_c )
  call MPI__setupMatDesc( descLL, mat_max_ll, mat_max_ll )
  call MPI__setupMatDesc( descRR, mat_max_rr, mat_max_rr )
  call MPI__setupMatDesc( descCL, m_mat_max_c, m_mat_max_l )
  call MPI__setupMatDesc( descCR, m_mat_max_c, m_mat_max_r )

  call alo_mod_sftr(kt_tr,file_selfenergy)
  call alo_ham_temp_ham(descCC,descLL,descRR)

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '++++++++++++ start calculation:'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  close(16)

  call show_ksampling

  if( spin_switch_cc /= 2) then
     ic_spin=1
  else
     ic_spin=2
  end if

  do kt=1,ka_tr*kb_tr
     qx_tr=po_kt_tr(2,kt)
     qy_tr=po_kt_tr(3,kt)

     open(unit=16,file=file_tempout,position='append')
     write(16,*) '--------------------------------------------------------------'
     write(16,800) kt,qx_tr,qy_tr
800  format(' -------- K:   ',i5,2f13.8)
     write(16,*) '--------------------------------------------------------------'
     close(16)

     open(unit=60,file=file_sf_tr(kt,MPI%rank2))

     read(60,*) m_mat_max_read,iw_max_gs
     read(60,*)
     read(60,*)
     if( ham_model_ini == 'input' ) then
        call set_ham_temp_ham_c(descCC,qx_tr,qy_tr)
        if( MPI%root ) then
           if( switch_out_ham /= 'off' ) then
              call outham(descCC,kt,ic_spin,hcc_t,scc_t) 
           end if
        end if
     end if
     if( ham_model_ini == 'scf_accel' ) then
        call set_ham_temp_ham_l(descLL,qx_tr,qy_tr)
        call set_ham_temp_ham_r(descRR,qx_tr,qy_tr)
        call set_ham_scf_ham_c(descCC,descLL,descRR,qx_tr,qy_tr)
        if( MPI%root ) then
           if( switch_out_ham /= 'off' ) then
              call outham(descCC,kt,ic_spin,h_cc_scf,s_cc_scf) 
           end if
        end if
     end if

     itemp=m_mat_max_c-m_mat_max_read

     if( mod(iw_max_gs,MPI%sizeE) == 0 ) then
        iw_max_mpi=iw_max_gs
     else
        iw_max_mpi=iw_max_gs+MPI%sizeE-mod(iw_max_gs,MPI%sizeE)
     end if
     iw_max_mpi=(iw_max_mpi/MPI%sizeE)*MPI%sizeE
     do iw_do=1+MPI%rankE,iw_max_mpi,MPI%sizeE

        open(unit=16,file=file_tempout,position='append')
        write(16,*) '     ------- cal_gf_se_c:',iw_do
        close(16)


        do ispin=1,ic_spin

           if( iw_do > iw_max_gs ) then
              go to 100
           end if

           do px=1,kx_max_ll
              do py=1,ky_max_ll
                 se_l_mat_per(:,:,px,py) = dcmplx(0.d0,0.d0) 
              end do
           end do

           do qx=1,kx_max_rr
              do qy=1,ky_max_rr
                 se_r_mat_per(:,:,qx,qy) = dcmplx(0.d0,0.d0) 
              end do
           end do

100        continue

           if( iw_do <= iw_max_gs ) then
              do px=1,kx_max_ll
                 do py=1,ky_max_ll
                    read(60,996) temp1,temp2
                    w=dcmplx(temp1,temp2)
                    read(60,*) icou
                    do i3_do=1,icou
                       read(60,999) i,j,temp1,temp2
                       se_l_mat_per(i,j,px,py) = dcmplx(temp1,temp2) 
                    end do
                 end do
              end do
              do qx=1,kx_max_rr
                 do qy=1,ky_max_rr
                    read(60,996) temp1,temp2
                    w1=dcmplx(temp1,temp2)
                    if( w /= w1 ) then
                       open(unit=16,file=file_tempout,position='append')
                       write(16,*) 'error--  w /= w1', w, w1
                       close(16)
                       stop
                    end if
                    read(60,*) icou
                    do i3_do=1,icou
                       read(60,999) i,j,temp1,temp2
                       se_r_mat_per(itemp+i,itemp+j,qx,qy) = dcmplx(temp1,temp2) 
                    end do
                 end do
              end do
           end if

           open(unit=16,file=file_tempout,position='append')
           call myclock(st1)

           do px=1,kx_max_ll
              do py=1,ky_max_ll
                 do qx=1,kx_max_rr
                    do qy=1,ky_max_rr
                       call trans(descCC,w,iw_do,px,py,qx,qy,ispin,kt)
                    end do
                 end do
              end do
           end do
           call myclock(st2)
           stdel=st2-st1
           write(16,*) '           t=',stdel

           close(16)

        end do


     end do
  end do

  close(60)

  call dealo_mod_sftr
  call dealo_ham_temp_ham

  allocate(tr_temp11(4+num_block_gr,ic_spin,iw_max_gs,ka_tr*kb_tr)           &
       ,tr_temp12(4+num_block_gr,ic_spin,iw_max_gs,ka_tr*kb_tr)           &
       ,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error allocate: alo_density_temp'
     stop
  end if

  tr_temp11(1,:,:,:) = tr_gr_l(:,:,:)
  tr_temp11(2,:,:,:) = tr_gr_r(:,:,:)
  tr_temp11(3,:,:,:) = tr_gr_c(:,:,:)
  tr_temp11(4,:,:,:) = tr_tr(:,:,:)
  do i3_do=1, num_block_gr
     tr_temp11(4+i3_do,:,:,:) = tr_grc_block(:,i3_do,:,:)
  end do

  i_temp=(4+num_block_gr)*ic_spin*iw_max_gs*ka_tr*kb_tr

  call MPI_Allreduce( tr_temp11, tr_temp12, i_temp, &
       MPI_DOUBLE_COMPLEX, MPI_SUM, MPI%commE, MPI%info )

  tr_gr_l(:,:,:) = tr_temp12(1,:,:,:)
  tr_gr_r(:,:,:) = tr_temp12(2,:,:,:)
  tr_gr_c(:,:,:) = tr_temp12(3,:,:,:)
  tr_tr(:,:,:)   = tr_temp12(4,:,:,:)
  do i3_do=1, num_block_gr
     tr_grc_block(:,i3_do,:,:) = tr_temp12(4+i3_do,:,:,:)
  end do

  deallocate(tr_temp11,tr_temp12,stat=ier)
  if( ier /= 0 ) then
     write(6,*) 'error deallocate: alo_density_temp'
     stop
  end if

  call MPI__unsetMatDesc( descCC )
  call MPI__unsetMatDesc( descLL )
  call MPI__unsetMatDesc( descRR )
  call MPI__unsetMatDesc( descCL )
  call MPI__unsetMatDesc( descCR )



  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*)
  write(16,*)
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '++++++++++++  end  calculation:'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  close(16)


996 format(d28.19,d28.19)
999 format(i10,i10,d28.19,d28.19)

  return
end subroutine cal_gf_se_read

subroutine outham(descCC,kt,ic_spin,hcc,scc)
  use ac_mpi_module
  implicit none

  type(MPI_MatDesc), intent(in) :: descCC
  integer, intent(in) :: kt,ic_spin
  complex(8), intent(in) :: hcc(descCC%nrow, descCC%scol:descCC%ecol,ic_spin) 
  complex(8), intent(in) :: scc(descCC%nrow, descCC%scol:descCC%ecol) 

  character(50) :: nfile_shs
  integer :: i_hcc_1,i_hcc_2,i_scc,i_temp1,i_temp2
  integer :: ispin,icou
  integer :: i, j

  call makefilename_outham(kt,nfile_shs)

  i_hcc_1=0
  i_hcc_2=0
  do ispin=1,ic_spin
     do j=descCC%scol,descCC%ecol
        do i=1,descCC%nrow
           if( cdabs(hcc(i,j,ispin)) > 1.d-16 ) then
              if( ispin == 1 ) then
                 i_hcc_1=i_hcc_1+1
              else
                 i_hcc_2=i_hcc_2+1
              end if
           end if
        end do
     end do
  end do
  i_scc=0
  do j=descCC%scol,descCC%ecol
     do i=1,descCC%nrow
        if( cdabs(scc(i,j)) > 1.d-16 ) then
           i_scc=i_scc+1
        end if
     end do
  end do

  i_temp1=0
  i_temp2=0
  open(unit=36,file=nfile_shs)

  write(36,*) i_temp1,descCC%nrow,i_temp2
  write(36,*) ic_spin-1
  write(36,*) i_hcc_1,i_hcc_2,i_scc
  write(36,*)
  write(36,*)

  do ispin=1,ic_spin
     write(36,*)
     icou=0
     do j=descCC%scol,descCC%ecol
        do i=1,descCC%nrow
           if( cdabs(hcc(i,j,ispin)) > 1.d-16 ) then
              icou=icou+1
              write(36,999) icou,i,j,hcc(i,j,ispin)
           end if
        end do
     end do
  end do

  write(36,*)
  icou=0
  do j=descCC%scol,descCC%ecol
     do i=1,descCC%nrow
        if( cdabs(scc(i,j)) > 1.d-16 ) then
           icou=icou+1
           write(36,999) icou,i,j,scc(i,j)
        end if
     end do
  end do

999 format(i10,i10,i10,d28.19,d28.19)

  close(36)

  return
end subroutine outham

subroutine makefilename_outham(kt,nfile_strans)

  implicit none
  integer, intent(in) :: kt
  character(50), intent(out) :: nfile_strans

  character(1) :: character_temk(4),a(10)
  integer :: i1,i2,k1,i_temp1,i_temp2

  a(1)='0'
  a(2)='1'
  a(3)='2'
  a(4)='3'
  a(5)='4'
  a(6)='5'
  a(7)='6'
  a(8)='7'
  a(9)='8'
  a(10)='9'

  nfile_strans='hss'

  i_temp1=kt
  do i2=1,4
     i_temp2=i_temp1/(10**(4-i2))
     character_temk(i2)=a(i_temp2+1)
     i_temp1=i_temp1-(10**(4-i2))*i_temp2
  end do
  nfile_strans=trim(nfile_strans)                                         &
       //'_'//character_temk(1)//character_temk(2)                &
       //character_temk(3)//character_temk(4)//'.data'

  return
end subroutine makefilename_outham
