
subroutine output_tmp
  use ac_parameter
  use scf_negf
  use hamiltonian_temp
  use ac_mpi_module
  use gf_se_c

  integer i
  integer count, rcount, icount

  write(6,*) 'atom', Param%Data%natom
  write(6,*) 'base', Base%npao

  rcount=0
  icount=0

  count = size(Base%vnpao) + size(Base%vipao)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'Base%vnpao', count*8/1e6, count
  count = size(Base%vpao)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'Base%vpao', count*8/1e6, count

  count=0
  do i=1,size(Base%vpao)
     count=count+size(Base%vpao(i)%wave)     
  end do
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'Base%vpao%wave', count*8/1e6, count
  count=0
  do i=1,size(Base%vpao)
     count=count+size(Base%vpao(i)%gwave)     
  end do
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'Base%vpao%gwave', count*8/1e6, count

  count = size(Density%rhoLS) + size(Density%rho) + size(Density%rhoval) + size(Density%rhopcc)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'rho,rhoval,rhopcc', count*8/1e6, count

  count = size(Potential%Vext) + size(Potential%dVhar) + size(Potential%Vtot)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'vext,dfhar,vtot', count*8/1e6, count

  count=0
  do l=0, Param%Cell%nL-1
     do a=MPI%isatom, MPI%ieatom
        do b=1, Param%Data%natom
           if(associated(Hamiltonian%vAtomMatrix(b,a,l)%Ptr)) then
              count=count+size(Hamiltonian%vAtomMatrix(b,a,l)%Ptr%H0) &
                   +size(Hamiltonian%vAtomMatrix(b,a,l)%Ptr%H) &
                   +size(Hamiltonian%vAtomMatrix(b,a,l)%Ptr%CDM)
           end if
        end do
     end do
  end do
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'h%amat%h0,h,cdm,edm', count*8/1e6, count

  count = size(v_ext) + size(rhoval) + size(rhopcc) + size(v_hartree)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'v_ext,rhoval,rhopcc,v_hartree', count*8/1e6, count
  count = size(rho_temp)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'rho_temp', count*8/1e6, count

  count = size(v_tot) + size(r_cell_dk) + size(g2_temp)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'v_tot,r_cell_dk,g2_temp', count*8/1e6, count
  count = size(cell_lr) 
  icount=icount+count
  write(6,'(a,t30,f15.5,i20)') 'cell_lr', count*4/1e6, count

  count = size(hv_atom_matrix)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'hv_atom_matrix', count*8/1e6, count

  count = size(ht_hs_c) + size(rac_c)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'ht_hs_c,rac_c', count*8/1e6, count
  count = size(i_over_c) + size(i_orb_c)
  icount=icount+count
  write(6,'(a,t30,f15.5,i20)') 'i_over_c,i_orb_c', count*4/1e6, count

  count = size(ht_hs_l) + size(rac_l)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'ht_hs_l,rac_l', count*8/1e6, count
  count = size(i_over_l) + size(i_orb_l)
  icount=icount+count
  write(6,'(a,t30,f15.5,i20)') 'i_over_l,i_orb_l', count*4/1e6, count

  count = size(ht_hs_r) + size(rac_r)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'ht_hs_r,rac_r', count*8/1e6, count
  count = size(i_over_r) + size(i_orb_r)
  icount=icount+count
  write(6,'(a,t30,f15.5,i20)') 'i_over_r,i_orb_r', count*4/1e6, count

  count = size(vh_l) + size(v0_l) + size(dens_temp_l) + size(v_tot_l) + size(vh_temp_l) + size(vh_l_f)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'vh_l,v0_l,dens_temp_l,v_tot_l,vh_temp_l', count*8/1e6, count
  count = size(den_l)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'dens_l', count*8/1e6, count  

  count = size(se_l_mat_per) + size(se_r_mat_per)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'se_l_mat_per,se_r_mat_per', count*8/1e6, count
  count = size(tr_gr_l) + size(tr_gr_r) + size(tr_gr_c) + size(tr_tr) + size(tr_grc_block)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'tr_gr_l,tr_gr_r,tr_gr_c,tr_tr,tr_grc_block', count*8/1e6, count

  count = size(h_cc_scf) + size(s_cc_scf) 
  rcount=rcount+count*2
  write(6,'(a,t30,f15.5,i20)') 'h_cc_scf,s_cc_scf', count*8/1e6, count

  count = size(hcc_t) + size(scc_t) &
       + size(s00_l_t) + size(s01_l_t) + size(s10_l_t) &
       + size(s00_r_t) + size(s01_r_t) + size(s10_r_t) &
       + size(h00_l_t) + size(h01_l_t) + size(h10_l_t) &
       + size(h00_r_t) + size(h01_r_t) + size(h10_r_t)
  rcount=rcount+count*2
  write(6,'(a,t30,f15.5,i20)') 'hcc_t,scc_t,...', count*8/1e6, count

  count = size(rho) + size(rhols)
  rcount=rcount+count
  write(6,'(a,t30,f15.5,i20)') 'rho,rhols', count*8/1e6, count

  write(6,'(a,t30,f15.5,i20)') 'total', (rcount*8+icount*4)/1e6, rcount+icount/2

end subroutine output_tmp

subroutine Potential__deallocate2
  use ac_parameter

  implicit none

  if( associated(Potential%Vext) ) deallocate( Potential%Vext )
  if( associated(Potential%dVhar) ) deallocate( Potential%dVhar )
  if( associated(Potential%Vexc) ) deallocate( Potential%Vexc )
  if( associated(Potential%vnVpsnon) ) deallocate( Potential%vnVpsnon )
  if( associated(Potential%viVpsnon) ) deallocate( Potential%viVpsnon )
  if( associated(Potential%vVpsnon) ) deallocate( Potential%vVpsnon )
  if( associated(Potential%vVpsloc) ) deallocate( Potential%vVpsloc )
  if( associated(Potential%vnVpsloc) ) deallocate( Potential%vnVpsloc )
  if( associated(Potential%viVpsloc) ) deallocate( Potential%viVpsloc )

  if( Param%Option%cluster ) then
     call Screening__deallocate
  endif

  return
end subroutine Potential__deallocate2

subroutine Density__deallocate2
  use ac_parameter

  implicit none
  integer :: n

  if( Param%Option%spin_orbit ) then
  else
  end if

  if( associated(Density%rhoval) ) deallocate(Density%rhoval)
  if( associated(Density%rhopcc) ) deallocate(Density%rhopcc)
  if( associated(Density%vpast) ) then
     if( Param%Option%spin_orbit ) then
        do n=1, size(Density%vpast)
        end do
     else
        do n=1, size(Density%vpast)
        end do
     end if
  end if

  return
end subroutine Density__deallocate2

subroutine Base__deallocate2
  use ac_parameter
  use ac_mpi_module

  implicit none
  integer :: a, i, i1
  type(PAO_type), pointer :: pao

  if( associated(Base%vpao)  ) then
     do a=1, Param%Data%natom
        if( a<MPI%isatom .or. MPI%ieatom<a ) cycle

        i=Base%vipao(a)
        do i1=MPI%ispao(a), MPI%iepao(a)
           pao => Base%vpao(i+i1-1)
        end do
     end do

  end if

  call SphericalHarmonic__deallocate

  return
end subroutine Base__deallocate2

subroutine Base__deallocate3
  use ac_parameter
  use ac_mpi_module

  implicit none
  integer :: a, i, i1
  type(PAO_type), pointer :: pao

  if( associated(Base%vpao)  ) then
     do a=1, Param%Data%natom
        if( a<MPI%isatom .or. MPI%ieatom<a ) cycle

        i=Base%vipao(a)
        do i1=MPI%ispao(a), MPI%iepao(a)
           call PAO__deallocate( Base%vpao(i+i1-1) )
           pao => Base%vpao(i+i1-1)
           if( associated(pao%wave) ) deallocate(pao%wave)
        end do
     end do

     deallocate( Base%vpao )
  end if
  if( associated(Base%vipao) ) deallocate( Base%vipao )
  if( associated(Base%vnpao) ) deallocate( Base%vnpao )

  return
end subroutine Base__deallocate3

subroutine Param__deallocate2
  use ac_parameter
  implicit none

  integer :: a, i

  if( associated(Param%SCF%vbloch) )   deallocate( Param%SCF%vbloch )
  if( associated(Param%SCF%vK) )   deallocate( Param%SCF%vK )
  if( associated(Param%SCF%i_vK) )   deallocate( Param%SCF%i_vK )

  if( associated(Param%Band%vKpath) ) deallocate( Param%Band%vKpath )
  if( associated(Param%Band%vK) ) deallocate( Param%Band%vK )

  if( associated(Param%MO%vK) ) deallocate( Param%MO%vK )

  do i=1, Param%Data%nelem
     call Element__deallocate2( Param%Data%velem(i) )
  end do
  do a=1, Param%Data%natom
     call Atom__deallocate( Param%Data%vatom(a) )
  end do

  if( associated(Param%Data%vnpao) ) deallocate( Param%Data%vnpao )
  if( associated(Param%Data%vipao) ) deallocate( Param%Data%vipao )

  if( associated(Param%Data%velem_file) ) deallocate( Param%Data%velem_file )

  call SphericalBessel__deallocate

  return
end subroutine Param__deallocate2

subroutine Element__deallocate2( elem )
  use ac_parameter

  implicit none
  type(Element_type), intent(out) :: elem
  integer :: n

  call RadialFunc__deallocate( elem%rhoval )
  call RadialFunc__deallocate( elem%Vval )

  do n=1, elem%npao
     call RadialFunc__deallocate( elem%vpao(n) )
  end do

  call RadialFunc__deallocate( elem%Vloc )

  do n=1, elem%nVnon
     if( elem%dirac ) then
        call RadialFunc__deallocate( elem%vVnon(n,1) )
        call RadialFunc__deallocate( elem%vVnon(n,2) )
     else
        call RadialFunc__deallocate( elem%vVnon(n,1) )
     end if
  end do
  if( associated(elem%vVnon) ) deallocate(elem%vVnon)

  if( Param%Option%projection ) then
     do n=1, elem%nVloc
        call RadialFunc__deallocate( elem%vVloc(n) )
     end do
     if( associated(elem%vVloc) ) deallocate(elem%vVloc)

     do n=1, elem%npao2
        call RadialFunc__deallocate( elem%vpao2(n) )
        call RadialFunc__deallocate( elem%vpao2bar(n) )
     end do
     if( associated(elem%vpao2) ) deallocate(elem%vpao2)
     if( associated(elem%vpao2bar) ) deallocate(elem%vpao2bar)
  end if

  if( elem%pcc ) then
     call RadialFunc__deallocate( elem%rhopcc )
  end if

  return
end subroutine Element__deallocate2
