! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine RadialFunc__set( RF, vr, N )
  use ac_parameter

  implicit none
  integer, intent(in)             :: N
  type(RadialFunc_type), intent(inout) :: RF
  real(8), intent(in)             :: vr(N)

  RF%vK => null()

  if( .not. associated(RF%vR) ) then
     write(*,*) "Error: vR is not allocated"
     stop
  end if

  call Spline__set( RF%fR, RF%vR, vr, N )

  return
end subroutine RadialFunc__set

subroutine RadialFunc__reset( RF )
  use ac_parameter

  implicit none
  type(RadialFunc_type), intent(out) :: RF

  if( associated(RF%vK) ) deallocate(RF%vK)

  call Spline__reset( RF%fR, RF%vR )

  return
end subroutine RadialFunc__reset

subroutine RadialFunc__transpose( RF )
  use ac_parameter

  implicit none
  type(RadialFunc_type), intent(inout) :: RF

  allocate( RF%vK(SphericalBessel%Nk) )
  call SphericalBessel__transpose( RF%vK, RF%fR, RF%l )

  return
end subroutine RadialFunc__transpose

subroutine RadialFunc__transposetail( RF )
  use ac_parameter

  implicit none
  type(RadialFunc_type), intent(inout) :: RF

  call SphericalBessel__transposetail( RF%vK, RF%fR, RF%Q )

  return
end subroutine RadialFunc__transposetail

subroutine RadialFunc__deallocate( RF )
  use ac_parameter

  implicit none
  type(RadialFunc_type), intent(out) :: RF

  if( associated(RF%vR) ) deallocate(RF%vR)
  if( associated(RF%vK) ) deallocate(RF%vK)
  call Spline_deallocate(RF%fR)

  return
end subroutine RadialFunc__deallocate

subroutine RadialFunc__bracketS( sum, RF1, RF2 ) 
  use ac_parameter

  implicit none
  type(RadialFunc_type), intent(in) :: RF1, RF2

  real(8)  :: sum
  real(8) :: R(3)

  real(8)  :: g, y, j

  R = (/ 0.d0, 0.d0, 0.d0 /)

  call SphericalHarmonic__Gaunt( 0, 0, 0, 0, 0, 0, g )
  call SphericalHarmonic__rlY( 0, 0, R, y )
  call SphericalBessel__integrateS( j, RF1%vK, RF2%vK, 0, 0.d0 )

  sum = g*y*j

  return
end subroutine RadialFunc__bracketS
