! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_parameter(file_name)

  use condition_ini
  use gsp_parameter
  use rtbh_parameter
  use mod_mpi

  implicit none

  character(50), intent(in) :: file_name
  real(8) :: st1,st2,stdel

  open(unit=16,file=file_tempout,position='append')
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,999) file_name
  write(16,*)
999 format(' +++++++++++ start: read file:: ',a30)
  call myclock(st1)
  close(16)

  call read_input_condition_ini(file_name)
  if( ham_model_ini .eq. 'gsp' ) then
     call read_gsp_parameter
     call read_input_tb_cordinate
     call alo_pair_ini
     call set_pair_ini(atom_parameter)
  end if
  if( ham_model_ini .eq. 'rtb_h' ) then
     call read_rtbh_parameter
     call read_input_tb_cordinate
  end if
  if( ham_model_ini .eq. 'input' ) then
     call set_hamiltonian_temp(file_parameter1,file_parameter2,file_parameter3)
     call set_ksampling_tr
  end if
  if( ham_model_ini .eq. 'scf_accel' ) then
     call set_scf_accel
     call set_ksampling_tr
  end if

  open(unit=16,file=file_tempout,position='append')
  call myclock(st2)
  stdel=st2-st1
  write(16,*) '++++++++++++  end : read file'
  write(16,*) '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++'
  write(16,*) '                t=',stdel
  close(16)

  return
end subroutine set_parameter
