! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_mat_max(p_or_f,num_unit,num_atom_kind,atom_kindn,atom_orbital       &
     ,num_atom)

  use hamiltonian_e

  implicit none
  character(50), intent(in) :: p_or_f
  integer, intent(in) :: num_atom,num_atom_kind
  integer, intent(in) :: atom_orbital(num_atom_kind),atom_kindn(num_atom)
  integer, intent(in) :: num_unit(3)
  integer :: i1_do

  mat_max=0
  do i1_do=1,num_atom
     mat_max=mat_max+atom_orbital(atom_kindn(i1_do))
  end do
  if( p_or_f == 'free' ) then
     mat_max=mat_max*num_unit(1)*num_unit(2)
  end if

  return
end subroutine set_mat_max

subroutine set_mat_zper(p_or_f,num_unit,num_atom_kind,atom_kindn,atom_orbital      &
     ,num_atom)

  use hamiltonian_zper

  implicit none
  character(50), intent(in) :: p_or_f
  integer, intent(in) :: num_atom,num_atom_kind
  integer, intent(in) :: atom_orbital(num_atom_kind),atom_kindn(num_atom)
  integer, intent(in) :: num_unit(3)
  integer :: i1_do

  mat_max_zper=0
  do i1_do=1,num_atom
     mat_max_zper=mat_max_zper+atom_orbital(atom_kindn(i1_do))
  end do
  if( p_or_f == 'free' ) then
     mat_max_zper=mat_max_zper*num_unit(1)*num_unit(2)
  end if

  return
end subroutine set_mat_zper
