! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine read_input_condition_ini(file_name)

  use condition_ini
  use scf_negf
  use hamiltonian_c
  use mod_mpi

  implicit none
  character(50), intent(in) :: file_name

  real(8) :: temp(4)
  integer :: i_do,i_temp,i_check,j_check

  character(256) :: buf
  character(50) :: dummy1,dummy2,dummy3
  character(50) :: tag1,tag2

  open(unit=16,file=file_tempout,position='append')
  write(16,*)
  write(16,*)
  write(16,*) '********************** **************** **********************'
  write(16,*) '*                input  condition  ! general !               *'
  write(16,*) '********************** **************** **********************'
  write(16,*)
  close(16)

  !                       ------------------------------------                       !

  ham_model_ini=''
  calc_type=''
  file_selfe_outsw=''
  switch_out_gf=''
  switch_out_tr=''
  switch_out_ham=''
  eigen_s_as_ini=''
  open(unit=19,file=file_name,status='old')
  do 
     read(19,'(a)',end=100) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('general{')
        do 
           read(19,'(a)',end=100) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('model_type')
              read(buf,*) dummy1,dummy2,ham_model_ini
           case('calc_type')
              read(buf,*) dummy1,dummy2,calc_type
           case('read_SF_file')
              read(buf,*) dummy1,dummy2,file_selfe_outsw
           case('output_G&T')
              read(buf,*) dummy1,dummy2,dummy3
              if( switch_out_tr == '' ) then
                 switch_out_tr=dummy3
              end if
              if( switch_out_gf == '' ) then
                 switch_out_gf=dummy3
              end if
           case('output_G')
              read(buf,*) dummy1,dummy2,switch_out_gf
           case('output_T')
              read(buf,*) dummy1,dummy2,switch_out_tr
           case('output_H')
              read(buf,*) dummy1,dummy2,switch_out_ham
           case('band_calc_type')
              read(buf,*) dummy1,dummy2,eigen_s_as_ini
           case('}general')
              go to 100
           end select
        end do
     end select
  end do
100 continue
  close(19)
  if( ham_model_ini == '' ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/model_type// => stop'
     close(17)
     stop
  end if
  if(  calc_type == '' ) then
     calc_type='trans'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/calc_type// => def'
     close(17)
  end if
  if( file_selfe_outsw == '' ) then
     file_selfe_outsw='none'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/read_SF_file// => def'
     close(17)
  end if
  if( switch_out_gf == '' ) then
     switch_out_gf='diagonal'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/output_G// => def'
     close(17)
  end if
  if( switch_out_tr == '' ) then
     switch_out_tr='diagonal'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/output_T// => def'
     close(17)
  end if
  if( switch_out_ham == '' ) then
     switch_out_ham='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/output_H// => off'
     close(17)
  end if

  !                       ------------------------------------                       !

  file_parameter_co=''
  file_parameter=''
  file_parameter1=''
  file_parameter2=''
  file_parameter3=''
  file_selfenergy=''
  file_parameter_tb_par=''
  open(unit=19,file=file_name,status='old')
  do 
     read(19,'(a)',end=120) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('file{')
        do 
           read(19,'(a)',end=120) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('tb_cordinate')
              read(buf,*) dummy1,dummy2,file_parameter_co
           case('tb_parameter')
              read(buf,*) dummy1,dummy2,file_parameter_tb_par
           case('input_central')
              read(buf,*) dummy1,dummy2,file_parameter1
           case('input_junc')
              read(buf,*) dummy1,dummy2,file_parameter1
           case('input_left')
              read(buf,*) dummy1,dummy2,file_parameter2
           case('input_right')
              read(buf,*) dummy1,dummy2,file_parameter3
           case('scf_file')
              read(buf,*) dummy1,dummy2,file_parameter
           case('self_e_file')
              read(buf,*) dummy1,dummy2,file_selfenergy
           case('}file')
              go to 120
           end select
        end do
     end select
  end do
120 continue
  close(19)

  if( ham_model_ini == 'gsp' .and. file_parameter_co == '' ) then
     file_parameter_co=file_name
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: gsp //file/tb_cordinate// => current'
     close(17)
  end if
  if( ham_model_ini == 'rtb_h' .and. file_parameter_co == '' ) then
     file_parameter_co=file_name
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: rtb_h //file/tb_cordinate// => current'
     close(17)
  end if
  if( ham_model_ini == 'input'                                                 &
       .and. (file_parameter1 == '' .or. file_parameter2 == ''                 &
       .or. file_parameter3 == '') ) then
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: input //file/input_**// => stop'
     close(17)
     stop
  end if
  if( ham_model_ini == 'scf_accel' .and. file_parameter == '' ) then
     file_parameter=file_name
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: scf //file/scf_file// => curren'
     close(17)
  end if
  if( file_selfenergy == '' ) then
     file_selfenergy='none'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //file/self_e_file// => none'
     close(17)
  end if

  if( ham_model_ini == 'rtb_h' .and. file_parameter_tb_par == '' ) then
     file_parameter_tb_par='../data/rtbh_c_parameter.in'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: rtb_h //file/tb_parameter// => def'
     close(17)
  end if
  if( ham_model_ini == 'gsp' .and. file_parameter_tb_par == '' ) then
     file_parameter_tb_par='../data/gsp_c_parameter.in'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ???: gsp //file/tb_parameter// => def'
     close(17)
  end if

  !                       ------------------------------------                       !

  sgf_method_ini=''
  iteration_max_ini=0
  eps_ini=0.0000d0
  open(unit=19,file=file_name)
  do 
     read(19,'(a)',end=110) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('surface_green_func{')
        do 
           read(19,'(a)',end=110) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('method')
              read(buf,*) dummy1,dummy2,i_temp
              if( i_temp == 1 ) then
                 sgf_method_ini='transfer'
              else
                 sgf_method_ini='direct'
              end if
           case('max_number')
              read(buf,*) dummy1,dummy2,iteration_max_ini
           case('criterion')
              read(buf,*) dummy1,dummy2,eps_ini
           case('}surface_green_func')
              go to 110
           end select
        end do
     end select
  end do
110 continue
  close(19)
  if( sgf_method_ini == '' ) then
     sgf_method_ini='transfer'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //surface_green_func/method// => def'
     close(17)
  end if
  if( iteration_max_ini == 0 ) then
     iteration_max_ini=40
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //surface_green_func/max_number// => def'
     close(17)
  end if
  if( eps_ini == 0.0000d0 ) then
     eps_ini=0.00001d0
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //surface_green_func/criterion// => def'
     close(17)
  end if

  !                       ------------------------------------                       !

  ka_tr=1
  kb_tr=1
  filename_kpoint=''
  if( ham_model_ini /= 'rtb_h' .and. ham_model_ini /= 'gsp' ) then
     ka_tr=0
     kb_tr=0
     open(unit=19,file=file_name)
     do 
        read(19,'(a)',end=180) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('gra_ksampling{')
           do 
              read(19,'(a)',end=180) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('point')
                 read(buf,*) dummy1,dummy2,dummy3
                 if( dummy3 == 'gamma' ) then
                    ka_tr=1
                    kb_tr=1
                 else
                    if( dummy3 == 'file' ) then
                       read(buf,*) dummy1,dummy2,dummy3,filename_kpoint
                       ka_tr=1
                       kb_tr=1
                    else
                       read(buf,*) dummy1,dummy2,ka_tr,kb_tr
                    end if
                 end if
              case('}gra_ksampling')
                 go to 180
              end select
           end do
        end select
     end do
180  continue
     close(19)

     if( ka_tr == 0 ) then
        ka_tr=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '???     ??? //gra_ksampling/mesh// => ka_tr=1'
        close(17)
     end if
     if( kb_tr == 0 ) then
        kb_tr=1
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '???     ??? //gra_ksampling/mesh// => kb_tr=1'
        close(17)
     end if
  end if

  !                       ------------------------------------                       !

  method_sum_om=1
  om_block_num=1
  num_gra=1
  call alo_input_condition_2
  om_con_method(1)='linear'
  num_om_par(1)=200
  omega_if(1,1)=dcmplx(0.d0,0.d0)
  omega_if(1,2)=dcmplx(0.d0,0.d0)
  if( calc_type == 'trans' .or. calc_type == 'calc_dos' ) then
     i_check=0
     j_check=0
     temp(1)=0.d0
     temp(2)=0.d0
     temp(3)=0.d0
     temp(4)=0.d0
     num_om_par(1)=0
     open(unit=19,file=file_name)
     do 
        read(19,'(a)',end=170) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('gra_energy{')
           do 
              read(19,'(a)',end=170) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('mesh_number')
                 read(buf,*) dummy1,dummy2,num_om_par(1)
              case('start_energy')
                 read(buf,*) dummy1,dummy2,temp(1)
                 i_check=1
              case('end_energy')
                 read(buf,*) dummy1,dummy2,temp(2)
                 j_check=1
              case('im_energy')
                 read(buf,*) dummy1,dummy2,temp(3)
                 temp(4)=temp(3)
              case('}gra_energy')
                 go to 170
              end select
           end do
        end select
     end do
170  continue
     close(19)

     if( num_om_par(1) == 0 ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //gra_energy/mesh_number// => stop'
        close(17)
        stop
     end if
     if( i_check == 0 ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //gra_energy/start_energy// => stop'
        close(17)
        stop
     end if
     if( j_check == 0 ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //gra_energy/end_energy// => stop'
        close(17)
        stop
     end if
     if( temp(3) == 0.d0 ) then
        temp(3)=1.d-5
        temp(4)=1.d-5
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //gra_energy/im_energy// => def'
        close(17)
     end if
     omega_if(1,1)=dcmplx(temp(1),temp(3))
     omega_if(1,2)=dcmplx(temp(2),temp(4))
  end if

  num_iv_mesh=20
  om_sum=0.0001d0
  if( calc_type == 'iv' ) then
     num_iv_mesh=0
     om_sum=0.d0
     open(unit=19,file=file_name)
     do 
        read(19,'(a)',end=160) buf
        if( buf == '' ) then
           cycle
        end if
        read(buf,*) tag1
        if( tag1(1:1) == '#' ) then
           cycle
        end if
        select case(tag1)
        case('iv_energy{')
           do 
              read(19,'(a)',end=160) buf
              if( buf == '' ) then
                 cycle
              end if
              read(buf,*) tag2
              if( tag2(1:1) == '#' ) then
                 cycle
              end if
              select case(tag2)
              case('mesh_number')
                 read(buf,*) dummy1,dummy2,num_iv_mesh
                 i_check=1
              case('im_energy')
                 read(buf,*) dummy1,dummy2,om_sum
              case('}iv_energy')
                 go to 160
              end select
           end do
        end select
     end do
160  continue
     close(19)

     if( num_iv_mesh == 0 ) then
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //iv_energy/mesh_number// => stop'
        close(17)
        stop
     end if
     if( om_sum == 0.d0 ) then
        om_sum=1.d-5
        open(unit=17,file=file_tempout,position='append')
        write(17,*) '??? broken ??? //iv_energy/im_energy// => def'
        close(17)
     end if
  end if

  !                       ------------------------------------                       !

  switch_l_eigen=''
  dos_on_off_ini_l=''
  kz_max_l=0
  open(unit=19,file=file_name)
  do 
     read(19,'(a)',end=140) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('electrode_left{')
        do 
           read(19,'(a)',end=140) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('s_band')
              read(buf,*) dummy1,dummy2,switch_l_eigen
           case('s_electrod_DOS')
              read(buf,*) dummy1,dummy2,dos_on_off_ini_l
           case('k_point_mesh')
              read(buf,*) dummy1,dummy2,kz_max_l
           case('}electrode_left')
              go to 140
           end select
        end do
     end select
  end do
140 continue
  close(19)

  if( switch_l_eigen == '' ) then
     switch_l_eigen='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_left/s_band// => def'
     close(17)
  end if
  if( dos_on_off_ini_l == '' ) then
     dos_on_off_ini_l='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_left/s_electrod_DOS// => def'
     close(17)
  end if
  if( kz_max_l == 0 ) then
     kz_max_l=32
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_left/k_point_mesh// => def'
     close(17)
  end if

  switch_r_eigen=''
  dos_on_off_ini_r=''
  kz_max_r=0
  open(unit=19,file=file_name)
  do 
     read(19,'(a)',end=130) buf
     if( buf == '' ) then
        cycle
     end if
     read(buf,*) tag1
     if( tag1(1:1) == '#' ) then
        cycle
     end if
     select case(tag1)
     case('electrode_right{')
        do 
           read(19,'(a)',end=130) buf
           if( buf == '' ) then
              cycle
           end if
           read(buf,*) tag2
           if( tag2(1:1) == '#' ) then
              cycle
           end if
           select case(tag2)
           case('s_band')
              read(buf,*) dummy1,dummy2,switch_r_eigen
           case('s_electrod_DOS')
              read(buf,*) dummy1,dummy2,dos_on_off_ini_r
           case('k_point_mesh')
              read(buf,*) dummy1,dummy2,kz_max_r
           case('}electrode_right')
              go to 130
           end select
        end do
     end select
  end do
130 continue
  close(19)

  if( switch_r_eigen == '' ) then
     switch_r_eigen='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_right/s_band// => def'
     close(17)
  end if
  if( dos_on_off_ini_r == '' ) then
     dos_on_off_ini_r='off'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_right/s_electrod_DOS// => def'
     close(17)
  end if
  if( kz_max_r == 0 ) then
     kz_max_r=32
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //electrode_right/k_point_mesh// => def'
     close(17)
  end if

  if( eigen_s_as_ini == ''                                                     &
       .and. (switch_l_eigen == 'on' .or. switch_r_eigen == 'on') ) then
     eigen_s_as_ini='symmetry'
     open(unit=17,file=file_tempout,position='append')
     write(17,*) '??? broken ??? //general/band_calc_type// => def'
     close(17)
  end if

  !                       ------------------------------------                       !

  open(unit=16,file=file_tempout,position='append')
  write(16,*)

  if( ham_model_ini == 'scf_accel' ) then
     ham_model_ini='scf_calc'
  end if
  write(16,900) ham_model_ini
900 format('                           model: ',a20)
  if( ham_model_ini == 'scf_calc' ) then
     ham_model_ini='scf_accel'
  end if

  if( ham_model_ini /= 'input' ) then
     if( ham_model_ini /= 'rtb_h' .and. ham_model_ini /= 'gsp' ) then
        write(16,902) file_parameter
902     format('                       file name: ',a40)
     else
        write(16,934) file_parameter_co
        write(16,935) file_parameter_tb_par
934     format('             cordinate file name: ',a40)
935     format('                  data file name: ',a40)
     end if
  else
     write(16,931) file_parameter1
931  format('               file name - junc : ',a40)
     write(16,932) file_parameter2
932  format('               file name - left : ',a40)
     write(16,933) file_parameter3
933  format('               file name - right: ',a40)
  end if

  write(16,915) file_selfenergy
915 format('             file of self energy: ',a20)
  write(16,921) file_selfe_outsw
921 format('   /switch/  file of self energy: ',a10)

  write(16,*) 
  write(16,904) calc_type
904 format('                       calc type: ',a10)
  write(16,905) switch_out_gf
905 format('                        output_G: ' ,a10)
  write(16,928) switch_out_tr
928 format('                        output_T: ' ,a10)
  write(16,950) switch_out_ham
950 format('                        output_H: ' ,a10)

  if( sgf_method_ini == 'transfer' ) then
     i_temp=1
  else
     i_temp=2
  end if
  write(16,*)
  write(16,903) i_temp
903 format('           surface GF     method: ',i15)
  write(16,914) iteration_max_ini
914 format('           surface GF  iter. max: ',i15)
  write(16,918) eps_ini
918 format('           surface GF  criterion: ',e15.5)

  write(16,*) 
  write(16,906) switch_l_eigen
906 format('   /switch/ band of  left region: ',a10)
  write(16,908) dos_on_off_ini_l
908 format('   /switch/  DOS of  left region: ',a10)
  write(16,907) switch_r_eigen
907 format('   /switch/ band of right region: ',a10)
  write(16,923) dos_on_off_ini_r
923 format('   /switch/  DOS of right region: ',a10)

  if( switch_l_eigen == 'on' .or. switch_r_eigen == 'on'                       &
       .or. dos_on_off_ini_l == 'on' .or. dos_on_off_ini_r == 'on' ) then
     write(16,*)
     write(16,919) kz_max_l,kz_max_r
919  format('               k-point mesh(l,r): ',i5,i5)
  end if
  if( switch_l_eigen == 'on' .or. switch_r_eigen == 'on' ) then
     write(16,920) eigen_s_as_ini
920  format('                 eigen calc type: ',a10)
  end if

  if( ham_model_ini /= 'rtb_h' .and. ham_model_ini /= 'gsp' ) then
     write(16,*)
     write(16,*)                                                              &
          '======================= calc ksampling ======================='
     write(16,*)

     if( filename_kpoint == '' ) then
        write(16,941) ka_tr,kb_tr
941     format('                     mesh (a,b) : (',i5,',',i5,')')
     else
        write(16,942) filename_kpoint
942     format('                    mesh (file) : ',a40)
     end if
  end if

  if( calc_type == 'trans' ) then
     write(16,*)
     write(16,*)                                                              &
          '==================== calc energy of T & G ===================='
     write(16,*)

     do i_do=1,om_block_num
        write(16,916) omega_if(i_do,1),omega_if(i_do,2)
        write(16,917) num_om_par(i_do)
     end do
916  format(f10.5,' + ',e10.5,' i ->',f10.5,' + ',e10.5,' i (eV)')
917  format('                    mesh number : ',i10)
  end if

  if( calc_type == 'iv' ) then
     write(16,*)
     write(16,*)                                                              &
          '===================== calc energy of I-V ====================='
     write(16,*)
     write(16,924) num_iv_mesh
924  format('                    mesh number : ',i10)
     write(16,922) om_sum
922  format('       imag part of calc energy : ',e10.5)
  end if

  write(16,*) 
  write(16,*)

  close(16)


  kx_max_l=1
  ky_max_l=1
  kx_max_r=1
  ky_max_r=1
  scf_bias='off'

  if( file_selfe_outsw == 'none' ) then
     file_selfe_outsw='off'
  end if
  if( file_selfe_outsw == 'exist' ) then
     file_selfe_outsw='on'
  end if

  return
end subroutine read_input_condition_ini
