! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine print_text_l

  use condition_ini
  use condition
  use constant

  implicit none
  integer :: iw_do,kz,kt
  real(8) :: temp1,temp2,param

  pai=datan(1.d0)*4.d0
  param=1.d0/pai/dfloat(mat_max_eigen*kx_max*ky_max*kz_max*ka_tr*kb_tr)

  !                       ------------------------------------                       !

  if( dos_on_off == 'on' ) then
     open(unit=31,file='nogf_l.dat')
     write(31,*) '+ total'
     write(31,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do iw_do=1,iw_max
        if( spin_switch_temp == 1 ) then
           temp1=0.d0
           do kt=1,ka_tr*kb_tr
              temp1=temp1+dos(iw_do,1,kt)
           end do
           write(31,*) dreal(omega(iw_do)),temp1*param
        else
           temp1=0.d0
           temp2=0.d0
           do kt=1,ka_tr*kb_tr
              temp1=temp1+dos(iw_do,1,kt)
              temp2=temp2+dos(iw_do,2,kt)
           end do
           write(31,*) dreal(omega(iw_do)),temp1*param,temp2*param
        end if
     end do
     close(31)
  end if

  !                       ------------------------------------                       !

  open(unit=41,file='ev_l.dat')

  write(41,*) '* cp_l=',cp
  write(41,*) '**************************************************'
  do kt=1,ka_tr*kb_tr
     write(41,*) '+  n_k=',kt
     write(41,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do kz=1,kz_max+1
        do iw_do=1,mat_max_eigen
           if( kz <= kz_max ) then
              if( spin_switch_temp == 1 ) then
                 write(41,*) kz-1,ev_mat(iw_do,kz,1,1,1,kt)
              else
                 write(41,*) kz-1,ev_mat(iw_do,kz,1,1,1,kt)                       &
                      ,ev_mat(iw_do,kz,1,1,2,kt)
              end if
           else
              if( spin_switch_temp == 1 ) then
                 write(41,*) kz-1,ev_mat(iw_do,kz-kz_max,1,1,1,kt)
              else
                 write(41,*) kz-1,ev_mat(iw_do,kz-kz_max,1,1,1,kt)                &
                      ,ev_mat(iw_do,kz-kz_max,1,1,2,kt)
              end if
           end if
        end do
     end do
     write(41,*)
  end do

  close(41)

end subroutine print_text_l

subroutine print_text_r

  use condition_ini
  use condition
  use constant

  implicit none
  integer :: iw_do,kz,kt
  real(8) :: temp1,temp2,param

  pai=datan(1.d0)*4.d0
  param=1.d0/pai/dfloat(mat_max_eigen*kx_max*ky_max*kz_max*ka_tr*kb_tr)

  !                       ------------------------------------                       !

  if( dos_on_off == 'on' ) then
     open(unit=31,file='nogf_r.dat')
     write(31,*) '+ total'
     write(31,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do iw_do=1,iw_max
        if( spin_switch_temp == 1 ) then
           temp1=0.d0
           do kt=1,ka_tr*kb_tr
              temp1=temp1+dos(iw_do,1,kt)
           end do
           write(31,*) dreal(omega(iw_do)),temp1*param
        else
           temp1=0.d0
           temp2=0.d0
           do kt=1,ka_tr*kb_tr
              temp1=temp1+dos(iw_do,1,kt)
              temp2=temp2+dos(iw_do,2,kt)
           end do
           write(31,*) dreal(omega(iw_do)),temp1*param,temp2*param
        end if
     end do
     close(31)
  end if

  !                       ------------------------------------                       !

  open(unit=41,file='ev_r.dat')

  write(41,*) '* cp_r=',cp
  write(41,*) '**************************************************'
  do kt=1,ka_tr*kb_tr
     write(41,*) '+  n_k=',kt
     write(41,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do kz=1,kz_max+1
        do iw_do=1,mat_max_eigen
           if( kz <= kz_max ) then
              if( spin_switch_temp == 1 ) then
                 write(41,*) kz-1,ev_mat(iw_do,kz,1,1,1,kt)
              else
                 write(41,*) kz-1,ev_mat(iw_do,kz,1,1,1,kt)                       &
                      ,ev_mat(iw_do,kz,1,1,2,kt)
              end if
           else
              if( spin_switch_temp == 1 ) then
                 write(41,*) kz-1,ev_mat(iw_do,kz-kz_max,1,1,1,kt)
              else
                 write(41,*) kz-1,ev_mat(iw_do,kz-kz_max,1,1,1,kt)                &
                      ,ev_mat(iw_do,kz-kz_max,1,1,2,kt)
              end if
           end if
        end do
     end do
     write(41,*)
  end do

  close(41)

end subroutine print_text_r
