! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine print_text

  use condition_ini
  use hamiltonian_sgf
  use gf_se_c
  use hamiltonian_c
  use constant

  implicit none
  integer :: iw_do,kt,i_temp,ic_spin
  real(8) :: param1,param2,param3,param4
  real(8) :: temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8
  complex(8) :: w

  if( spin_switch_cc /= 2 ) then
     ic_spin=1
  else
     ic_spin=2
  end if

  !                       ------------------------------------                       !

  pai=datan(1.d0)*4.d0
  param1=1.d0/pai/dfloat(mat_max_ll*kx_max_ll*ky_max_ll)
  param2=1.d0/pai/dfloat(mat_max_rr*kx_max_rr*ky_max_rr)
  param3=1.d0/pai/dfloat(m_mat_max_c*(kx_max_ll*kx_max_rr)**2)
  param4=1.d0/dfloat(ka_tr*kb_tr)

  !                       ------------------------------------                       !

  if( ic_spin == 1 ) then
     open(unit=30,file='sf_gf.dat')
  else
     open(unit=30,file='sf_gf_up.dat')
     open(unit=31,file='sf_gf_do.dat')
  end if
  open(unit=32,file='em_gf.dat')
  open(unit=33,file='trans.dat')
  if( ka_tr*kb_tr > 1 ) then
     open(unit=35,file='trans2.dat')
  end if

  !                       ------------------------------------                       !

  if( ic_spin == 1 ) then
     write(30,*) '+ total'
     write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     write(32,*) '+ total'
     write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     write(33,*) '+ total'
     write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do iw_do=1,iw_max_gs
        w=omega_gs(iw_do)
        temp1=0.d0
        temp2=0.d0
        temp3=0.d0
        temp4=0.d0
        do kt=1,ka_tr*kb_tr
           temp1=temp1-dimag(tr_gr_l(1,iw_do,kt))
           temp2=temp2-dimag(tr_gr_r(1,iw_do,kt))
           temp3=temp3-dimag(tr_gr_c(1,iw_do,kt))
           temp4=temp4+dreal(tr_tr(1,iw_do,kt))
        end do
        write(30,999) dreal(w),temp1*param1*param4,temp2*param2*param4
        write(32,998) dreal(w),temp3*param3*param4
        write(33,998) dreal(w),temp4*param4
     end do

     do kt=1,ka_tr*kb_tr
        write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(30,*) '+  n_k=',kt
        write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(32,*) '+  n_k=',kt
        write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(33,*) '+  n_k=',kt
        write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        do iw_do=1,iw_max_gs
           w=omega_gs(iw_do)
           write(30,997) kt,dreal(w),-dimag(tr_gr_l(1,iw_do,kt))*param1           &
                ,-dimag(tr_gr_r(1,iw_do,kt))*param2
           write(32,996) kt,dreal(w),-dimag(tr_gr_c(1,iw_do,kt))*param3
           write(33,996) kt,dreal(w),dreal(tr_tr(1,iw_do,kt))
        end do
     end do
  else
     write(30,*) '+ total'
     write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     write(31,*) '+ total'
     write(31,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     write(32,*) '+ total'
     write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     write(33,*) '+ total'
     write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
     do iw_do=1,iw_max_gs
        w=omega_gs(iw_do)
        temp1=0.d0
        temp2=0.d0
        temp3=0.d0
        temp4=0.d0
        temp5=0.d0
        temp6=0.d0
        temp7=0.d0
        temp8=0.d0
        do kt=1,ka_tr*kb_tr
           temp1=temp1-dimag(tr_gr_l(1,iw_do,kt))
           temp2=temp2-dimag(tr_gr_r(1,iw_do,kt))
           temp3=temp3-dimag(tr_gr_l(2,iw_do,kt))
           temp4=temp4-dimag(tr_gr_r(2,iw_do,kt))
           temp5=temp5-dimag(tr_gr_c(1,iw_do,kt))
           temp6=temp6-dimag(tr_gr_c(2,iw_do,kt))
           temp7=temp7+dreal(tr_tr(1,iw_do,kt))
           temp8=temp8+dreal(tr_tr(2,iw_do,kt))
        end do
        write(30,999) dreal(w),temp1*param1*param4,temp2*param2*param4
        write(31,999) dreal(w),temp3*param1*param4,temp4*param2*param4
        write(32,999) dreal(w),temp5*param3*param4,temp6*param3*param4
        write(33,999) dreal(w),temp7*param4,temp8*param4
     end do

     do kt=1,ka_tr*kb_tr
        write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(30,*) '+  n_k=',kt
        write(30,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(31,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(31,*) '+  n_k=',kt
        write(31,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(32,*) '+  n_k=',kt
        write(32,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(33,*) '+  n_k=',kt
        write(33,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        do iw_do=1,iw_max_gs
           w=omega_gs(iw_do)
           write(30,997) kt,dreal(w),-dimag(tr_gr_l(1,iw_do,kt))*param1           &
                ,-dimag(tr_gr_r(1,iw_do,kt))*param2
           write(31,997) kt,dreal(w),-dimag(tr_gr_l(2,iw_do,kt))*param1           &
                ,-dimag(tr_gr_r(2,iw_do,kt))*param2
           write(32,997) kt,dreal(w),-dimag(tr_gr_c(1,iw_do,kt))*param3           &
                ,-dimag(tr_gr_c(2,iw_do,kt))*param3
           write(33,997) kt,dreal(w),dreal(tr_tr(1,iw_do,kt))                     &
                ,dreal(tr_tr(2,iw_do,kt))
        end do
     end do
  end if

  !                       ------------------------------------                       !

  if( ka_tr*kb_tr > 1 ) then
     do iw_do=1,iw_max_gs
        write(35,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        write(35,*) '+ w =',dreal(omega_gs(iw_do))
        write(35,*) '++++++++++++++++++++++++++++++++++++++++++++++++++'
        do kt=1,ka_tr*kb_tr
           if( ic_spin == 1 ) then
              write(35,995) kt,po_kt_tr(2,kt),po_kt_tr(3,kt)                       &
                   ,dreal(tr_tr(1,iw_do,kt))
           else
              write(35,994) kt,po_kt_tr(2,kt),po_kt_tr(3,kt)                       &
                   ,dreal(tr_tr(1,iw_do,kt)),dreal(tr_tr(2,iw_do,kt))
           end if
        end do
     end do
  end if

  !                       ------------------------------------                       !

  close(30)
  if( ic_spin /= 1 ) then
     close(31)
  end if
  close(32)
  close(33)
  close(35)

999 format(3d25.15)
998 format(2d25.15)
997 format(i5,3d25.15)
996 format(i5,2d25.15)
995 format(i5,2d15.5,d25.15)
994 format(i5,2d15.5,2d25.15)

end subroutine print_text

subroutine print_text_t(w,iw_do,ispin,kt)

  use condition_ini
  use hamiltonian_sgf
  use gf_se_c
  use hamiltonian_c
  use constant

  implicit none
  integer, intent(in) :: iw_do,ispin,kt
  integer :: ic_spin
  real(8) :: param1,param2,param3
  complex(8), intent(in) :: w

  if( spin_switch_cc /= 2 ) then
     ic_spin=1
  else
     ic_spin=2
  end if

  !                       ------------------------------------                       !

  pai=datan(1.d0)*4.d0
  param1=1.d0/pai/dfloat(mat_max_ll*kx_max_ll*ky_max_ll)
  param2=1.d0/pai/dfloat(mat_max_rr*kx_max_rr*ky_max_rr)
  param3=1.d0/pai/dfloat(m_mat_max_c*(kx_max_ll*kx_max_rr)**2)

  !                       ------------------------------------                       !

  if( ic_spin == 1 ) then
     write(55,997) kt,dreal(w),-dimag(tr_gr_l(1,iw_do,kt))*param1             &
          ,-dimag(tr_gr_r(1,iw_do,kt))*param2
     write(57,996) kt,dreal(w),-dimag(tr_gr_c(1,iw_do,kt))*param3
     write(58,996) kt,dreal(w),dreal(tr_tr(1,iw_do,kt))
  else
     write(55,997) kt,dreal(w),-dimag(tr_gr_l(1,iw_do,kt))*param1             &
          ,-dimag(tr_gr_r(1,iw_do,kt))*param2
     write(56,997) kt,dreal(w),-dimag(tr_gr_l(2,iw_do,kt))*param1             &
          ,-dimag(tr_gr_r(2,iw_do,kt))*param2
     if( ispin == 2) then
        write(57,997) kt,dreal(w),-dimag(tr_gr_c(1,iw_do,kt))*param3             &
             ,-dimag(tr_gr_c(2,iw_do,kt))*param3
        write(58,997) kt,dreal(w),dreal(tr_tr(1,iw_do,kt))                       &
             ,dreal(tr_tr(2,iw_do,kt))
     end if
  end if

997 format(i5,3d25.15)
996 format(i5,2d25.15)

end subroutine print_text_t
