! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine Atom__set(atom,name,Ro,Rc,Q,number,polarization,optimize)
  use ac_misc_module

  implicit none
  type(Atom_type), intent(out) :: atom
  real(8), intent(in) :: Ro(3)
  character(5), intent(in) :: name
  real(8), intent(in) :: Rc
  real(8), intent(in) :: Q
  real(8), intent(in) :: polarization
  integer, intent(in) :: number
  logical, intent(in) :: optimize
  
  atom%name     = name
  atom%Ro       = Ro
  atom%Rc       = Rc
  atom%Q        = Q
  atom%number   = number
  atom%polarization = polarization
  atom%force    = 0.d0
  atom%optimize = optimize
  atom%opt_position = Ro
  atom%opt_direction = 0.d0
  atom%force_past => null()

  return
end subroutine Atom__set

subroutine Atom__deallocate( atom )
  use ac_misc_module

  implicit none
  type(Atom_type), intent(out) :: atom

  if( associated(atom%force_past) ) deallocate(atom%force_past)

  return
end subroutine Atom__deallocate
