! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_hami_c_cc_input( desc, ispin )

  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_temp
  use constant
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: desc
  integer, intent(in) :: ispin

  hcc_mat(:,:) = hcc_t(:,:,ispin) 
  scc_mat(:,:) = scc_t(:,:) 

  return
end subroutine set_hami_c_cc_input

subroutine set_hami_c_ll_input(descCL,descLL,ispin)
  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_e
  use hamiltonian_temp
  use scf_negf
  use constant
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCL, descLL
  integer, intent(in) :: ispin

  integer :: i, j
  complex(8), allocatable :: work(:,:)

  allocate( work(descLL%nrow, descLL%ncol) )

  do j=descLL%scol,descLL%ecol
     do i=1,descLL%nrow
        work(i,j) = h01_l_t(i,j,ispin) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descLL, work )

  do j=descCL%scol,descCL%ecol
     do i=1,descCL%nrow
        if( i > descLL%nrow ) cycle
        hcl_mat(i,j) = work(i,j) 
     end do
  end do

  do j=descLL%scol,descLL%ecol
     do i=1,descLL%nrow
        work(i,j) = s01_l_t(i,j) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descLL, work )

  do j=descCL%scol,descCL%ecol
     do i=1,descCL%nrow
        if( i > descLL%nrow ) cycle
        scl_mat(i,j) = work(i,j) 
     end do
  end do

  deallocate(work)

  return
end subroutine set_hami_c_ll_input

subroutine set_hami_c_rr_input(descCR,descRR,ispin)
  use condition_ini
  use hamiltonian_sgf
  use hamiltonian_c
  use hamiltonian_e
  use hamiltonian_temp
  use scf_negf
  use constant
  use ac_mpi_module

  implicit none
  type(MPI_MatDesc), intent(in) :: descCR, descRR
  integer, intent(in) :: ispin

  integer :: i, j
  complex(8), allocatable :: work(:,:)

  allocate( work(descRR%nrow, descRR%ncol) )

  do j=descRR%scol,descRR%ecol
     do i=1,descRR%nrow
        work(i,j) = h01_r_t(i,j,ispin) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descRR, work )

  do j=descCR%scol,descCR%ecol
     do i=1,descCR%nrow
        if( i<=descCR%nrow-descRR%nrow ) cycle
        hcr_mat(i,j) = work(i-descCR%nrow+descRR%nrow,j) 
     end do
  end do

  do j=descRR%scol,descRR%ecol
     do i=1,descRR%nrow
        work(i,j) = s01_r_t(i,j) 
     end do
  end do

  call MPI__Allgather_MatrixM_ASCOT( descRR, work )

  do j=descCR%scol,descCR%ecol
     do i=1,descCR%nrow
        if( i<=descCR%nrow-descRR%nrow ) cycle
        scr_mat(i,j) = work(i-descCR%nrow+descRR%nrow,j) 
     end do
  end do

  deallocate(work)

  return
end subroutine set_hami_c_rr_input
