! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module hamiltonian_e

  implicit none
  integer :: mat_max
  integer, allocatable :: itemp(:,:,:),jtemp(:)
  complex(8), pointer :: h00_mat(:,:),h01_mat(:,:),h10_mat(:,:) 
  complex(8), pointer :: s00_mat(:,:),s01_mat(:,:),s10_mat(:,:) 

contains
  subroutine alo_hamiltonian_input(desc)
    use ac_mpi_module
    implicit none
    type(MPI_MatDesc), intent(in) :: desc 
    integer :: ier

    allocate(h00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_input'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    h01_mat(:,:) = dcmplx(0.d0,0.d0) 
    h10_mat(:,:) = dcmplx(0.d0,0.d0) 

    s00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s01_mat(:,:) = dcmplx(0.d0,0.d0) 
    s10_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_input

  subroutine unset_hamiltonian_input

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_input'
       stop
    end if

    return
  end subroutine unset_hamiltonian_input

  subroutine alo_hamiltonian_free(desc,num_atom,num_unit)
    use ac_mpi_module
    implicit none

    type(MPI_MatDesc), intent(in) :: desc 
    integer, intent(in) :: num_atom, num_unit(3)
    integer :: ier

    allocate(itemp(num_unit(1),num_unit(2),num_atom),stat=ier)

    allocate(h00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_free'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    h01_mat(:,:) = dcmplx(0.d0,0.d0) 
    h10_mat(:,:) = dcmplx(0.d0,0.d0) 
    s00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s01_mat(:,:) = dcmplx(0.d0,0.d0) 
    s10_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_free

  subroutine unset_hamiltonian_free

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,itemp,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_free'
       stop
    end if

    return
  end subroutine unset_hamiltonian_free

  subroutine alo_hamiltonian_periodic(desc,num_atom)
    use ac_mpi_module
    implicit none

    type(MPI_MatDesc), intent(in) :: desc 
    integer, intent(in) :: num_atom
    integer :: ier

    allocate(jtemp(num_atom),stat=ier)
    allocate(h00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(h10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s00_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s01_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    allocate(s10_mat(desc%nrow, desc%scol:desc%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_periodic'
       stop
    end if

    h00_mat(:,:) = dcmplx(0.d0,0.d0) 
    h01_mat(:,:) = dcmplx(0.d0,0.d0) 
    h10_mat(:,:) = dcmplx(0.d0,0.d0) 
    s00_mat(:,:) = dcmplx(0.d0,0.d0) 
    s01_mat(:,:) = dcmplx(0.d0,0.d0) 
    s10_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hamiltonian_periodic

  subroutine unset_hamiltonian_periodic

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,jtemp,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_periodic'
       stop
    end if

    return
  end subroutine unset_hamiltonian_periodic

end module hamiltonian_e
