! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@             Naoki WATANABE (Mizuho I.R.)                       @@ !
! @@             Nobutaka NISHIKAWA (Mizuho I.R.)                   @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module hamiltonian_c

  implicit none
  integer :: m_mat_max_l,m_mat_max_c,m_mat_max_r
  integer :: spin_switch_cc

  integer, allocatable :: itemp_l(:,:,:)
  integer, allocatable :: itemp_r(:,:,:)
  integer, allocatable :: itemp_c(:)

  complex(8), pointer :: hcc_mat(:,:) 
  complex(8), pointer :: hcl_mat(:,:) 
  complex(8), pointer :: hcr_mat(:,:) 
  complex(8), pointer :: scc_mat(:,:) 
  complex(8), pointer :: scl_mat(:,:) 
  complex(8), pointer :: scr_mat(:,:) 

contains
  subroutine alo_hami_c(num_atom_ctotal,num_atom_l,num_atom_r                       &
       ,num_unit_temp11,num_unit_temp12,num_unit_temp21,num_unit_temp22)

    implicit none
    integer, intent(in) :: num_atom_ctotal
    integer, intent(in) :: num_atom_l,num_atom_r
    integer, intent(in) :: num_unit_temp11,num_unit_temp12
    integer, intent(in) :: num_unit_temp21,num_unit_temp22
    integer :: ier

    allocate(itemp_l(num_unit_temp11,num_unit_temp12,num_atom_l)                 &
         ,itemp_r(num_unit_temp21,num_unit_temp22,num_atom_r)                 &
         ,itemp_c(num_atom_ctotal),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hami_c'
       stop
    end if

    return
  end subroutine alo_hami_c

  subroutine unset_hami_c

    implicit none
    integer :: ier

    deallocate(itemp_l,itemp_r,itemp_c,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hami_c'
       stop
    end if

    return
  end subroutine unset_hami_c

  subroutine alo_hami_c1( descCL )
    use ac_mpi_module

    implicit none
    type(MPI_MatDesc), intent(in) :: descCL

    integer :: ier

    allocate(hcl_mat(descCL%nrow, descCL%scol:descCL%ecol),stat=ier) 
    allocate(scl_mat(descCL%nrow, descCL%scol:descCL%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hami_c1'
       stop
    end if

    hcl_mat(:,:) = dcmplx(0.d0,0.d0) 
    scl_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hami_c1

  subroutine unset_hami_c1

    implicit none
    integer :: ier

    deallocate(hcl_mat,scl_mat,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hami_c1'
       stop
    end if

    return
  end subroutine unset_hami_c1

  subroutine alo_hami_c2( descCR )
    use ac_mpi_module

    implicit none
    type(MPI_MatDesc), intent(in) :: descCR

    integer :: ier

    allocate(hcr_mat(descCR%nrow, descCR%scol:descCR%ecol),stat=ier) 
    allocate(scr_mat(descCR%nrow, descCR%scol:descCR%ecol),stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hami_c2'
       stop
    end if

    hcr_mat(:,:) = dcmplx(0.d0,0.d0) 
    scr_mat(:,:) = dcmplx(0.d0,0.d0) 

    return
  end subroutine alo_hami_c2

  subroutine unset_hami_c2

    implicit none
    integer :: ier

    deallocate(hcr_mat,scr_mat,stat=ier) 
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hami_c2'
       stop
    end if

    return
  end subroutine unset_hami_c2

  subroutine alo_hami_c3( descCC )
    use ac_mpi_module

    implicit none
    type(MPI_MatDesc), intent(in) :: descCC
    integer :: ier

    allocate( hcc_mat(descCC%nrow, descCC%scol:descCC%ecol), stat=ier )
    allocate( scc_mat(descCC%nrow, descCC%scol:descCC%ecol), stat=ier )
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hami_c3'
       stop
    end if
    hcc_mat(:,:) = dcmplx(0.d0,0.d0)
    scc_mat(:,:) = dcmplx(0.d0,0.d0)

    return
  end subroutine alo_hami_c3

  subroutine unset_hami_c31

    implicit none
    integer :: ier

    deallocate(hcc_mat,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hami_c3'
       stop
    end if

    return
  end subroutine unset_hami_c31

  subroutine unset_hami_c32

    implicit none
    integer :: ier

    deallocate(scc_mat,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hami_c3'
       stop
    end if

    return
  end subroutine unset_hami_c32

end module hamiltonian_c
