! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module gsp_parameter

  implicit none
  character(4), pointer :: atom_parameter(:,:)
  real(8), pointer :: r0(:),n(:),e_0(:),hs(:),hp(:),hd_t2g(:),hd_eg(:)
  real(8), pointer :: h_sss(:),h_sps(:),h_pps(:),h_ppp(:),h_sds(:)
  real(8), pointer :: h_pds(:),h_pdp(:),h_dds(:),h_ddp(:),h_ddd(:)
  real(8), pointer :: nc_sss(:),nc_sps(:),nc_pps(:),nc_ppp(:),nc_sds(:)
  real(8), pointer :: nc_pds(:),nc_pdp(:),nc_dds(:),nc_ddp(:),nc_ddd(:)
  real(8), pointer :: rc_sss(:),rc_sps(:),rc_pps(:),rc_ppp(:),rc_sds(:)
  real(8), pointer :: rc_pds(:),rc_pdp(:),rc_dds(:),rc_ddp(:),rc_ddd(:)
  real(8), pointer :: m(:),mc(:),dc(:),c1(:),c2(:),c3(:),c4(:)
  real(8), pointer :: phi0(:),d0(:),r1(:),tsc0(:),tsc1(:),tsc2(:),tsc3(:)
  real(8), pointer :: d1(:),tpc0(:),tpc1(:),tpc2(:),tpc3(:),cutoff_r(:)

contains
  subroutine alo_gsp_parameter(num_atom_kind)

    implicit none
    integer, intent(in) :: num_atom_kind
    integer :: i_temp,ier

    i_temp=num_atom_kind*num_atom_kind

    allocate(atom_parameter(i_temp,2),r0(i_temp),n(i_temp),e_0(i_temp)           &
         ,hs(i_temp),hp(i_temp),hd_t2g(i_temp),hd_eg(i_temp)                        &
         ,h_sss(i_temp),h_sps(i_temp),h_pps(i_temp),h_ppp(i_temp),h_sds(i_temp)     &
         ,h_pds(i_temp),h_pdp(i_temp),h_dds(i_temp),h_ddp(i_temp),h_ddd(i_temp)     &
         ,nc_sss(i_temp),nc_sps(i_temp),nc_pps(i_temp),nc_ppp(i_temp),nc_sds(i_temp)&
         ,nc_pds(i_temp),nc_pdp(i_temp),nc_dds(i_temp),nc_ddp(i_temp),nc_ddd(i_temp)&
         ,rc_sss(i_temp),rc_sps(i_temp),rc_pps(i_temp),rc_ppp(i_temp),rc_sds(i_temp)&
         ,rc_pds(i_temp),rc_pdp(i_temp),rc_dds(i_temp),rc_ddp(i_temp),rc_ddd(i_temp)&
         ,m(i_temp),mc(i_temp),dc(i_temp),c1(i_temp),c2(i_temp),c3(i_temp)          &
         ,c4(i_temp),phi0(i_temp),r1(i_temp),tsc0(i_temp),tsc1(i_temp),tsc2(i_temp) &
         ,tsc3(i_temp),d1(i_temp),tpc0(i_temp),tpc1(i_temp),tpc2(i_temp)            &
         ,tpc3(i_temp),d0(i_temp),cutoff_r(i_temp),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_gsp_parameter'
       stop
    end if

    return
  end subroutine alo_gsp_parameter

  subroutine unset_gsp_parameter

    implicit none
    integer :: ier

    deallocate(atom_parameter,r0,n,e_0,hs,hp,hd_t2g,hd_eg                        &
         ,h_sss,h_sps,h_pps,h_ppp,h_sds,h_pds,h_pdp,h_dds,h_ddp,h_ddd           &
         ,nc_sss,nc_sps,nc_pps,nc_ppp,nc_sds,nc_pds,nc_pdp,nc_dds,nc_ddp,nc_ddd &
         ,rc_sss,rc_sps,rc_pps,rc_ppp,rc_sds,rc_pds,rc_pdp,rc_dds,rc_ddp,rc_ddd &
         ,m,mc,dc,c1,c2,c3,c4,phi0,r1,tsc0,tsc1,tsc2,tsc3,d1,tpc0,tpc1,tpc2,tpc3&
         ,d0,cutoff_r,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_gsp_parameter'
       stop
    end if

    return
  end subroutine unset_gsp_parameter

end module gsp_parameter
