! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module dft

  implicit none
  real(8), pointer :: r_tem(:,:),p_tem(:,:),r_tem_z(:,:),p_tem_z(:,:)
  complex(8), pointer :: fft_in(:),fft_out(:),fft_in_z(:),fft_out_z(:)

contains
  subroutine alo_dft(n_a,n_b,i_dim)

    implicit none
    integer, intent(in) :: n_a,n_b,i_dim
    integer :: i_temp,ier

    i_temp=n_a*n_b
    allocate(fft_in(i_temp),fft_out(i_temp)                                      &
         ,r_tem(i_dim,i_temp),p_tem(i_dim,i_temp),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_dft'
       stop
    end if

    return
  end subroutine alo_dft

  subroutine unset_dft

    implicit none
    integer :: ier

    deallocate(fft_in,fft_out,r_tem,p_tem,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_dft'
       stop
    end if

    return
  end subroutine unset_dft

  subroutine alo_dft_z(n_c)

    implicit none
    integer, intent(in) :: n_c
    integer :: ier

    allocate(fft_in_z(n_c),fft_out_z(n_c)                                        &
         ,r_tem_z(1,n_c),p_tem_z(1,n_c),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_dft'
       stop
    end if

    return
  end subroutine alo_dft_z

  subroutine unset_dft_z

    implicit none
    integer :: ier

    deallocate(fft_in_z,fft_out_z,r_tem_z,p_tem_z,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_dft'
       stop
    end if

    return
  end subroutine unset_dft_z

end module dft
