! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.53)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine ac_main( filename )
  use ac_parameter
  use ac_mpi_module
  implicit none

  character(len=*), intent(in) :: filename

  integer scount, ecount, rate, count_max

  call system_clock(scount, rate, count_max )

  call Param__read(filename)

  call Param__setup(0)

  call Param__show

  if( Param%Option%optimize ) then
     if( Param%SCF%opt_iter_max == 0 ) then
        call ac_solve
        call Force__calc
        call Force__show
     else
        call ac_optimize
     end if
  else
     call ac_solve
  end if

  if( Param%Band%fname /= "" ) then
     call Hamiltonian__calcBandMap
  end if

  if( Param%DOS%fname /= "" ) then
     call Hamiltonian__calcDOS
  end if

  if( Param%MO%fbase /= "" ) then
     call Hamiltonian__calcMO
  end if

  call Hamiltonian__deallocate
  call Potential__deallocate
  call Density__deallocate
  call Base__deallocate
  call Param__deallocate

  open(unit=16,file=Param%Option%file_ac_tempout,position='append')
  write(16,*)
  write(16,*) '******************** **************** ********************'
  write(16,*) '*                      output files                      *'
  write(16,*) '******************** **************** ********************'
  write(16,*)
  write(16,*) '          Chemical potential & Total energy -> energy.dat'
  write(16,*) '                               Energy level -> level_**.dat'
  write(16,*) '                             charge at site -> charge_per.dat'
  if( Param%Option%optimize ) then
     write(16,*) '                                 Force data -> force.dat'
     if( Param%SCF%opt_iter_max /= 0 ) then
        write(16,*) '                             Structure data -> structure.dat'
     end if
  end if
  write(16,*)
  write(16,*)
  write(16,*)
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:           finished         :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:                            :-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*) ':-:-:-:-:-:-:-:-:-:-:-:-:-:-:-::-:-:-:-:-:-:-:-:-:-:-:-:-:-:-:'
  write(16,*)
  close(16)

  call system_clock(ecount, rate, count_max )
  !!if(MPI%root) write(*,*) 'execute time: ', real(ecount-scount)/rate, '(sec)'

  return
end subroutine ac_main

subroutine ac_solve
  use ac_parameter
  use ac_mpi_module
  implicit none

  call MPI__setup

  call Base__setup

  call Density__setup

  call Potential__setup

  call Hamiltonian__calcSCF

  return
end subroutine ac_solve

